/* /AC /Ox /FPc */
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <dos.h>
#include <bios.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <setjmp.h>
#include <conio.h>
#include <signal.h>
#include <float.h>
#include <dirent.h>
#include <ctype.h>
#include <mem.h>
#include <errno.h>

#include "em.h"

typedef unsigned int radix50;


void readboot(void);

//int FIWRQQ = 0;
//int FIDRQQ = 0;

#define MEMSIZ  65535
#define word(a) (*(int far *)&memory[a])
#define PC      r[7]
#define SP      r[6]
#define PSW     word(0177776)
#define TTKS    memory[0177560]
#define TTKB    memory[0177562]
#define TTPS    memory[0177564]
#define TTPB    memory[0177566]
#define LPS     memory[0177514]
#define LPB     memory[0177516]
#define T       020
#define N       010
#define Z       04
#define V       02
#define C       01

#define EmulatorSpeedPoll  1

char far memory[MEMSIZ] = {
        012700,012700/256,
        012345,012345/256,
        010001,010001/256,
        010137,010137/256,
        0100,0
};


//char *title = "DEC PDP11 (R) Software emulator v2.1    SOS (C) 1989-1992      ^R reg.  ^X  quit";
char *title   = "DEC PDP11 emulator v1.9  MIG 2003                                            F10";


const char  R50_CHARS[]={ ' ',
                      'A','B','C','D','E','F','G','H','I','J','K','L','M',
                      'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
                      '$','.','/','0','1','2','3','4','5','6','7','8','9'};

char strNotRecodedFileExt[]="SAV OBJ SYS BIN LIB SML BAC DAT LDA REL";


#define MAX_RT11_FILES 2230
#define AKH            2048
#define DOS_HD_SIZE    65068

#define DSK_TYPE       1
#define DIR_TYPE       -1

#define TEMP_FILE      0400
#define EMPT_FILE      01000
#define NORM_FILE      02000
#define PROT_FILE      0100000

#define FIRST_BLOCKS_SIZE  35328

int r[9]={0};
int ir=0;
int src=0, dst=0;
int byte=0;
int wasttr=0;
int wasfpe=0;

int rus_flag=0;

//int res_PSW, res_PSW_flag;
//int test_PSW_flag;
int di, ax, cx;
int FL1, FL2, FL3, FL4;


extern near dstoff;
extern void far intrr(int),ctrlc(),fperr(int,int);
extern clr(),clrb(),com(),comb(),inc(),incb(),dec(),decb(),neg(),negb();
extern adc(),adcb(),sbc(),sbcb(),tst(),tstb(),ror(),rorb(),rol(),rolb();
extern asr(),asrb(),asl(),aslb(),mark(),mfpi(),mtpi(),sxt(),mov(),movb();
extern cmp(),cmpb(),bit(),bitb(),bic(),bicb(),bis(),bisb(),add(),sub();
extern sob(),eis(),illop(void),mtps(),mfps();
extern mul(void),divv(void);
extern ash(void),ashc(void),xor(void),jadst(void),swabb(void),reset(void);

//extern void intrchk(void); 

//extern initov(void);
//extern  getfl(void), setfl(void);
//extern  near adst(void);

extern int errno;

extern int  nCodePage;
extern void MirrorFile( int, char* );

extern void ConvertFileName( struct ffblk* );
extern void CheckCodePage( int );
extern unsigned int timer0(void);



int pop(void); void push(int);
short far gettty();



int trace=0;
int step =0;
int tinfo=0;
int f[8];
int foffs=0;
int dzf=0;

jmp_buf env;

//int directvideo = 0;

//

#define  HD_CheckUnit     0
#define  HD_SetUnit       1
#define  HD_SetBlockNum   2
#define  HD_SetBufAddr    3
#define  HD_SetWordCount  4
#define  HD_Read          5
#define  HD_Write         6
#define  HD_Get_Unit_Size 7
#define  HD_Refresh       8


void CursorON( void );
void HD_device_init(void);
void HD_device_command( unsigned int );
void HD_set_data_word( unsigned int );
void RemountHD( unsigned int );


//void HDOpenDSK( char* );
int HDReadDSK( unsigned int, unsigned int, unsigned int, unsigned int );
int HDWriteDSK( unsigned int, unsigned int, unsigned int, unsigned int );

void CreateXFile(void);
void CreateManyFiles( int );

void ReadIniFile( char* );
int  UseIniStr( char* );
void GetItem( char**, char* );

char strTmpDir[] = "TMP.TMP";
char strBootFileName[] = "bootsect.bin";

int  nNextRT11FileHDnum;


//int  boot_unit;
int            nDSKtype[9];
unsigned char far *(apnFirstBlocks[9]);
int            hDSK[9];
char           *apcPath[9];
unsigned long  anDSKlen[9];

int *nInputCache;
unsigned int nInputCacheSize = 65000;

//         //

struct ArrFileSpecType {
  char          Name[12];
  char          Ext[4];
  unsigned int  Block;
  unsigned int  Size;
  unsigned int  Date;
  int           Type;
} ArrFileSpec;

struct ArrFileSpecType *pArrFileSpec;

//        //

struct ArrFileSpecType *pArrFiles;

unsigned int nArrHDnum;
unsigned int nArrBlockNum;


enum { LOG_OFF, LOG_ON, LOG_SUSPENDED };

struct LogFileDataType {
       char FileName[120];
       int  AppendFlag;
       int  LogState;
} LogFileData;

int hHDLogFile;
void cpu_act(void);

void HDInitLogFileData(void);
//void HDBeginLog(  char , int );
void HDBeginLog(void);
void HDLogFileStrOut( char* );

void set_trap_vector( int nIntNum, void interrupt (*trap)(void) );



//        -
//        :)

unsigned int  HD_Unit = 0;
unsigned int  HD_BlockNum = 2;
unsigned int  HD_BufAddr = 1000;
unsigned int  HD_WordCount = 2000;
unsigned int  HD_Data;

int nBootHDnum = 0;
int nBootRt11Flag = 0;

int mem0[80];
int memflag;


int nRecodeFlag = 1;
int nInternalCP_KOI7 = 1;
int nExternalCP_WIN  = 1;

//
//
//
int div_sign;

time_t             CurrTime;
time_t             LastEmulatorPoll = 0;
time_t             TimeSlice;
unsigned long int  nFetchCount = 0;

static int  cursor_off = 0;
static int  tty_flag = 0;

unsigned int  nCpuActCount = 0;

unsigned int speed = 2000;

static unsigned long nCPU_Speed = 0;
static unsigned long nBulk_CPU_Speed = 0;
static long nCPU_Delay = 0;
//static long nCPU_Limit = 300000;
static long nCPU_Limit = 0;
static long nOpS;
static long nLoopsOp;

//unsigned long nBPS_Limit = 14400;
unsigned long nBPS_Limit = 0;
unsigned int  nCPS;
unsigned int  nCPS_Limit;
unsigned long nCPS_Delay;
unsigned int  nCPS_Count = 0;

//unsigned char cAttribute = 0x17;
//unsigned int  nTitleX;

unsigned int  nTimerHi;

int           nNormalCursor = 0;


int    nFindFirstFlag;
struct ffblk ffblk; //  findfirst .. findnext

radix50 nFileName1;
radix50 nFileName2;
radix50 nFileExt;
unsigned int  nFileSize;
unsigned int  nFileDate;
int           nFileType;

char          LookupFileName[20];
unsigned int  LookupFileBlock;

char str[512];
char str1[512];
char str2[512];


char  cKeyCode;
char  cKeyCode2;
int   nShift_Flag = 0;
int   nCtrl_Flag = 0;
int   nAlt_Flag = 0;
int   nChar_Flag = 0;
int   nInt15_Skip_Flag = 0;
int   nExt_Flag = 0;

int   nInserted_Key = 0;

int   nKeyCheck_flag;
int   nKeyInterrupt_flag;
int   nScreenInterrupt_flag;
int   nInterrupt_flag;

int   escflg2;

void interrupt (*old_15)( void );


extern void interrupt int15( void );

//void interrupt int15( void )
//{
//  old_15() ;			//	  .
//}

//*
void far Process_Int15( )
{
//
//      Int 15h .
//
//	     BIOS   
//	   .
//
//
  nInt15_Skip_Flag = 0;

  nKeyCheck_flag++;

  asm {
          MOV  cKeyCode2, AH
          MOV  cKeyCode, AL
      };

  if( cKeyCode2 == 0x4F )
  {
    switch (cKeyCode)
    {
      case -32:

        nExt_Flag++;

      break;

      //

      case 31: // ^S

        if( !nAlt_Flag && nCtrl_Flag)
        {
          nInt15_Skip_Flag++;
          nInserted_Key = 19; // ^S
        }

        nExt_Flag = 0;
        nChar_Flag++;

      break;

      //

      case 46: // ^C

        if( !nAlt_Flag && nCtrl_Flag)
        {
          nInt15_Skip_Flag++;
          nInserted_Key = 3; // ^C
        }

        nExt_Flag = 0;
        nChar_Flag++;

      break;

      //

      case 54:
      case 42:

        nShift_Flag++;
        nChar_Flag++;
        nExt_Flag = 0;

      break;

      //

      case -86:
      case -74:

        nShift_Flag = 0;
        nChar_Flag++;
        nExt_Flag = 0;

      break;

      //

      case 29:

        nCtrl_Flag++;
        nChar_Flag++;
        nExt_Flag = 0;

      break;

      //

      case -99:

        nCtrl_Flag = 0;
        nChar_Flag++;
        nExt_Flag = 0;

      break;

      //

      case 56:

        nAlt_Flag++;
        nChar_Flag = 0;
        nExt_Flag = 0;

      break;

      //
      //      <Alt>  ^N
      //     <Alt>  ^O
      //

      case -72:

        nAlt_Flag = 0;

        if( !nExt_Flag )
        {
          if( !nChar_Flag && !nCtrl_Flag && !nShift_Flag )
          {
            nInserted_Key = 14; // ^N
          }
        }
        else
        {
          if( !nChar_Flag && !nCtrl_Flag && !nShift_Flag )
          {
            nInserted_Key = 15; // ^O
          }
        }

        nExt_Flag = 0;

      break;

      //

      default:

        nExt_Flag = 0;
        nChar_Flag++;

      break;
    }

  }
  else
  {
//    old_15() ;			//	  .
  }

}
//*/

void int15_on( void ) {
//
//	   int1C    
//	  1Ch.
//
	 old_15 = getvect(0x15);   //     .

	 setvect( 0x15, int15 );	 //    .
} ;
#pragma startup int15_on


void int15_off( void ) {
//
//	   1C   .
//
		setvect(0x15, old_15);
} ;
#pragma exit int15_off



void interrupt (*old_1C)(void);

void interrupt int1C() {
//                                                                    //
//      Int 1Ch .                                 //
//                                                                    //
//        BIOS     //
//      (  )  .                        //
//                                                                    //
//                                                                    //


   nCpuActCount++;
   nTimerHi++;

   if( cursor_off )
   {
      if( --tty_flag <= 0 )
      {
        CursorON();
      }
   };

   old_1C() ;     //        .             //
} ;

//
//
//
void int1C_on( void ) {
//                                                                    //
//      int1C       //
//    1Ch.                                                  //
//                                                                    //
   old_1C = getvect(0x1C);   //     . //
                             //                                       //
   setvect( 0x1C, int1C );   //    .         //
//   printf("Int_1C handler installed\n");
} ;

#pragma startup int1C_on

//
//
//


void int1C_off( void ) {
//                                                                   //
//         1C   .   //
//                                                                   //
   setvect(0x1C, old_1C);
//   printf("Int_1C handler removed\n");
} ;

#pragma exit int1C_off

//
//
//

void CursorON( void )
{
  tty_flag = 0;
  cursor_off = 0;

  if( nNormalCursor )
  {
    _setcursortype(_NORMALCURSOR);
  }
  else
  {
    _setcursortype(_SOLIDCURSOR);
  }

//  asm {
//        mov cx, 0x0006
//        mov ax, nCursorBegin
//        mov ch, al
//        mov ax, nCursorEnd
//        mov cl, al
//        mov ah, 1
//        Int 0x10
//  }

}

void CursorOFF( void )
{
  if( !cursor_off )
  {
    tty_flag = 2;
    cursor_off = 1;
    _setcursortype(_NOCURSOR);
  }
}

//
//

void Calculate_CPU_Speed( void )
{
  int i = 0;
  unsigned int x;

  nCpuActCount = 0;
  while( !nCpuActCount );

  nCpuActCount = 0;
  while( !nCpuActCount )
  {
    if( nBulk_CPU_Speed++ < 0xFFFFFFFE ) { continue; }
  }

  nCPU_Speed = nBulk_CPU_Speed;
  nBulk_CPU_Speed = 0;

  while( i++ < 5 )
  {
    nCpuActCount = 0;
    while( !nCpuActCount )
    {
      if( nBulk_CPU_Speed++ < 0xFFFFFFFE ) { continue; }
    }
    nCPU_Speed = (nCPU_Speed + nBulk_CPU_Speed)/2;
//    printf(" CPU_Speed -[%lu]\n", nBulk_CPU_Speed );
    nBulk_CPU_Speed = 0;
  }

//  printf(" CPU_Speed -[%lu]\n", nCPU_Speed );
//  getch();
  nCPS_Limit = nBPS_Limit/10;
  if( nCPS_Limit )
  {
    nCPS_Delay = (65530*36)/nCPS_Limit;
  }


//  printf("                          nCPS_Limit/18 -[%u]\n", x );
//  printf("                          nCPS_Delay -[%lu]\n", nCPS_Delay );
//  getch();
}


void Sleep( int delay )
{
  unsigned int i,x;
  for( i = 0 ; i < delay ; i++ ) { x = timer0(); }
}


//void TitlePuts( int x, char *str )
//{
//  unsigned int xx = (unsigned)x;
//  int i, len = strlen(str);
//  int sim;
//
//  if( x < 0 ) { xx = nTitleX; }
//
//  xx *= 2;
//
//  for( i = 0 ; i < len ; i++ )
//  {
//    sim = str[i];
//
//    asm {
//           push es
//           push bx
//           push ax
//
//           mov  ax, 0xB800
//           mov  es, ax
//
//           mov  ax, sim
//           mov  ah, cAttribute
//
//           mov  bx, xx
//           mov  es:[bx], ax
//
//           pop  ax
//           pop  bx
//           pop  es
//    }
//
//    xx += 2;
//  }
//  nTitleX = xx/2;
//}


//unsigned int nZVector0;
//unsigned int nZVector2;
//
//int  zero_div_flag = 0;
//int  zero_div_on_flag = 0;
//
//void interrupt (*old_zero_div)(void);
//
//void interrupt zero_div() {
//  //                                                                    //
//  //      Int 00h .                                 //
//  //                                                                    //
//  //                   //
//  //       .                                    //
//  //                                                                    //
//  //                                                                    //
//
//   asm {
//          sti
//   };
//
//   zero_div_flag++;
//
//} ;


//
//
//void zero_div_on( void ) {
//  //                                                                       //
//  //      zero_div       //
//  //    00h.                                                     //
//  //                                                                       //
//   zero_div_on_flag++;
//
//   old_zero_div = getvect(0x00);  //     . //
//                                  //                                       //
// //   setvect( 0x00, zero_div );     //    .         //
//
//set_trap_vector( 0, zero_div );
//
//   printf("Int_00 handler installed\n");
//} ;
//
//#pragma startup zero_div_on

//
//
//


//void zero_div_off( void ) {
//  //                                                                   //
//  //         00   .   //
//  //                                                                   //
//   if( zero_div_on_flag )
//   {
//     setvect(0x00, old_zero_div);
//     printf("Int_00 handler removed\n");
//     zero_div_on_flag = 0;
//   }
//} ;
//
//#pragma exit zero_div_off




//#define max_trap_number 0xF0
//
//void interrupt (*traps[0xFF+12])(void);
//int  trap_counts[0xFF+12];
//int  total_trap_count;
//
//void interrupt trap_handler(void);
//
//void set_trap_vector( int nIntNum, void interrupt (*trap)(void) )
//{
//  unsigned long lHandlerFar = trap;
//  unsigned int  nOfs;
//  unsigned int  nSeg;
//  unsigned long pHandlerPtr;
//  int           nIntOffset = nIntNum*4;
//
//  asm {
//        mov    ax, WORD PTR lHandlerFar
//        mov    nOfs, ax
//
//        mov    ax, WORD PTR lHandlerFar+2
//        mov    nSeg, ax
//  };
//
//  pHandlerPtr  = nSeg;
//  pHandlerPtr *= 16;
//  pHandlerPtr += nOfs;
//
//  nSeg = nIntNum*2;
//  nOfs = pHandlerPtr - nSeg*16;
//
//  if( (long)(pHandlerPtr-(long)(nSeg*16)) > 0xFF00 )
//  {
//    printf("set_trap_vector: Error at Int_%03X 'HANDLER TOO FAR'\n", nIntNum );
//    while(!kbhit());getch();
//  }
//  else
//  if( pHandlerPtr-nSeg*16 < 0 )
//  {
//    printf("set_trap_vector: Error at Int_%03X 'HANDLER TOO NEAR'\n", nIntNum );
//    while(!kbhit());
//  }
//
//
//  asm{
//       cli
//
//       xor    ax, ax
//       mov    es, ax
//       mov    bx, nIntOffset
//
//       mov    ax, nOfs
//       mov    es:[bx], ax
//
//       add    bx, 2
//       mov    ax, nSeg
//       mov    es:[bx], ax
//
//       sti
//  };
//
//}
//
//
//void traps_on( void )
//{
// int i;
//
//  for( i = 0 ; i <= max_trap_number ; i++ )
//  {
//    traps[i] = getvect(i);  //     . //
//                                   //                                       //
//    trap_counts[i] = 0;
//    total_trap_count = 0;
//
//    if( i == 0x21 ) { continue; }
//
// //   setvect( i, trap_handler );     //    .         //
//    set_trap_vector( i, trap_handler );
//  }
//  printf("Traps on\n");
//}
//
//void traps_off( void )
//{
//  int i;
//
//  printf("Traps off\n");
//
//  for( i = 0 ; i <= max_trap_number ; i++ )
//  {
//     setvect(i, traps[i]);
//  }
//
//}
//
//
//void traps_report( void )
//{
//  int i;
//
//  for( i = 0 ; i <= max_trap_number ; i++ )
//  {
//     if( trap_counts[i] )
//     {
//       printf("INT_%03Xh -[%i]\n", i, trap_counts[i] );
//     }
//  }
//
//  printf("Total -[%u] interrupts count\n", total_trap_count );
//}




//void make_Int( int nIntNum )
//{
//  int nIntOffset = nIntNum*4;
//  int nSeg;
//  int nOfs;
//  static unsigned long lFarPtr;
//
//
//  asm{
//       xor    ax, ax
//       mov    es, ax
//       mov    bx, nIntOffset
//
//       mov    ax, es:[bx]
//       mov    nOfs, ax
//       add    bx, 2
//       mov    ax, es:[bx]
//       mov    nSeg, ax
//  };
//
//  printf("Making Int_%03Xh to %04X:%04X\n", nIntNum, nSeg, nOfs );
//
//  asm {
//        mov    ax, nOfs
//        mov    WORD PTR lFarPtr, ax
//        mov    ax, nSeg
//        mov    WORD PTR lFarPtr+2, ax
//
//        pushf
//        call	lFarPtr
//  };
//
//}



void KeyCheck(void)
{
  nKeyCheck_flag--;

  if( nInserted_Key || kbhit() || escflg2 )
  {
    escflg2 = 0;

    if( !(word(0177560)&0200) )
    {
      word(0177560) |= 0200;
      word(0177562) = gettty();

      if( word(0177560)&0100 )
      {
        nKeyInterrupt_flag++;
        nInterrupt_flag++;
      }
      else
      {
        nKeyInterrupt_flag = 0;
      }
    }
  }
}


void intrchk( void )
{
  if( PSW&0340 )
  {
    return;
  }

  if( nKeyInterrupt_flag )
  {
    nKeyInterrupt_flag = 0;

    if( (word(0177560)&0300) == 0300 )
    {
      intrr(060);
      return;
    }
  }

  if( nScreenInterrupt_flag )
  {
    nScreenInterrupt_flag = 0;

    if( (word(0177564)&0300) == 0300 )
    {
      intrr(064);
      return;
    }
  }

  nInterrupt_flag = 0;
}



void log_pdp_step( void )
{
  char buf[512];
  FILE *hFile;

   sprintf(buf,"R0: %06o\nR1: %06o\nR2: %06o\nR3: %06o\nR4: %06o\nR5: %06o\nSP: %06o\n\n        %06o %06o %06o\n%06o/ %06o %06o %06o\n\nPSW: %06o\n",r[0], r[1], r[2], r[3], r[4], r[5], SP, word(PC-6), word(PC-4), word(PC-2), PC, word(PC), word(PC+2), word(PC+4), PSW );

   hFile = fopen( "pdp_step.log", "w" );
//   fputc( '#', hFile );
   fputs( buf, hFile );
   fclose( hFile );
}

//
//
//

main(ac,av)
char **av;
{
        register i,j;
        int c;
        int brk=0177777;

//        if(ac == 1) {
//                fprintf(stderr, "EM: Usage: EM [-z] RT11DEV [...]\n");
//                exit(1);
//        }



//asm {
//       push   es
//
//       xor    ax, ax
//       mov    es, ax
//       mov    bx, ax
//
//       mov    ax, es:[bx]
//       mov    nZVector0, ax
//
//       add    bx, 2
//       mov    ax, es:[bx]
//       mov    nZVector2, ax
//
//       pop    es
//}
//
//printf("Old nZVector: %04X:%04X (%08lX)\n", nZVector2, nZVector0, (long)(nZVector2*16+nZVector0) );
//
////zero_div_on();
//
//asm {
//       mov    ax, offset zero_div
//       mov    nZVector0, ax
//
//       mov    ax, seg zero_div
//       mov    nZVector2, ax
//}
//
//printf("Zero Div: %04X:%04X (%08lX)\n", nZVector2, nZVector0, (long)(nZVector2*16+nZVector0) );
//

        printf("DEC PDP11 emulator v1.2  MIG 2003\n");

//        CreateManyFiles(MAX_RT11_FILES);

        // HD device support //
        HD_device_init();

//sleep(2);
        textmode(C80);

        asm {
               xor ax, ax
               mov ah, 5
               Int 0x10
        }

        CursorON();

        textcolor(RED);
        textbackground(BLUE);
        gotoxy(1,1);
        cputs(title);

//        cAttribute = 0x14;
//        TitlePuts(0,title);

        Calculate_CPU_Speed();

        if( nBPS_Limit )
        {
          gotoxy(39,1);
          cprintf("%5lu bps ", nBPS_Limit );
     //     sprintf(str,"%5lu bps ", nBPS_Limit );
     //     TitlePuts(39,str);
        }

        textcolor(GREEN);
        textbackground(BLUE);
        gotoxy(49,1);
        cputs(" LAT ");

     //   cAttribute = 0x12;
     //   TitlePuts(49," LAT ");


        textcolor(WHITE);
        textbackground(BLACK);
        gotoxy(1,2);
        window(1,2,80,25);
        clrscr();

        memset( memory, 0, MEMSIZ );

//        initov();
        readboot();
#ifdef DEBUG
        printf("trace?");
        if(getch() == 'y') {
                trace++;
                printf("\nstep?");
                if(getch() == 'y')
                        step++;
        }
        printf("\ntrap info?");
        if(getch() == 'y')
                tinfo++;
        printf("\nbreak addr:");
        scanf("%o",&brk);
#endif
        for(i=0,c=1; av[c]; c++) {
                if(av[c][0] == '-') {
                        dzf++;
                        continue;
                }
                if(av[c][1] == ':' && av[c][2] == 0) {
                        f[i++] = -(av[c][0]&~0x20);
                        continue;
                }
                if((f[i] = open(av[c],O_BINARY|O_RDWR)) == -1)
                        printf("not found %s\n",av[c]);
                else
                        i++;
        }
//        PC = 0;
//        PC = 01000;
#ifdef BINLOAD
        readbin();
#endif
        PSW = 0340;

        nFetchCount = 0;

//        res_PSW_flag = 0;

        reset();
        signal(SIGINT,ctrlc);
        signal(SIGFPE,fperr);

        setjmp(env);

fetch:
        cpu_act();

//        log_pdp_step();

/*
        if( res_PSW_flag )
        {
 sprintf( str, " old PSW = %06o\n", PSW );
 HDLogFileStrOut( str );

          PSW = res_PSW;
          res_PSW_flag = 0;

 sprintf( str, " new PSW = %06o\n", PSW );
 HDLogFileStrOut( str );

        }

        if( test_PSW_flag )
        {
          test_PSW_flag = 0;

 sprintf( str, "       PSW = %06o\n", PSW );
 HDLogFileStrOut( str );

 sprintf( str, "   res_PSW = %06o\n", res_PSW );
 HDLogFileStrOut( str );
        }
//*/


/*
memflag = 0;
for( i = 0 ; i < 10 ; i++ )
{
 if( mem0[i] != word(i) )
 {
   if( !memflag )
   {
     sprintf(str, "PC:%06o | ", PC );
     HDLogFileStrOut(str);
   }
   mem0[i] = word(i);
   sprintf(str, "%i:%06o  ", i, mem0[i] );
   HDLogFileStrOut(str);
   memflag++;
 }
}
if(memflag) { HDLogFileStrOut("\n"); }

//*/


#ifdef DEBUG
        if(PC == brk) {
                trace++;
                step++;
        }
        if(trace) {
                printf("%06o/ %06o %06o %06o PSW=%06o\n",PC,word(PC), word(PC+2), word(PC+4),PSW);
                for(i=0;i<8;i++)
                        printf("R%d=%06o ",i,r[i]);
        }
        i=0;
        if(step) {
                byte=0;
                for(;;) {
                switch(c=getche()) {

                case ' ':
                        break;
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                        i=(i<<3) + c - '0';
                default:
                        continue;
                case '\r':
                        i+=byte?1:2;
                        printf("%06o/",i);
pr:                     printf(" %06o %c\n",word(i),byte?memory[i]:' ');
                        continue;
                case '\\':
                        byte = 1;
                        goto pr;
                case '/':
                        byte = 0;
                        goto pr;
                case 'q':
                        exit();
                case 'p':
                        trace=0;
                        step=0;
                        break;
                case 'm':
                        printf("modify ");
                        scanf("%o",&c);
                        word(i) = c;
                        continue;
                }
                break;
                }
        }
#endif
        if( nKeyCheck_flag )
        {
          KeyCheck();
        }

        if( nInterrupt_flag )
        {
          intrchk();
        }
fet1:
        i = ir = word(PC);
        PC += 2;
        if(i & 070000) {          /* Double operands, EIS, FIS instructions */
                static (*fun[])() = {
                        illop,mov,cmp,bit,bic,bis,add,eis,
                        illop,movb,cmpb,bitb,bicb,bisb,sub,illop
                };

                (*fun[(i>>12)&017])();
                goto fetch;
        }
        if(i >= 0) {
                if(i & 07000)            /* Single op & branches */
                        switch(i & 07000) {

                        case 05000:
                        case 06000:
                                {
                                static (*fun[])() = {
                                        ror,rol,asr,asl,mark,mfpi,mtpi,sxt,
                                        clr,com,inc,dec,neg,adc,sbc,tst
                                };

                                (*fun[(i>>6)&017])();
                                goto fetch;
                                }
                        case 01000:
                                if(i & 0400) {
                                        if(PSW & Z)
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if(!(PSW & Z))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 02000:
                                if(i & 0400) {
                                        if((i=PSW & (N | V)) == N || i == V)
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if((i=PSW & (N | V)) == 0 || i == (N | V))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 03000:
                                if(i & 0400) {
                                        if(!((i=PSW & (N | V | Z)) == 0 || i == (N | V)))
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if((i=PSW & (N | V | Z)) == 0 || i == (N | V))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 04000:
                                jadst();
                                i = (ir & 0700) >> 6;
                                push(r[i]);
                                r[i] = PC;
                                PC = dstoff;
                                break;
                        default:
                                illop();
                                break;
                        }
                else switch(i & 0700) {

                case 0400:
                case 0500:
                case 0600:
                case 0700:
                        PC += (*(char *) & ir)*2;
                        break;
                case 0100:
                        jadst();
                        PC = dstoff;
                        break;
                case 0200:
                        switch(i & 070) {

                        case 000:
                                i = ir & 7;
                                PC = r[i];
                                r[i] = pop();
                                break;
                        case 030:
                                PSW &= ~0340;
                                PSW |= (ir & 7) << 4;
                                break;
                        case 040:
                        case 050:
                        case 060:
                        case 070:
                                i = ir & 017;
                                if(ir & 020)
                                        PSW |= i;
                                else
                                        PSW &= ~i;
                                break;
                        default:
                                illop();
                                break;
                        }
                        break;
                case 0300:
                        swabb();
                        break;
                case 0000:
                        switch(i) {

                        case 0:
                                printf("Halt at PC %06o\npress any key to continue", PC);
                                c = getch();
                                if( !c || c == 27 || c == ('X'&0x1f) )
                                {
                                  exit(1);
                                }
                                break;
                        case 1:
                                for(;;)
                                        intrchk();
                                break;
                        case 2:
                                PC = pop();
                                PSW= pop();
                                break;
                        case 3:
                                intrr(014);
                                break;
                        case 4:
                                intrr(020);
                                break;
                        case 5:
                                reset();
                                break;
                        case 6:
                                PC = pop();
                                PSW= pop();
                                goto fet1;
                        case 010:
//                                msread();
    HDReadDSK( memory[0177134], r[0], r[1], r[2] );
    PSW &= ~C;

                                break;
                        case 011:
//                                mswrite();
    HDWriteDSK( memory[0177134], r[0], r[1], r[2] );
    PSW &= ~C;
                                break;
                        default:
                                illop();
                        }
                        break;
                }
        } else {
                if(i & 0107000)            /* Single op & branches */
                        switch(i & 0107000) {

                        case 0105000:
                        case 0106000:
                                {
                                static (*fun[])() = {
                                        rorb,rolb,asrb,aslb,mtps,mfpi,mtpi,mfps,
                                        clrb,comb,incb,decb,negb,adcb,sbcb,tstb
                                };

                                (*fun[(i>>6)&017])();
                                goto fetch;
                                }
                        case 0100000:
                                if(i & 0400) {
                                        if(PSW & N)
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if(!(PSW & N))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 0101000:
                                if(i & 0400) {
                                        if(PSW & (C | Z))
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if(!(PSW & (C | Z)))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 0102000:
                                if(i & 0400) {
                                        if(PSW & V)
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if(!(PSW & V))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 0103000:
                                if(i & 0400) {
                                        if(PSW & C)
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if(!(PSW & C))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 0104000:
                                if(i & 0400)
                                        intrr(034);
                                else
                                        intrr(030);
                                break;
                        default:
                                illop();
                                break;
                        }
        }
        goto fetch;
}

eis()
{
        switch(ir & 07000) {

        case 00000:
                illop();
//                mul();
                break;
        case 01000:
                illop();
//                divv();

//printf(" di-[%i] ; cx-[%i]\n", di, ax );
//if(FL1) { printf(" di-[%i] ; cx-[%i]\n", di, cx ); }

                break;
        case 02000:
                illop();
                ash();
//                break;
        case 03000:
                illop();
//                ashc();
                break;
        case 04000:
                xor();
                break;
        case 05000:
                switch(ir & 0770) {

                case 000:
                        illop();
//                        fadd();
                        break;
                case 010:
                        illop();
//                        fsub();
                        break;
                case 020:
                        illop();
//                        fmul();
                        break;
                case 030:
                        illop();
//                        fdiv();
                        break;
                default:
                        illop();
                        break;
                }
                break;
        case 07000:
                if(--r[(ir & 0700) >> 6])
                        PC -= (ir & 077)*2;
                break;
        default:
                illop();
                break;
        }
return;
}

mark()
{
        SP += ((ir & 077)+1) << 1;
        PC = r[5];
        r[5] = pop();
        return;
}

//

void cpu_act(void)
{
  static char sim[] = "|/-\\";
  static char *pSim = sim;
  static int  nOldCpuActCount = 0;
  int x,y;
  int bLeadFlag = 0;
//  long nOpS;
  long yy;
  long zz;
  long factor;

  nFetchCount++;

  if( nCPU_Delay > 0 )
  {
    while( nCpuActCount )
    {
      if( nBulk_CPU_Speed++ > nCPU_Delay ) { break; }
    }
    nBulk_CPU_Speed = 0;
  }

  if( nCpuActCount - nOldCpuActCount < 9 ) { return; }
  nOldCpuActCount = nCpuActCount;

  x=wherex();
  y=wherey();

  Sleep(25);
  window(1,1,80,25);
  Sleep(25);

  _setcursortype(_NOCURSOR);

  gotoxy(54,1);

  if( !(*pSim) ) { pSim = sim; }

  textcolor(BROWN);
  textbackground(BLUE);
  putch(*pSim++);

//  str[0] = *pSim++;
//  str[1] = 0;
//  cAttribute = 0x16;
//  TitlePuts(54,str);
//

  CurrTime = time(NULL);
  TimeSlice = CurrTime - LastEmulatorPoll;

  if( TimeSlice >= EmulatorSpeedPoll )
  {
    LastEmulatorPoll = CurrTime;

    nOpS = nFetchCount/TimeSlice;

    // speed ->  fecth/intcheck
    zz = nOpS/2000;
    if( zz < 10000 ) { speed = zz; }
    else { speed = 10000; }
    if( speed < 10 ) { speed = 10; }

    
    if( !nLoopsOp && nOpS  )
    {
      zz = nOpS/18;
      nLoopsOp = nCPU_Speed/zz;
    }

    if( nCPU_Delay )
    {
      yy = nOpS/100;
      zz = nOpS - nCPU_Limit;
      factor = zz/yy;
      nCPU_Delay += (nCPU_Delay*factor)/102;
      if( zz < 0 ) { nCPU_Delay--; }
      if( nCPU_Delay < 0 ) { nCPU_Delay = nLoopsOp; }
    }

    if( nOpS && ( nCPU_Delay || !nCPU_Limit ) )
    {

//*
    //  cprintf(" %lu op/s ", nOpS );
    //  gotoxy(56,1);
      yy = nOpS;
      if( yy > 1000000 )
      {
      //  sprintf(str,"%4lu'", nOpS/1000000 );
      //  TitlePuts(-1,str);
        cprintf("%5lu'", nOpS/1000000 );
        yy = nOpS%1000000;
        bLeadFlag++;
      }
      else { cprintf("    "); }

      if( yy > 1000 )
      {
        if( bLeadFlag )
        { cprintf("%03lu'", yy/1000 ); }
        else {  cprintf("%3lu'", yy/1000 ); }
        yy = yy%1000;
        bLeadFlag++;
      }
      else
      if( bLeadFlag )
      {
        cprintf("000'");
      }
      else
      {
        cprintf("   ");
      }

      if( bLeadFlag ) { cprintf("%03lu op/s ", yy ); }
      else { cprintf("%3lu op/s ", yy ); }
//*/

//      cprintf("[%li]",nLoopsOp );
//      cprintf("[%li]",nCPU_Delay );
//      cprintf("CPS-[%u]  Delay-[%lu] ", nCPS, nCPS_Delay );
//      cprintf("[%u] ", nCPS );
    }

    nFetchCount = 0;

    if( nCPU_Limit && (!nCPU_Delay) && nOpS )
    {
      yy = nCPU_Limit/100;

      if( (factor = nOpS/yy - 100) > 0 )
      {
        nCPU_Delay = (nLoopsOp*factor)/120;
      }
      else
      {
        nCPU_Limit = 0;
      }
    }
  }


  //

  textcolor(WHITE);
  textbackground(BLACK);
  Sleep(25);
  window(1,2,80,25);
  Sleep(25);
  gotoxy(x,y);

  if( !tty_flag && !cursor_off )
  {
//    _setcursortype(_SOLIDCURSOR);
    CursorON();
  }
}


void ctrlc()
{
  int x,y;

        x=wherex();
        y=wherey();
        signal(SIGINT,ctrlc);

        trace++;
        step++;
        window(1,1,80,25);

        textcolor(RED);
        textbackground(BLUE);
        gotoxy(1,1);
        cputs(title);

        textcolor(GREEN);
        textbackground(BLUE);

        if( rus_flag )
        {
          gotoxy(49,1);
          cputs(" RUS ");
        }
        else
        {
          gotoxy(49,1);
          cputs(" LAT ");
        }

        textcolor(WHITE);
        textbackground(BLACK);
        window(1,2,80,25);

        gotoxy(x,y);

#ifndef DEBUG
        TTKS |= 0200;
        TTKB = 3;
#endif
//*/
}

displayreg()
{
        char s[20];
        int i;
        static char *rn[] = {
                "R0","R1","R2","R3","R4","R5","SP","PC","PS"
        };
        int x,y;

        x=wherex();
        y=wherey();
        textbackground(BLUE);
        for(i=0; i<9; i++) {
                gotoxy(69,i+1);
                sprintf(s, "%s = %06o", rn[i], (i==8? PSW: r[i]));
                cputs(s);
        }
        textbackground(BLACK);
        gotoxy(x,y);
return;
}


void push( int a)
{
        SP -= 2;
        word(SP) = a;
/*
        if(SP < (unsigned)0400)
                intrr(4);
*/
return;
}

int pop()
{
        register i;

        i = word(SP);
        SP += 2;
        return(i);
}

reset()
{
        TTPS = LPS = 0200;
        TTKS = 0;
return;
}

fadd()
{
        union {
                float x;
                int ix[2];
        } o1, o2, rez;
        register int reg,rreg;
#ifdef FISDEBUG
        char st[80];
#endif

        wasfpe = 0;
        PSW &= 0340;
        reg = ir & 07;
        o2.ix[1] = word(r[reg]);
        r[reg] += 2;
        o2.ix[0] = word(r[reg]);
        rreg = (r[reg] += 2);
        o1.ix[1] = word(rreg);
        o1.ix[0] = word(rreg + 2);
        rez.x = (o1.x/4 + o2.x/4)*4;
#ifdef FISDEBUG
        sprintf(st,"\nFADD o1= %06o %06o  o2= %06o %06o rez = %06o %06o\n",
                o1.ix[0], o1.ix[1], o2.ix[0], o2.ix[1], rez.ix[0], rez.ix[1]);
        for(reg=0;st[reg];reg++)
                puttty(st[reg]);
#endif
        word(rreg) = rez.ix[1];
        word(rreg+2) = rez.ix[0];
        if(!wasfpe) {
                if(rez.x < 0)
                        PSW |= N;
                else if(rez.x == 0)
                        PSW |= Z;
        } else
                intrr(0244);
return;
}

fsub()
{
        union {
                float x;
                int ix[2];
        } o1, o2, rez;
        register int reg,rreg;
#ifdef FISDEBUG
        char st[80];
#endif

        wasfpe = 0;
        PSW &= 0340;
        reg = ir & 07;
        o2.ix[1] = word(r[reg]);
        r[reg] += 2;
        o2.ix[0] = word(r[reg]);
        rreg = (r[reg] += 2);
        o1.ix[1] = word(rreg);
        o1.ix[0] = word(rreg + 2);
        rez.x = (o1.x/4 - o2.x/4)*4;
#ifdef FISDEBUG
        sprintf(st,"\nFSUB o1= %06o %06o  o2= %06o %06o rez = %06o %06o\n",
                o1.ix[0], o1.ix[1], o2.ix[0], o2.ix[1], rez.ix[0], rez.ix[1]);
        for(reg=0;st[reg];reg++)
                puttty(st[reg]);
#endif
        word(rreg) = rez.ix[1];
        word(rreg+2) = rez.ix[0];
        if(!wasfpe) {
                if(rez.x < 0)
                        PSW |= N;
                else if(rez.x == 0)
                        PSW |= Z;
        } else
                intrr(0244);
return;
}

fmul()
{
        union {
                float x;
                int ix[2];
        } o1, o2, rez;
        register int reg,rreg;
#ifdef FISDEBUG
        char st[80];
#endif

        wasfpe = 0;
        PSW &= 0340;
        reg = ir & 07;
        o2.ix[1] = word(r[reg]);
        r[reg] += 2;
        o2.ix[0] = word(r[reg]);
        rreg = (r[reg] += 2);
        o1.ix[1] = word(rreg);
        o1.ix[0] = word(rreg + 2);
        rez.x = ((o1.x/4) * (o2.x/4))*4;
#ifdef FISDEBUG
        sprintf(st,"\nFMUL o1= %06o %06o  o2= %06o %06o rez = %06o %06o\n",
                o1.ix[0], o1.ix[1], o2.ix[0], o2.ix[1], rez.ix[0], rez.ix[1]);
        for(reg=0;st[reg];reg++)
                puttty(st[reg]);
#endif
        word(rreg) = rez.ix[1];
        word(rreg+2) = rez.ix[0];
        if(!wasfpe) {
                if(rez.x < 0)
                        PSW |= N;
                else if(rez.x == 0)
                        PSW |= Z;
        } else
                intrr(0244);
return;
}

fdiv()
{
        union {
                float x;
                int ix[2];
        } o1, o2, rez;
        register int reg,rreg;
#ifdef FISDEBUG
        char st[80];
#endif

        wasfpe = 0;
        PSW &= 0340;
        reg = ir & 07;
        o2.ix[1] = word(r[reg]);
        r[reg] += 2;
        o2.ix[0] = word(r[reg]);
        rreg = (r[reg] += 2);
        o1.ix[1] = word(rreg);
        o1.ix[0] = word(rreg + 2);
        rez.x = ((o1.x/4) / (o2.x/4))*4;
#ifdef FISDEBUG
        sprintf(st,"\nFDIV o1= %06o %06o  o2= %06o %06o rez = %06o %06o\n",
                o1.ix[0], o1.ix[1], o2.ix[0], o2.ix[1], rez.ix[0], rez.ix[1]);
        for(reg=0;st[reg];reg++)
                puttty(st[reg]);
#endif
        if(!wasfpe) {
                if(rez.x < 0)
                        PSW |= N;
                else if(rez.x == 0)
                        PSW |= Z;
                word(rreg) = rez.ix[1];
                word(rreg+2) = rez.ix[0];
        } else
                intrr(0244);
return;
}

void fperr(sig, flag)
{
#ifdef FISDEBUG
        char str[80];
        int i;
#endif

        signal(SIGFPE, fperr);
        wasfpe = 1;
        switch(flag) {

        case FPE_OVERFLOW:
                PSW |= V;
                break;
        case FPE_UNDERFLOW:
                PSW |= V|N;
                break;
        case FPE_ZERODIVIDE:
                PSW |= V|N|C;
                break;
        default:
#ifdef FISDEBUG
                sprintf(str, "Unknown FP error %x\n", flag);
                for(i=0; str[i]; i++)
                        puttty(str[i]);
#endif
                break;
        }
}

void far intrr(n)
register n;
{
#ifdef DEBUG
        if(tinfo)
                printf("Trap to %o\n", n);
#endif
        push(PSW);
        push(PC);
        PC = word(n);
        PSW = word(n+2);
        longjmp(env,0);
}

short far getdev(n)
{
        switch(n) {

        case 0177562:
                TTKS &= ~0200;
                return(word(n));

  //      case 0177336:
  //      case 0177134:  // EM device
        case 0177560:
        case 0177564:
        case 0177566:
  //      case 0177514:
  //      case 0177516:
                return(word(n));

/*
        case 0177776:

// sprintf( str, "Read PSW : %06o\n", word(n) );
// HDLogFileStrOut( str );

                return(word(n));
//*/

//        case 0177774:
//
// sprintf( str, "Read TST ARG : %06o\n", word(n) );
// HDLogFileStrOut( str );
//
//                return(word(n));


        // HD device support //
        case 0177660:        // 0177660 - command

// asm{ pusha };
// sprintf( str, "Read 0177660 : %i\n", word(n) );
// HDLogFileStrOut( str );
// asm{ popa };

                return(word(n));

        case 0177662:        // 0177662 - data

// asm{ pusha };
// sprintf( str, "Read 0177662 : %i\n", word(n) );
// HDLogFileStrOut( str );
// asm{ popa };

                return(word(n));


        default:

  asm{ pusha };
  sprintf(str,"ERROR--Read of absent addr %06o\n", n );
  HDLogFileStrOut(str);
  asm{ popa };

                intrr(4);
                break;
        }
return;
}

void far putdev(n)
{
   asm{ pusha };


        switch(n) {

        case 0177560:
                if( (dst & 0100) && (!(word(n)&0100)) )
                {
                  nKeyInterrupt_flag++;
                  nInterrupt_flag++;
                }
                else
                {
                  nKeyInterrupt_flag = 0;
                }

                word(n) = dst & 0100;
        case 0177562:
                break;

        case 0177564:
                if( (dst & 0100) && (!(word(n)&0100)) )
                {
                  nScreenInterrupt_flag++;
                  nInterrupt_flag++;
                }
                else
                {
                  nScreenInterrupt_flag = 0;
                }
//        case 0177514:
                word(n) = (dst & 0100) | 0200;
                break;

   //     case 0177134:
   //             word(n) = dst;

// sprintf( str, "Write EM REG : %06o\n", word(n) );
// HDLogFileStrOut( str );

                break;
/*
        case 0177336:
                word(n) = dst;

 sprintf( str, "Write REG[336] : %06o\n", word(n) );
 HDLogFileStrOut( str );

                break;
//*/


        case 0177566:
                puttty(dst&0177);
                break;
/*

        case 0177516:
                putc(dst,stdprn);
                fflush(stdprn);
                break;

        case 0177776:
                word(n) = dst;

// sprintf( str, "Write PSW : %06o\n", word(n) );
// HDLogFileStrOut( str );

                break;
//*/

        // HD device support //

        case 0177660:        // 0177660 - command
                word(n) = dst;
                HD_device_command(dst);
                break;

        case 0177662:        // 0177662 - data
                word(n) = dst;
                HD_set_data_word(dst);
                break;


        default:

  sprintf(str,"ERROR--Write to absent addr %06o\n", n );
  HDLogFileStrOut(str);

                intrr(4);
                break;
        }


   asm{ popa };

   return;
}


void far chkbus(n)
{
   asm {
         pusha
         push  es
       };

        switch(n) {

        case 0177564:
  //      case 0177776:
                break;

        case 0177562:
        case 0177560:
  //      case 0177134:  // EM device
        case 0177566:
  //      case 0177514:
  //      case 0177516:

  //      case 0177336:

// sprintf(str,"Check addr %06o : %06o\n", n, word(n) );
// HDLogFileStrOut(str);

                break;

        // HD device support //
        case 0177660:        // 0177660 - command
/*
                res_PSW_flag++;  //    'TST @#177660'

                res_PSW = PSW & 0177760;

                if( word(n) == 0 )
                     { res_PSW |= 04; }
                else if( word(n) & 0100000 )
                     { res_PSW |= 010; }

//*/
//    sprintf(str,"Check addr %06o : %06o\n", n, word(n) );
//    HDLogFileStrOut(str);

                break;


        case 0177662:        // 0177662 - data
                break;


        default:

  sprintf(str,"ERROR--Check for absent addr %06o\n", n );
  HDLogFileStrOut(str);

                intrr(4);
                break;
        }


//    sprintf(str,"  res_PSW = %06o word(%06o) = %06o \n", res_PSW, n, word(n) );
//    HDLogFileStrOut(str);

//        res_PSW_flag++;  //    'TST @#177xxx'
//        test_PSW_flag++;

// sprintf(str,"Check addr %06o : %06o\n", n, word(n) );
// HDLogFileStrOut(str);

//  sprintf(str,"   res_PSW %06o \n", res_PSW );
//  HDLogFileStrOut(str);

   asm {
         pop   es
         popa
       };

        return;
}

illop()
{
#ifdef DEBUG
        printf("Illegal op %06o at PC=%06o\n", ir, PC);
#endif
        intrr(010);
return;
}

mtpi()
{
        illop();
return;
}

mtpd()
{
        illop();
return;
}

mfpi()
{
        illop();
return;
}

mfpd()
{
        illop();
return;
}

msread()
{
        int i,j;

        j = memory[0177134];
        if(f[j] == 0)
                goto erread;
        else if(f[j] < 0) {
                if(diskread())
                        goto erread;
                else
                        return;
        }
        if(lseek(f[j], r[0]*512l, SEEK_SET) == -1l) {
#ifdef DEBUG
                printf("seek error\n");
#endif
                goto erread;
        }
#ifdef DEBUG
        printf("read block %d nw=%o adr=%o\n",r[0],r[1],r[2]);
#endif
        if((i=read(f[j], memory+r[2], r[1]*2)) != r[1]*2) {
#ifdef DEBUG
                printf("read error (retcode=%d)\n",i);
#endif
erread:         PSW |= C;
        } else
                PSW &= ~C;
}

mswrite()
{
        int i;

        i = memory[0177134];
#ifdef DEBUG
        printf("write block %d nw=%o adr=%o\n",r[0],r[1],r[2]);
#endif
        if(f[i] == 0)
                goto erwrite;
        else if(f[i] < 0) {
                if(diskwrite())
                        goto erwrite;
                else
                        return;
        }
        if(lseek(f[i], r[0]*512l, SEEK_SET) == -1l)
                goto erwrite;
        if(write(f[i], memory+r[2], r[1]*2) != r[1]*2)
erwrite:        PSW |= C;
        else
                PSW &= ~C;
return;
}


void readboot(void)
{
  time_t timer;

  int  rt_date = 0;
  long x;

  unsigned long day_ticks;
  unsigned int  year_up;
  unsigned int  year;

  struct tm *tblk;


  timer = time(NULL);

  tblk = localtime(&timer);

  day_ticks = tblk->tm_hour*60;
  day_ticks += tblk->tm_min;
  day_ticks *= 60;
  day_ticks += tblk->tm_sec;
  day_ticks *= 60;

  year = tblk->tm_year;

  if( year > 103 )
  {
    year_up = year - 72;
    year_up >>= 5;
    rt_date |= year_up;
    rt_date <<= 4;
    year -= year_up*32;

 //   printf(" year_up -[%u] ; year-[%u] ", year_up, DosFileDate.year );
 //   getch();
  }


  rt_date |= tblk->tm_mon + 1;
  rt_date <<= 5;

  rt_date |= tblk->tm_mday;
  rt_date <<= 5;

  rt_date |= year - 72;

/*
        if((f[0]=open("emboot.sav",O_BINARY|O_RDWR)) == -1)
                printf("not found emboot.sav\n");
        if(read(f[0],memory,01000) == -1)
                printf("error reading emboot.sav\n");
        close(f[0]);
        return;
//*/

   HDReadDSK( nBootHDnum, 0, 256, 0 );  //   0  HD   0

   r[0] = nBootHDnum;
   PC = 0;

   if( nBootRt11Flag )
   {
     HDReadDSK( nBootHDnum, 2, 256*4, 512 );  //   2,3,4,5    1000

     SP = 010000;
     PC = 01000;
     word(0) = 0;                 //       . .
     word(04722) = nBootHDnum;    //   
   }

//   gotoxy(20,1);
//   printf("rt_date--[%lu = %u:%u:%u]\n", day_ticks, tblk->tm_hour, tblk->tm_min, tblk->tm_sec );
//   gotoxy(1,3);

   x = day_ticks/65535;

   word(05000) = (int)x;
   word(05002) = (int)day_ticks;

   word(05004) = rt_date;          // 
//*/
}

#ifdef BINLOAD
readbin()
{
        int c,ks,i,l;

        for(;;) {
/*              printf("offset %06o\t",foffs);*/
                while((c=get(f[0])) != 1)
                        if(c==EOF) {
                                printf("EOF\n");
                                goto ask;
                        }
                if(get(f[0]) != 0) {
                        printf("not zero\n");
                        continue;
                }
                ks = 1;
                c = get(f[0]);
                ks += c;
                l = c;
                c = get(f[0]);
                ks += c;
                l |= (c<<8);
                c = get(f[0]);
                ks += c;
                i = c;
                c = get(f[0]);
                ks += c;
                i |= (c<<8);
                if(l == 6)
                        if(i == 1) {
ask:                            printf("start addr: ");
                                scanf("%o", &PC);
                                return;
                        } else {
                                PC = i;
                                printf("PC = %06o\n");
                                return;
                        }
/*              printf("load from %06o %06o bytes\n",i,l);*/
                while(l-- > 6) {
                        c = get(f[0]);
                        ks += c;
                        memory[i++] = c;
                }
                c = get(f[0]);
                if((c+ks) & 0377) {
                        printf("checksum error: c=%o ks=%o\n",c,ks&0377);
                }
        }
}

get(f)
{
        int c=0;
        if(read(f,(char *)&c,1) != 1)
                c=EOF;
        foffs++;
        return(c);
}
#endif


int RUS_PC_to_DVK[] = {
         0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
         17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
         ' ', '!', '|', '#', '$', '%', '&',  92, '(', ')', '*', '+',
         'B', '-', '@', '/', '0', '1', '2', '3', '4', '5', '6', '7',
         '8', '9', 'v', 'V', 'b', '=', '`', '?', 0  , 'f', 'i', 's',
         'w', 'u', 'a', 'p', 'r', '{', 'o', 'l', 'd', 'x', 't', '}',
         'z', 'j', 'k', 'y', 'e', 'g', 'm', 'c', '~', 'n', 'q', 'H',
         0  , '_', 0  , 0  , 0  , 'F', 'I', 'S', 'W', 'U', 'A', 'P',
         'R', '[', 'O', 'L', 'D', 'X', 'T', ']', 'Z', 'J', 'K', 'Y',
         'E', 'G', 'M', 'C', '^', 'N', 'Q', 'h', 0  , '_', 0  ,127 ,
         'a', 'b', 'w', 'g', 'd', 'e', 'v', 'z', 'i', 'j', 'k', 'l',
         'm', 'n', 'o', 'p', 'r', 's', 't', 'u', 'f', 'h', 'c', '~',
         '{', '}', '_', 'y', 'x', '|', '`', 'q', 'A', 'B', 'W', 'G',
         'D', 'E', 'V', 'Z', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
         0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  ,
         0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  ,
         0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  ,
         0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  ,
         'R', 'S', 'T', 'U', 'F', 'H', 'C', '^', '[', ']', '_', 'Y',
         'X', 92 , '@', 'Q', 'e', 'E', 0  , 0  , 0  , 0  , 0  , 0  ,
         0  , 0  , 0  , 0  , 0  , '$', 0  , 127
};


int LAT_PC_to_DVK[] = {
         0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
         17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
         ' ', '!', '"', '#', '$', '%', '&', 39 , '(', ')', '*', '+',
         ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7',
         '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C',
         'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
         'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
         92 , ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g',
         'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's',
         't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~',127 ,
         'F', '<', 'D', 'U', 'L', 'T', ':', 'P', 'B', 'Q', 'R', 'K',
         'V', 'Y', 'J', 'G', 'H', 'C', 'N', 'E', 'A', '{', 'W', 'X',
         'I', 'O', '}', 'S', 'M', '"', '>', 'Z', 'f', ',', 'd', 'u',
         'l', 't', ';', 'p', 'b', 'q', 'r', 'k', 'v', 'y', 'j', 'g',
         0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  ,
         0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  ,
         0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  ,
         0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  , 0  ,
         'h', 'c', 'n', 'e', 'a', '[', 'w', 'x', 'i', 'o', ']', 's',
         'm', 39 , '.', 'z', '~', '`', 0  , 0  , 0  , 0  , 0  , 0  ,
         0  , 0  , 0  , 0  , '#', '$', 0  , 127
};


short far gettty()
{
        static escflg=0;
        int c;
        static int savch = 0;
        FILE *f;

        if( nInserted_Key )
        {
          savch = nInserted_Key;
          nInserted_Key = 0;
        }

        if(savch) {
                c = savch;
                savch = 0;
        } else
                c = getch();

        if(escflg == 0) {
                if(c == 0)
                {
                  escflg++;
                  escflg2++;
                  nKeyCheck_flag++;
                  return(033);
                }
                else
                if(c == 8)
                {
//                  CursorON();
                  return(0177);
                }
//                else
//                if(c == ('R'&0x1f) )
//                {
//                  displayreg();
//                  return(0177);
//                }
//                else
//                if(c==('X'&0x1f))
//                {
//                  exit(0);
//                }
                else
                if( rus_flag != 0 )
                {
                  return RUS_PC_to_DVK[c];
                }
                else
                {
                  return LAT_PC_to_DVK[c];
                }
        }
        escflg = 0;
//return c;
        switch(c) {

        case '?': // F5
                return 0147;

        case '@': // F6
                return 0150;

        case 'A': // F7
                return 'S';

        case 'B': // F8
                return 0143;

        case 'L':
                return 'f';
        case 72:
                return('A');
        case 80:
                return('B');
        case 77:
                return('C');
        case 75:
                return('D');
        case 71:
           //     return('c');
                return('Q');
        case 82:
                return('d');
        case 83:
                return('e');
        case 79:
                return('f');
        case 73:
              //  return('g');
                return('R');
        case 81:
              //  return('h');
                return('P');
        case 59:  // F1
                return('P');
        case 60:  // F2
                return('Q');
        case 61:  // F3
                return('R');
        case 62:  // F4
                return('S');
        case 67:  // F9
                displayreg();
                return(0177);
        case 68:  // F10
                exit(0);
        }
return 0;
}

int koi7toalt[] = {
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','' //''
};


puttty(c)
{
        static escflg=0,escyflg=0,row=-1;
        static rus=0;

        unsigned int nTimer0;
        unsigned int nTimerLo;

        static unsigned long  nLastTimer  = 0;
        unsigned long  nTimer, nDelay, nPeriod;
        unsigned int   nLimit;

        static unsigned int  nLastTimerHi = 0;
        static unsigned int  nCPS_18_Count = 0;
        static unsigned int  nLastTimerHi18 = 0;
        static unsigned int  nCPS_18 = 0;

        int x,y,ox,oy,dx;
        int ii;
        char l[2];


//if( c == 10 ) { putch(c); return; };
//if( c == 13 ) { putch(c); return; };
//if( c == 9 ) { putch(c); return; };
//
//if( c < 32 )  { putch('['); putch(c+32); putch(']'); }
//else putch(c);
//return;

        if( word(0177564)&0100 )
        {
          nScreenInterrupt_flag++;
          nInterrupt_flag++;
        }


//////
//
// LogFileData.LogState = LOG_ON;
// sprintf(str,"%c",c);
// HDLogFileStrOut(str);
// LogFileData.LogState = LOG_OFF;
//
/////

        nTimer0 = timer0();
        nTimer = nTimerHi;
        nTimer <<= 16;
        nTimerLo = 0xFFFF - nTimer0;
        nTimer += nTimerLo;

        nPeriod = nTimer - nLastTimer;

        if( !kbhit() )
        {
          CursorOFF();
        }

        if( nCPS_Delay )
        {
          while( nTimer - nLastTimer < nCPS_Delay )
          {
            nTimer0 = timer0();
            nTimer = nTimerHi;
            nTimer <<= 16;
            nTimerLo = 0xFFFF - nTimer0;
            nTimer += nTimerLo;

//            printf("nTimerHi -[%04X] ; nTimerLo -[%04X] ; nTimer -[%08lX]\n", nTimerHi, nTimerLo, nTimer );
//            getch();
          }

        }

        nLastTimer = nTimer;

        Sleep(10);

        if( c == 012 && y == 24 ) { Sleep(50); }

//        if( nTimerHi != nLastTimerHi18 )
//        {
//          nCPS_18 = nCPS_18_Count;
//          nCPS_18_Count = 0;
//          nLastTimerHi18 = nTimerHi;
//        }

        if( nTimerHi - nLastTimerHi >= 18 )
        {
          nLastTimerHi = nTimerHi;
          nCPS = nCPS_Count;
          nCPS_Count = 0;
//
//            nLimit = nCPS_Limit;
//            nLimit += nCPS_Limit/15;
//
//            if( nLimit == nCPS_Limit ) { nLimit++; }
//
//            if( nCPS > nLimit )
//            {
//              nDelay = nCPS_Delay;
//              nDelay /= 100;
//              if( !nDelay ) { nDelay++; }
//
//              nCPS_Delay += nDelay;
//            }
        }

        nCPS_Count++;
//        nCPS_18_Count++;

        x=wherex();
        y=wherey();

        if(escyflg) {
                if(row == -1)
                        row = c;
                else {
                        gotoxy(c-040+1, row-040+1);
                        row = -1;
                        escyflg=0;
                        escflg =0;
                }
                return;
        }

        if(escflg) {
es://             x=wherex();
   //             y=wherey();
                escflg = 0;
                switch(c) {

                case 'A':
                        if(y>1){
                                gotoxy(x,y-1);
                                CursorON();
                        }
                        break;
                case 'B':
                        if(y<24){
                                gotoxy(x,y+1);
                                CursorON();
                        }
                        break;
                case 'C':
                        if(x<80){

                                gotoxy(x+1,y);
                                CursorON();
                        }
                        break;
                case 'D':
                        if(x>1){
                                gotoxy(x-1,y);
                                CursorON();
                        }
                        break;
                case 'J':
                        CursorOFF();
                        window(1,y+1,80,25);
                        clrscr();
                        window(1,2,80,25);
                        gotoxy(x,y);
                        goto kill_line;

                case 'E':
//                        clrscr();
                        break;
                case 'H':
                        gotoxy(1,1);
                        break;
                case 'I':
                        if(y>1){
                                gotoxy(x,y-1);
                                CursorON();
                        }
                        else {
                                if( cursor_off == 0 )
                                {
                                  CursorOFF();
                                };

                                //  

                                _AX = 0x701;
                                _CX = 0x100;
                                _DX = 0x184D;
                                _BH = 0;
                                geninterrupt(0x10);
                        }
                        break;

                case 'K':
kill_line:
                        if( cursor_off == 0 )
                        {
                          CursorOFF();
                        };
                        clreol();
                        break;

                case 'Y':
                        escyflg=1;
                        break;

                default:
                        putch(025); //   <ESC>
                        goto outch; //   ESC-.
                }

                Sleep(10);
                return;
        }

        if(c == 03)
                return;
        if(c == 07) {   // <BEEP>
                putchar(c);
                return;
        }
        if(c == 033) {  // <ESC>
                escflg = 1;
                return;
        }
        if(c == 010) {  // <BS>
                c = 'D';
                goto es;
        }
        if(c == 011) {  // <TAB>
                dx = 8 -(x-1)%8;
                if( dx == 0 ) { dx = 7; }
                while(dx--) { gotoxy(x++,y); putch(' '); }
                return;
        }
        if(c == 017) {

                window(1,1,80,25);

                textcolor(GREEN);
                textbackground(BLUE);
                gotoxy(49,1);
                cputs(" LAT ");
                textcolor(WHITE);
                textbackground(BLACK);
                window(1,2,80,25);

                gotoxy(x,y);
                rus = 0;
                rus_flag = 0;
                return;
        }
        if(c == 016) {

                window(1,1,80,25);

                textcolor(GREEN);
                textbackground(BLUE);
                gotoxy(49,1);
                cputs(" RUS ");
                textcolor(WHITE);
                textbackground(BLACK);
                window(1,2,80,25);

                gotoxy(x,y);
                rus = 1;
                rus_flag = 1;
                return;
        }
        if((c == 0177) & !rus) {
                c = 0xdb;
        }
        else
        if(c == 013) {   // <VT>
                c = 012; // <LF>
        }
        else
        if(c == 014) {   // <FF>
//                clrscr();
//                gotoxy(1,1);
                c = 012; // <LF>
        }

outch:

//        if( cursor_off == 0 )
//        {
//           cursor_off++;
//           _setcursortype(_NOCURSOR);
//           tty_flag = 2;
//        };


//        if( nCPS_18 > 5 )
//        {
//          CursorOFF();
//        }
//        else
//        {
//          CursorON();
//        }


        if(c >= 0100 && c <= 0177 && rus)
        {
          c = koi7toalt[c-0100];
        }
//        else
//        if(c >= 0300 && c <= 0376 )
//                c = koi7toalt[c-0300];

        putch(c);

//        if( c >= 0100 && c <= 0177 )
//        {
          if( ( kbhit() && nPeriod > 3000 ) || nPeriod > 6000 )
          {
            CursorON();
          }
          else
          {
            CursorOFF();
          }
//        }


        if(c == 012 && y == 24)
        {
          clreol();
          Sleep(50);
        }

return;
}

char bf[512];

diskread()
{
        register i,j;
        int track,head,sector;
        struct diskinfo_t di;
        int spt=20;

        if(dzf)
                spt=10;

        for(;r[1];r[0]++) {
                track = r[0]/spt;
                head = 0;
                sector = r[0]%spt;
                if(dzf)
                        if(sector < 5) {
                                sector=(sector+track)*2;
                                sector%=10;
                        } else {
                                sector=(sector+track)*2;
                                sector%=10;
                                sector++;
                        }
                if(sector > 10) {
                        sector -= 10;
                        head++;
                }
                if(dzf) {
                        track++;
                        if(track == 80)
                                track=0;
                }
                i = memory[0177134];
                di.drive = -f[i] - 'A';
                di.head = head;
                di.track= track;
                di.sector = sector+1;
                di.nsectors = 1;
                di.buffer = bf;
                if((i=_bios_disk(_DISK_READ, &di)) & 0xff00) {
                        printf("read error %04x\n",i);
                        return(1);
                }
                for(i=0;i<512 && r[1];r[1]--) {
                        memory[r[2]++] = bf[i++];
                        memory[r[2]++] = bf[i++];
                }
        }
        PSW &= ~C;
        return(0);
}

diskwrite()
{
        register i,j;
        int track,head,sector;
        struct diskinfo_t di;
        int spt=20;

        if(dzf)
                spt=10;


        for(;r[1];r[0]++) {
                for(i=0;i<512 && r[1];r[1]--) {
                        bf[i++] = memory[r[2]++];
                        bf[i++] = memory[r[2]++];
                }
                track = r[0]/spt;
                head = 0;
                sector = r[0]%spt;
                if(dzf)
                        if(sector < 5) {
                                sector=(sector+track)*2;
                                sector%=10;
                        } else {
                                sector=(sector+track)*2;
                                sector%=10;
                                sector++;
                        }
                if(sector > 10) {
                        sector -= 10;
                        head++;
                }
                if(dzf) {
                        track++;
                        if(track == 80)
                                track=0;
                }
                i = memory[0177134];
                di.drive = -f[i] - 'A';
                di.head = head;
                di.track= track;
                di.sector = sector+1;
                di.nsectors = 1;
                di.buffer = bf;
                if(_bios_disk(_DISK_WRITE, &di) & 0xff00)
                        return(1);
        }
        PSW &= ~C;
        return(0);
}



radix50 ASCII_R50( char *str )
{
 int      i;
 int      len;
 char     s[4];
 radix50  r50=0;
 int      digit;
 char     *pp;
 int      osn[]={ 40*40, 40, 1 };

   if( ( len = strlen(str) ) > 3 ) len = 3;

   for( i = 0 ; i < 3 ; i++ )
   {
      if( i+1 > len ) s[i]=' ';
      else s[i] = toupper( *(str+i) );

      if( (pp=strchr( (char*)R50_CHARS, s[i] )) == 0 ) return -1;
      else
      {
         digit = pp - R50_CHARS;

         r50 += digit * osn[i];
      };
   };
   return r50;
}


//
// HD device support
//

void HD_device_init()
{
//  word(0177660) = 9;     // 0177660 - command
//  word(0177662) = 99;    // 0177662 - data

  pArrFiles = malloc( 2300*sizeof(ArrFileSpec) );
  nInputCache = malloc( nInputCacheSize );

  HDBeginLog();

//  CreateXFile();

//  HDOpenDSK("work.dsk");
//  HDOpenDSK("em0.dsk");

  ReadIniFile("MIG_11.INI");

//  printf("***\n");
//  getch();
}

/*
const  HD_CheckUnit     = 0;
const  HD_SetUnit       = 1;
const  HD_SetBlockNum   = 2;
const  HD_SetBufAddr    = 3;
const  HD_SetWordCount  = 4;
const  HD_Read          = 5;
const  HD_Write         = 6;


int  HD_Unit = 0;
int  HD_BlockNum = 2;
int  HD_BufAddr = 1000;
int  HD_WordCount = 2000;
//*/

void HD_device_command( unsigned int cmd )
{
   int nPC;
   int ok;
   int x;

   sprintf( str, "Write 177660 : %u\n", cmd );
   HDLogFileStrOut( str );

   switch(cmd)
   { ////
     case HD_SetUnit:

       HD_Unit = HD_Data;

       if( hDSK[HD_Unit] <= 0 )
       {
         word(0177660) |= 0100000;   //  .
//         PSW |= C;
       }
       else
       {
         word(0177660) &= ~0100000;   //  .
//         PSW &= ~C;
       }

 sprintf( str, "   Set Unit = %u\n   csr = %06o\n", HD_Data, word(0177660) );
 HDLogFileStrOut( str );

     break;


     ////
     case HD_SetBlockNum:

       HD_BlockNum = HD_Data;

       if( HD_BlockNum > anDSKlen[HD_Unit] - 1 )
       {
         word(0177660) |= 0100000;   //  .
       }

 sprintf( str, "   Set BlockNum = %u\n", HD_Data );
 HDLogFileStrOut( str );

     break;


     ////
     case HD_SetBufAddr:

       HD_BufAddr = HD_Data;

 sprintf( str, "   Set BufAddr = %u\n", HD_Data );
 HDLogFileStrOut( str );

     break;


     ////
     case HD_SetWordCount:

       HD_WordCount = HD_Data;

       x = HD_BlockNum + HD_WordCount/256 - 1;
       if( x < 0 ) { x = 0; }

       if( x > anDSKlen[HD_Unit] - 1 )
       {
         word(0177660) |= 0100000;   //  .
       }


 sprintf( str, "   Set WordCount = %u ; L_val-[%i] R_val-[%i] \n", HD_Data,
               x, (anDSKlen[HD_Unit] - 1) );
 HDLogFileStrOut( str );

     break;


     ////
     case HD_Read:

 HDLogFileStrOut( "   Cmd HD_Read.. \n" );
 sprintf( str, "   BufAddr = %u\n\n\n", HD_BufAddr );
 HDLogFileStrOut( str );

/*
       for( nPC = 0 ; nPC < HD_WordCount*2 ; nPC += 2 )
       {
       //  word(HD_BufAddr + nPC) = i++;

         memory[HD_BufAddr + nPC] = 'A';
         memory[HD_BufAddr + nPC + 1] = 'B';
       }
//*/
       ok = HDReadDSK( HD_Unit, HD_BlockNum, HD_WordCount, HD_BufAddr );

       if( !ok )
       {
         word(0177660) |= 0100000;   //  .
       }
//       PSW &= ~C; //  .


     break;


     ////
     case HD_Write:

 HDLogFileStrOut( "   Cmd HD_Write.. \n" );
 sprintf( str, "   BufAddr = %u\n\n\n", HD_BufAddr );
 HDLogFileStrOut( str );

       ok = HDWriteDSK( HD_Unit, HD_BlockNum, HD_WordCount, HD_BufAddr );

       if( !ok )
       {
         word(0177660) |= 0100000;   //  .
       }
//       PSW &= ~C; //  .

     break;


     ////
     case HD_Get_Unit_Size:

       if( (HD_Unit >= 0) && (HD_Unit <= 7) )
       {
         word(0177662) = anDSKlen[HD_Unit];
       }
       else
       {
         word(0177662) = 0;
       }

     break;


     ////
     case HD_Refresh:

     if( nDSKtype[HD_Unit] == DIR_TYPE )
     {
       RemountHD( HD_Unit );
     }

     break;
   }
}


void HD_set_data_word( unsigned int data_word )
{
  HD_Data = data_word;

  sprintf( str, "Write 177662 : %u\n", HD_Data );
  HDLogFileStrOut( str );
}




void HDInitLogFileData()
{
  strcpy( LogFileData.FileName, "HD.log" );

  LogFileData.AppendFlag = 0;
  LogFileData.LogState = LOG_OFF;
}

/*
void HDBeginLog(  char *FileName, int AppendFlag )
{
  LogFileData.FileName = FileName;
  LogFileData.AppendFlag = AppendFlag;
  BeginLog();
}
//*/
void HDBeginLog()
{
 FILE *hFile;

   HDInitLogFileData();

   hFile = fopen( LogFileData.FileName, "w" );
   fputc( '#', hFile );
   fputc( '\n', hFile );
   fclose( hFile );

//   LogFileData.LogState = LOG_ON;

////
 LogFileData.LogState = LOG_OFF;
////

   HDLogFileStrOut("HD log started..\n");
}


void HDLogFileStrOut( char *buf )
{
//  char   pByte[4];
//  DWORD  NumberOfBytesWritten;

  if( LogFileData.LogState == LOG_ON )
  {
/*
    while( *pChar )
    {
      pByte[0] =  *pChar++;

      WriteFile(
        hHDLogFile,	// handle to file to write to
        pByte,	  // pointer to data to write to file
        (DWORD)1,	// number of bytes to write
        (LPDWORD) &NumberOfBytesWritten,	// pointer to number of bytes written
        NULL 	    // pointer to structure needed for overlapped I/O
      );
    }
//*/
//    asm{ pusha };

    hHDLogFile = open( LogFileData.FileName, O_APPEND	| O_WRONLY | O_TEXT );
    write( hHDLogFile, buf, strlen(buf));
    close( hHDLogFile );

//    asm{ popa };

  }
}


//void HDOpenDSK( char* pcFileName )
//{
//  hDSK = open( pcFileName, O_RDWR | O_BINARY );
//}


void R50_ASCII( char* s, radix50 r50 )
{
 int osn[]={40*40, 40, 1};
 int i;
 int c;
 radix50  rad50=r50;

   for( i=0 ; i<3 ; i++ )
   {
      if( rad50 > 0174777 )
      {
         *(s+i)='?';
         continue;
      };

      c = rad50/osn[i];
      rad50 = rad50%osn[i];

      *(s+i)=R50_CHARS[c];
   };

   *(s+3)='\0';
}


int Lookup( unsigned int nHDnum, unsigned int nBlockNum )
{
  unsigned int *pWord = apnFirstBlocks[nHDnum]+3072;
  unsigned int *pWord2, *pFileSpec;
//  unsigned int nUsedSegs = *(pWord+2);
  unsigned int nNextSeg, nSegStartBlock, nBlock, nFileType, i;


NEXT_DIR_SEG:

  nSegStartBlock = *(pWord+4);
  nNextSeg = *(pWord+1);

  pWord2 = apnFirstBlocks[nHDnum]+(3072+(nNextSeg-1)*1024);

  if( nNextSeg && ( *(pWord2+4) <= nBlockNum ) )
  {
    pWord = pWord2;
    goto NEXT_DIR_SEG;
  }

  nBlock = nSegStartBlock;
  pFileSpec = pWord + 5;

//  printf("TotalSegs -[%i] ; NextSeg -[%i] ; UsedSegs -[%i] ; SegStartBlock -[%i]\n",
//          *pWord, *(pWord+1), nUsedSegs, nSegStartBlock );

//  printf("nBlockNum -[%i] ; FileSize -[%i]\n",
//            nBlockNum, *(pFileSpec+4) );

  while( nBlock + *(pFileSpec+4) <= nBlockNum )
  {
    if( *pFileSpec == AKH ) { return 0; }

//    printf("nBlockNum -[%i] ; nSegStartBlock -[%i] ; nBlock -[%i] ; FileSize -[%i]\n",
//            nBlockNum, nSegStartBlock, nBlock, *(pFileSpec+4) );

    nBlock += *(pFileSpec+4);
    pFileSpec += 7;
  }

  nFileType = *pFileSpec++;

  i = 0;

  sprintf(str, "%u.bin", nBlock );

  if( nFileType == EMPT_FILE )
  {
    LookupFileName[i++] = '#';
    LookupFileName[i] = 0;
  }
  else
  if( nFileType == TEMP_FILE )
  {
    LookupFileName[i++] = '_';
    LookupFileName[i] = 0;
  }
  else
  {
    LookupFileName[i] = 0;

    R50_ASCII( LookupFileName + i, *pFileSpec++ );
    R50_ASCII( str, *pFileSpec++ );

    strcat( LookupFileName, str );
    strcat( LookupFileName, "." );

    R50_ASCII( str, *pFileSpec++ );
  }
  strcat( LookupFileName, str );

  LookupFileBlock = nBlockNum - nBlock;

//  printf("File name-[%s] ; File block -[%i]\n", LookupFileName, LookupFileBlock );
//  getch();

  return 1;
}


int HDReadDSK( unsigned int nHDnum,
               unsigned int nBlockNum,
               unsigned int nWordCount,
               unsigned int nEmulBufAddr )
{
  long nByteNum = 512;
  long nArrSize = FIRST_BLOCKS_SIZE - 512;
  int  handle;
  unsigned long offset;
  unsigned int nBytes = nWordCount*2;

  nByteNum *= nBlockNum;

//  sprintf( str, "\n...\n>HDReadDSK : = Unit-[%u] ; Block-[%u] ; WordCount-[%u]\n", nHDnum, nBlockNum, nWordCount );
//  HDLogFileStrOut( str );

  if( hDSK[nHDnum] )
  {

    memset( &memory[nEmulBufAddr], 0, nBytes );

    if( nBlockNum + nWordCount/256 > anDSKlen[nHDnum] )
    {
      nBytes = (anDSKlen[nHDnum] - nBlockNum )*512;
    }

    if( nDSKtype[nHDnum] == DIR_TYPE )
    {
      if(  nByteNum < nArrSize  )
      {
        if( nArrSize - nByteNum < nBytes ) { nBytes = nArrSize - nByteNum; }

// LogFileData.LogState = LOG_ON;
//
// sprintf( str, ">HDReadDSK : = Unit-[%u] ; Block-[%u] ; ByteNum-[%lu] ; WordCount-[%u] ; sizeof-[%lu] \n...\n\n",
//                nHDnum, nBlockNum, nByteNum, nWordCount, nArrSize );
// HDLogFileStrOut( str );
//
// LogFileData.LogState = LOG_OFF;

        memcpy( &memory[nEmulBufAddr], apnFirstBlocks[nHDnum]+nByteNum, nBytes );
      }
      else
      {
        if( Lookup( nHDnum, nBlockNum ) )
        {
          strcpy( str, apcPath[nHDnum] );
          strcat( str, strTmpDir );
          strcat( str, "/" );
          strcat( str, LookupFileName );

          if((handle = open(str, O_RDONLY|O_BINARY, S_IWRITE)) == -1)
          {
            strcpy( str, apcPath[nHDnum] );
            strcat( str, LookupFileName );

            handle = open(str, O_RDONLY|O_BINARY, S_IWRITE);
          }

          offset = LookupFileBlock;
          offset *= 512;

       //   printf("Opened -[%s] ; Offset -[%li] ; Bytes -[%i]\n",
       //          str, offset, nWordCount*2 );

          lseek(handle, offset, SEEK_SET );
          read( handle, &memory[nEmulBufAddr], nBytes );
          close(handle);

         // getch();
        }
      }
    }
    else
    {

//     printf("Offset -[%li] ; Bytes -[%i]\n", nByteNum, nWordCount*2 );

      lseek( hDSK[nHDnum], nByteNum, SEEK_SET );
      read(  hDSK[nHDnum], &memory[nEmulBufAddr], nBytes );
    }
  }
  else
  {
    return 0;
  }

  return 1;
}


void ResetNextArrFile( unsigned int nHDnum )
{
  nArrHDnum = nHDnum;
  nArrBlockNum = 0;
  pArrFileSpec = &ArrFileSpec;
}


int NextArrFile( void )
{
  static unsigned int *pWord, *pWord2, *pFileSpec;
//  static unsigned int    nUsedSegs;
  static unsigned int nNextSeg, nSegStartBlock, nBlock, nFileType;
  int i;
  int hSegsFile;
  unsigned long nSegNum;


  if( !nArrBlockNum )
  {
    pWord = apnFirstBlocks[nArrHDnum] + 3072;
//    nUsedSegs = *(pWord+2);
    nSegStartBlock = *(pWord+4);
    nNextSeg = *(pWord+1);
    pWord2 = apnFirstBlocks[nArrHDnum]+ 3072 + (nNextSeg-1)*1024;
    nArrBlockNum = nSegStartBlock;
    pFileSpec = pWord + 5;

//  hSegsFile = open( "Segs.LOG", O_CREAT | O_TRUNC	| O_WRONLY | O_TEXT, S_IWRITE	);
//  sprintf( str, "### SEG 1: \nStart Block-[%u]\nSegs Used-[%u]\nNext Seg-[%u]\n\n", nSegStartBlock, *(pWord+2), nNextSeg );
//  write( hSegsFile, str, strlen(str));
//  close( hSegsFile );

  }


GET_FILE:

  if( *pFileSpec != AKH )
  {
    (*pArrFileSpec).Type  = nFileType = *pFileSpec;
    (*pArrFileSpec).Block = nArrBlockNum;
    (*pArrFileSpec).Size  = *(pFileSpec+4);
    (*pArrFileSpec).Date  = *(pFileSpec+6);

    i = 0;

    sprintf(str, "%u.bin", nArrBlockNum );

    if( nFileType == EMPT_FILE )
    {
      (*pArrFileSpec).Name[i++] = '#';
      (*pArrFileSpec).Name[i] = 0;
    }
    else
    if( nFileType == TEMP_FILE )
    {
      (*pArrFileSpec).Name[i++] = '_';
      (*pArrFileSpec).Name[i] = 0;
    }
    else
    {
      (*pArrFileSpec).Name[i] = 0;

      R50_ASCII( (*pArrFileSpec).Name + i, *(pFileSpec+1) );
      R50_ASCII( str, *(pFileSpec+2) );

      strcat( (*pArrFileSpec).Name, str );
      strcat( (*pArrFileSpec).Name, "." );

      R50_ASCII( str, *(pFileSpec+3) );
      strcpy( (*pArrFileSpec).Ext, str );
    }
    strcat( (*pArrFileSpec).Name, str );

    nArrBlockNum += *(pFileSpec+4);
    pFileSpec += 7;

    return 1;
  }
  else
  if( nNextSeg )
  {
    pWord = pWord2;
    nSegStartBlock = *(pWord+4);
    nNextSeg = *(pWord+1);
    pWord2 = apnFirstBlocks[nArrHDnum]+3072+(nNextSeg-1)*1024;
    nArrBlockNum = nSegStartBlock;
    pFileSpec = pWord + 5;

    if( !nSegStartBlock ) { return 0; }

// nSegNum = pWord-(apnFirstBlocks[nArrHDnum]+3072);
// nSegNum /= 512;
// nSegNum++;
//
// hSegsFile = open( "Segs.LOG", O_APPEND	| O_WRONLY | O_TEXT, S_IWRITE );
// sprintf(str,"@@@ SEG %lu: \nStart Block-[%u]\nNext Seg-[%u]\n\n", nSegNum, nSegStartBlock, nNextSeg);
// write( hSegsFile, str, strlen(str));
// close( hSegsFile );
//
// LogFileData.LogState = LOG_ON;
// sprintf(str2, " ### NEXT SEG %u ### Start block-[%u]\n", nSegNum, nSegStartBlock );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;


    goto GET_FILE;
  }
  else
  {

// hSegsFile = open( "Segs.LOG", O_APPEND	| O_WRONLY | O_TEXT, S_IWRITE );
// sprintf(str,"\n--- End Of Segs ---\n\n");
// write( hSegsFile, str, strlen(str));
// close( hSegsFile );

    nArrBlockNum = 0;
    return 0;
  }

}


void MakeFileList( unsigned int nHDnum )
{
  ResetNextArrFile(nHDnum);

  pArrFileSpec = pArrFiles;

  memset( pArrFiles, 0, 2300*sizeof(ArrFileSpec) );

// LogFileData.LogState = LOG_ON;
// sprintf( str2, "\n vvv OLD FILE LIST vvv\n");
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

  while( NextArrFile() )
  {

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " ... file -[%s] ; block -[%u] ; size -[%u]\n", (*pArrFileSpec).Name, (*pArrFileSpec).Block, nArrBlockNum - (*pArrFileSpec).Block );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

    pArrFileSpec++;
  }

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " ^^^ OLD FILE LIST ^^^\n\n");
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

}



void ReflectChanges( unsigned int nHDnum )
{
  static struct ftime file_time_rec;
  struct ArrFileSpecType *pOldArrFileSpec = pArrFiles;
  int    handle;
  unsigned int rt_date;
  char   sNewFileName[24];

  ResetNextArrFile(nHDnum);

  sNewFileName[0] = 0;


  while( NextArrFile() )
  {
    if( !(*pArrFileSpec).Size && ((*pArrFileSpec).Type & EMPT_FILE ) )
    {
      continue;
    }

TRY_AGAIN:

    while( (*pOldArrFileSpec).Name[0] &&
           (( (*pArrFileSpec).Block > (*pOldArrFileSpec).Block ) )||
            ( !(*pOldArrFileSpec).Size && ((*pOldArrFileSpec).Type & EMPT_FILE )) )
    {
// LogFileData.LogState = LOG_ON;
// sprintf( str2, " !!! Looking -[%s][%u][%u]...SKIP -[%s][%u][%u]\n",(*pArrFileSpec).Name, (*pArrFileSpec).Block, (*pArrFileSpec).Size, (*pOldArrFileSpec).Name, (*pOldArrFileSpec).Block, (*pOldArrFileSpec).Size );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

      pOldArrFileSpec++;
    }

    strcpy( str, apcPath[nHDnum] );

    if( ((*pArrFileSpec).Name[0] == '_') ||
        ((*pArrFileSpec).Name[0] == '#')   )
    {
      strcat( str, strTmpDir );
      strcat( str, "/" );
    }
    strcat( str, (*pArrFileSpec).Name );



    if( (*pArrFileSpec).Block == (*pOldArrFileSpec).Block )
    {
      strcpy( str1, apcPath[nHDnum] );

      if( ((*pOldArrFileSpec).Name[0] == '_') ||
          ((*pOldArrFileSpec).Name[0] == '#')   )
      {
        strcat( str1, strTmpDir );
        strcat( str1, "/" );
      }
      strcat( str1, (*pOldArrFileSpec).Name );


      if( !(*pOldArrFileSpec).Size &&
          !strcmp( (*pArrFileSpec).Name, (*(pOldArrFileSpec+1)).Name ) )
      {

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " !!! OLD size -[0] ; NEXT OLD name -[%s]\n", (*(pOldArrFileSpec+1)).Name );
// HDLogFileStrOut( str2 );
// sprintf( str2, " ::: REMOVE -[%s]\n", str1 );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

        remove( str1 );
        pOldArrFileSpec++;
        goto TRY_AGAIN;
      }


      if( strcmp( (*pArrFileSpec).Name, (*pOldArrFileSpec).Name ) )
      {
        remove( str );

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " !!! OLD name -[%s] ; NEW name -[%s]\n", str1, str );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;


        if( (*pOldArrFileSpec).Name[0] == '#')
        {

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " !!! Creating -[%s]\n", str );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

          handle = open( str, O_CREAT | O_TRUNC	| O_WRONLY | O_BINARY, S_IWRITE	);
          close( handle );
        }
        else
        if( (*pOldArrFileSpec).Name[0] == '_' )
        {
          strcpy( sNewFileName, (*pArrFileSpec).Name );

          if( strstr( strNotRecodedFileExt, (*pArrFileSpec).Ext ) )
          {

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " ___ Rename : [%s] -> [%s]\n", str1, str );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

            rename( str1, str );
          }
          else
          {
            handle = open(str1, O_RDONLY|O_BINARY, S_IWRITE);
            CheckCodePage( handle );

            switch( nCodePage )
            {
              case CP_NONE:
              case CP_BIN:
              case CP_ASC:
              default:

                close(handle);
                rename( str1, str );

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " __$ Rename : [%s] -> [%s]\n", str1, str );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;


              break;

              // ..... //

              case CP_KOI8:

                if( !nInternalCP_KOI7 )
                {
                  goto DO_MIRROR;
                }
                else
                {
                  close(handle);
                  rename( str1, str );
                }

              break;

              // ..... //

              case CP_KOI7:

                if( nInternalCP_KOI7 )
                {
DO_MIRROR:
                  MirrorFile( handle, str );
                  close(handle);

                  strcpy( str, apcPath[nHDnum] );
                  strcat( str, strTmpDir );
                  strcat( str, "/" );
                  strcat( str, (*pArrFileSpec).Name );

                  remove( str );
                  rename( str1, str );
                }
                else
                {
                  close(handle);
                  rename( str1, str );
                }

              break;
            }


          }
        }
        else
        {
          if( !strcmp( sNewFileName, (*pOldArrFileSpec).Name ) )
          {
            goto SKIP_RENAME;
          }

          strcpy( str1, apcPath[nHDnum] );
          strcat( str1, strTmpDir );
          strcat( str1, "/" );
          strcat( str1, (*pOldArrFileSpec).Name );

          strcpy( str, apcPath[nHDnum] );
          strcat( str, strTmpDir );
          strcat( str, "/" );
          strcat( str, (*pArrFileSpec).Name );

          remove( str );

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " 222 Rename : [%s] -> [%s]\n", str1, str );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

          if( rename( str1, str ) )
          {
// LogFileData.LogState = LOG_ON;
// HDLogFileStrOut( " 222 Rename ERROR\n" );
// LogFileData.LogState = LOG_OFF;
          }

          if( (*pArrFileSpec).Name[0] == '#' )
          {
            remove( str );
          }


          strcpy( str1, apcPath[nHDnum] );
          strcat( str1, (*pOldArrFileSpec).Name );

          strcpy( str, apcPath[nHDnum] );
          strcat( str, (*pArrFileSpec).Name );

          remove( str );

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " 333 Rename : [%s] -> [%s]\n", str1, str );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

          if( rename( str1, str ) )
          {
// LogFileData.LogState = LOG_ON;
// HDLogFileStrOut( " 333 Rename ERROR\n" );
// LogFileData.LogState = LOG_OFF;
          }
SKIP_RENAME:
        }


        if( (*pArrFileSpec).Name[0] == '#' )
        {
          remove( str );
        }


        rt_date = (*pArrFileSpec).Date;

        file_time_rec.ft_tsec = 0;
        file_time_rec.ft_min  = 0;
        file_time_rec.ft_hour = 0;

        file_time_rec.ft_day   = (rt_date & 0x03E0) >> 5;

        file_time_rec.ft_month = (rt_date & 0x3C00) >> 10;

        file_time_rec.ft_year  = (rt_date & 0x001F)|((rt_date & 0xC000) >> 9);
        if( file_time_rec.ft_year < 8 )
        {
          file_time_rec.ft_tsec = 8 - file_time_rec.ft_year;

          file_time_rec.ft_year = 8;
        }
        file_time_rec.ft_year -= 8;

        handle = open(str, O_WRONLY|O_BINARY, S_IWRITE);
        setftime(handle, &file_time_rec);
        close( handle );

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " !!! OLD date -[%x] ; NEW date -[%x]\n", (*pArrFileSpec).Date, (*pOldArrFileSpec).Date );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

      }


      if( (*pArrFileSpec).Date != (*pOldArrFileSpec).Date )
      {

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " >>> CHANGED -> OLD date -[%x] ; NEW date -[%x]\n", (*pArrFileSpec).Date, (*pOldArrFileSpec).Date );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

        rt_date = (*pArrFileSpec).Date;

        file_time_rec.ft_tsec = 0;
        file_time_rec.ft_min  = 0;
        file_time_rec.ft_hour = 0;

        file_time_rec.ft_day   = (rt_date & 0x03E0) >> 5;

        file_time_rec.ft_month = (rt_date & 0x3C00) >> 10;

        file_time_rec.ft_year  = (rt_date & 0x001F)|((rt_date & 0xC000) >> 9);
        if( file_time_rec.ft_year < 8 )
        {
          file_time_rec.ft_tsec = 8 - file_time_rec.ft_year;

          file_time_rec.ft_year = 8;
        }
        file_time_rec.ft_year -= 8;

        handle = open(str, O_WRONLY|O_BINARY, S_IWRITE);
        setftime(handle, &file_time_rec);
        close( handle );
      }


      if( (*pArrFileSpec).Type < 0 && (*pOldArrFileSpec).Type > 0 )
      { //   
        _dos_setfileattr(str, _A_ARCH | _A_SYSTEM);
      }
      else
      if( (*pArrFileSpec).Type > 0 && (*pOldArrFileSpec).Type < 0 )
      { //   
        _dos_setfileattr(str, _A_ARCH | _A_NORMAL);
      }

      pOldArrFileSpec++;
    }
    else
    if( (*pArrFileSpec).Name[0] != '#' )
    {

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " ---> New Block-[%u] ; Old Block-[%u]\n", (*pArrFileSpec).Block, (*pOldArrFileSpec).Block  );
// HDLogFileStrOut( str2 );
// sprintf(str2, " !!! New FILE -[%s]\n", str );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;


      handle = open( str, O_CREAT | O_TRUNC	| O_WRONLY | O_BINARY, S_IWRITE	);
      close( handle );

      rt_date = (*pArrFileSpec).Date;

      file_time_rec.ft_tsec = 0;
      file_time_rec.ft_min  = 0;
      file_time_rec.ft_hour = 0;

      file_time_rec.ft_day   = (rt_date & 0x03E0) >> 5;

      file_time_rec.ft_month = (rt_date & 0x3C00) >> 10;

      file_time_rec.ft_year  = (rt_date & 0x001F)|((rt_date & 0xC000) >> 9);
      if( file_time_rec.ft_year < 8 )
      {
        file_time_rec.ft_tsec = 8 - file_time_rec.ft_year;

        file_time_rec.ft_year = 8;
      }
      file_time_rec.ft_year -= 8;

      handle = open(str, O_WRONLY|O_BINARY, S_IWRITE);
      setftime(handle, &file_time_rec);
      close( handle );
    }
  }

}


int HDWriteDSK( unsigned int nHDnum,
                unsigned int nBlockNum,
                unsigned int nWordCount,
                unsigned int nEmulBufAddr )
{
  static struct stat statbuf;

  unsigned long nByteNum = 512;
  unsigned long nArrSize = FIRST_BLOCKS_SIZE - 512;
  int  handle, nMirrorFlag, nLastBytes;
  unsigned long offset;
  unsigned int  nBytes = nWordCount*2;
  unsigned long nSpace;
  unsigned int  x;

//  unsigned int  *pnBuf;

  nByteNum *= nBlockNum;

// LogFileData.LogState = LOG_ON;
// sprintf( str, "\n...\n>HDWriteDSK : = Unit-[%u] ; Block-[%u] ; WordCount-[%u]\n", nHDnum, nBlockNum, nWordCount );
// HDLogFileStrOut( str );
// LogFileData.LogState = LOG_OFF;

  if( hDSK[nHDnum] )
  {
    if( nBlockNum + nWordCount/256 > anDSKlen[nHDnum] )
    {
      nBytes = (anDSKlen[nHDnum] - nBlockNum )*512;
    }

    if( nDSKtype[nHDnum] == DIR_TYPE )
    {
      if(  nBlockNum < 6 )
      { //      
        strcpy(str, apcPath[nHDnum]);
        strcat(str, strBootFileName);

        offset = nBlockNum;
        offset *= 512;

        handle = open(str, O_WRONLY	| O_BINARY, S_IWRITE);

        lseek( handle, offset, SEEK_SET );
        write( handle, &memory[nEmulBufAddr], nBytes );
        close( handle );
      }

      if( nByteNum < nArrSize )
      { //     
        if( nArrSize - nByteNum < nBytes ) { nBytes = nArrSize - nByteNum; }

        MakeFileList( nHDnum );

        memcpy( apnFirstBlocks[nHDnum]+nByteNum, &memory[nEmulBufAddr], nBytes );

        ReflectChanges( nHDnum );
      }
      else
      { //     
        if( Lookup( nHDnum, nBlockNum ) )
        {
//          strcpy( str, apcPath[nHDnum] );
//
//          if( strchr(LookupFileName, '_') ||
//              strchr(LookupFileName, '#')   )
//          {
//            strcat( str, strTmpDir );
//            strcat( str, "/" );
//          }
//          strcat( str, LookupFileName );

          strcpy( str, apcPath[nHDnum] );
          strcat( str, strTmpDir );
          strcat( str, "/" );
          strcat( str, LookupFileName );

          if( (LookupFileName[0] == '_') ||
              (LookupFileName[0] == '#')   )
          {
            nMirrorFlag = 0;
          }
          else
          {
            nMirrorFlag = 1;
          }

// LogFileData.LogState = LOG_ON;
// sprintf(str2, " ??? Looking -[%s] ...", str );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;


          if((handle = open(str, O_RDWR	| O_BINARY, S_IWRITE)) == -1)
          {
// LogFileData.LogState = LOG_ON;
// sprintf(str2, " *** NOT Found ***\n" );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

            strcpy( str, apcPath[nHDnum] );
            strcat( str, LookupFileName );

// LogFileData.LogState = LOG_ON;
// sprintf(str2, " ??? Looking -[%s] ...", str );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

             if((handle = open(str, O_WRONLY	| O_BINARY, S_IWRITE)) != -1)
             {
// LogFileData.LogState = LOG_ON;
// sprintf(str2, " !!! Found !!!\n" );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;
             }
             else
             {
// LogFileData.LogState = LOG_ON;
// sprintf(str2, " *** NOT Found ***\n" );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;
             }

            nMirrorFlag = 0;
          }
          else
          {
// LogFileData.LogState = LOG_ON;
// sprintf(str2, " !!! Found !!!\n" );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;
          }


// LogFileData.LogState = LOG_ON;
// sprintf(str1, "!!! Write: File-[%s] ; Mirror-[%u]\n", str, nMirrorFlag );
// HDLogFileStrOut( str1 );
// LogFileData.LogState = LOG_OFF;


// LogFileData.LogState = LOG_ON;
// sprintf(str1, " !!! LOCKUP nHDnum-[%u] ; nBlockNum-[%u] ; Found-[%s] ; Block-[%u]\n", nHDnum, nBlockNum, str, LookupFileBlock );
// HDLogFileStrOut( str1 );
// LogFileData.LogState = LOG_OFF;

          offset = LookupFileBlock;
          offset *= 512;

          fstat(handle, &statbuf);

          if( offset > statbuf.st_size )
          {
         //   nSpace = offset - statbuf.st_size;

            if( !statbuf.st_size )
            {
              nSpace = 512;
            }
            else
            {
              nSpace = statbuf.st_size%512;
              if( nSpace ) { nSpace = 512 - nSpace; }
            }

            if( nSpace )
            {
              lseek( handle, statbuf.st_size, SEEK_SET );

            //  pnBuf = malloc(nSpace);
            //  memset( pnBuf, 0, nSpace );
            //  write( handle, pnBuf, nSpace );
            //  free(pnBuf);

              memset( str1, 0, nSpace );
              write( handle, str1, nSpace );
            }

// LogFileData.LogState = LOG_ON;
// sprintf(str1, "!!! Fill: File-[%s] ; Size-[%lu] ; offset-[%lu] ; Space-[%lu]\n", str, statbuf.st_size, offset, nSpace );
// HDLogFileStrOut( str1 );
// LogFileData.LogState = LOG_OFF;

          }

       //   printf("Opened -[%s] ; Offset -[%li] ; Bytes -[%i]\n",
       //          str, offset, nWordCount*2 );

          nLastBytes = statbuf.st_size%512;

          if( nLastBytes ) { nLastBytes -= 512; }

          if( offset + nBytes >= statbuf.st_size - nLastBytes )
          {
            x = 0;
            while( !memory[nEmulBufAddr+nBytes-1-x] && ( x < 512 ) )
            {
              x++;
            }

            if( x >= 512 ) { x = 0; }
            else
            {
              nBytes -= x;

// LogFileData.LogState = LOG_ON;
// sprintf(str1, "!!! Trim: File-[%s] ; Size-[%lu] ; offset-[%lu] ; Trimed-[%u]\n", str, statbuf.st_size, offset, x );
// HDLogFileStrOut( str1 );
// LogFileData.LogState = LOG_OFF;

            }
          }

          lseek( handle, offset, SEEK_SET );
          write( handle, &memory[nEmulBufAddr], nBytes );

          if( nMirrorFlag )
          {
            strcpy( str, apcPath[nHDnum] );
            strcat( str, LookupFileName );
            lseek( handle, 0, SEEK_SET );
            CheckCodePage(-1);
            MirrorFile( handle, str );
          }

          close( handle );

         // getch();
        }
        else
        {
// LogFileData.LogState = LOG_ON;
// sprintf(str, " !!! LOOKUP nHDnum-[%u] ; nBlockNum-[%u] FAILED !!!\n", nHDnum, nBlockNum );
// HDLogFileStrOut( str );
// LogFileData.LogState = LOG_OFF;
        }
      }
    }
    else
    {
      lseek( hDSK[nHDnum], nByteNum, SEEK_SET );
      write( hDSK[nHDnum], &memory[nEmulBufAddr], nWordCount*2 );
    }
  }
  else
  {
    return 0;
  }

  return 1;
}


int NextRT11File( char *path )
{
  struct dirent *ent;
  char          *pChar = NULL;
  int           i,j;
  int           nExtFlag;
  int           done;

//  int      fc2;
//static int fc;

//if( nFindFirstFlag ) { nFindFirstFlag = fc = 0; }

NEXT_DIR_ENTRY:

//  if(pChar) { printf("File name-[%s] ; nExtFlag-[%i] ; i-[%i] \n", pChar, nExtFlag, i  ); }

  nFileName1 =  ASCII_R50("XXX");;
  nFileName2 = ASCII_R50("XXX");;
  nFileExt = ASCII_R50("XXX");
  nFileSize = 7;
  nFileDate = 0;

//  fc2 = fc;
//  while( fc2 > 1000 ) { fc2 -= 1000; }
//  sprintf( str, "%03i", fc2 );
//  nFileName2 =  ASCII_R50(str);;
//  sprintf( str, "%03i", fc/1000 );
//  nFileName1 =  ASCII_R50(str);;
//
//  if( ++fc > 3000 ) { return 0; }
//  else { return 1; }


  if( !nFindFirstFlag )
  {
    done = findnext(&ffblk);
  }
  else
  {
    sprintf(str,"%s/*.*",path);
    done = findfirst(str, &ffblk, FA_RDONLY | FA_ARCH | FA_SYSTEM );
    nFindFirstFlag = 0;
  }

  if( !done )
  {
    if( ffblk.ff_name[0] == '.' ) { goto NEXT_DIR_ENTRY; }

    pChar = ffblk.ff_name;
    nExtFlag = 0;

    for( i = 0 ; ; i++ )
    {
      if( nExtFlag ) { nExtFlag++; }

      if( pChar[i] == '.' )
      {
        nExtFlag++;
        if( i > 6 ) { goto NEXT_DIR_ENTRY; }
      }

      if( !pChar[i] )
      {
        if( (!nExtFlag && i > 6) || nExtFlag > 5 || nExtFlag < 3 ) { goto NEXT_DIR_ENTRY; }

        ConvertFileName( &ffblk );

        if( nNextRT11FileHDnum >= 0 ) { printf("Mounting file -[%s]          \r", ffblk.ff_name ); }

        return 1;
      }

      if( strchr( (char*)R50_CHARS, pChar[i] ) == 0 ) { goto NEXT_DIR_ENTRY; }
    }
  }

  return !done;
}


void ClearTmpDir( unsigned int nHDnum )
{
  DIR           *dir;
  struct dirent *ent;

  strcpy( str, apcPath[nHDnum] );
  strcat( str, strTmpDir );
  mkdir(str);

  dir = opendir( str );
  while((ent = readdir(dir)) != NULL)
  {
    strcpy(str1,str);
    strcat(str1,"/");
    strcat(str1,ent->d_name);
//    printf("DEL-[%s]\n", str1 );
    remove( str1 );
  }
  closedir(dir);
}


void FinalCleanup( void )
{
  int nHDnum;

  for( nHDnum = 0 ; nHDnum <= 7 ; nHDnum++ )
  {
    if( nDSKtype[nHDnum] == DIR_TYPE )
    {
      ClearTmpDir(nHDnum);
    }
  }
}
#pragma exit FinalCleanup


void MountHD( unsigned int nHDnum )
{
  DIR           *dir;
  int           nFileCount = 0, nTotalFileCount = 0;
  long nArrSize = FIRST_BLOCKS_SIZE;
  long i;
  int  nFilesPerSeg;
  int  nSegsUsed;
  int  nSeg = 1, nFile = 0;
  int  *pWord;
  unsigned int  nBlock = 68;
  int  handle;


  memset( apnFirstBlocks[nHDnum], 0, nArrSize);

  strcpy(str, apcPath[nHDnum]);
  strcat(str, strBootFileName);

  if((handle = open( str, O_RDONLY|O_BINARY, S_IWRITE ) ) != -1)
  {
    read( handle, apnFirstBlocks[nHDnum], 3072 );
  }
  else
  {
    handle = open( str, O_CREAT | O_TRUNC	| O_WRONLY | O_BINARY, S_IWRITE	);
  }
  close( handle );


  nFindFirstFlag = 1;
  nNextRT11FileHDnum = -1;

  while( NextRT11File( apcPath[nHDnum] ) )
  {
//    printf("%s\n",ffblk.ff_name);
   if( ++nFileCount > MAX_RT11_FILES - 1 )
   {
     break;
   }
  }

  cprintf("Files to mount-[%i] ... ", nFileCount );

  nFilesPerSeg = nFileCount/31;

  if( nFilesPerSeg < 72 ) { nFilesPerSeg++; }

  nSegsUsed = 31;

  if( nFilesPerSeg < 31 )
  {
    nSegsUsed = nFilesPerSeg;
    nFilesPerSeg = 31;

    if( nSegsUsed*nFilesPerSeg < nFileCount ) { nSegsUsed++; }
  }

  cprintf("nSegsUsed -[%i] ; nFilesPerSeg -[%i]\r\n", nSegsUsed, nFilesPerSeg );

  *(apnFirstBlocks[nHDnum]+980) = 6;

  pWord = apnFirstBlocks[nHDnum]+3072;
  *pWord++ = 31;
  if( nSeg < nSegsUsed )
  {
    *pWord++ = 2;
  }
  else
  {
    *pWord++ = 0;
  }
  *pWord++ = nSegsUsed;
  *pWord++ = 0;
  *pWord++ = nBlock;

  nFindFirstFlag = 1;
  nNextRT11FileHDnum = nHDnum;

  ClearTmpDir( nHDnum );

  while( NextRT11File( apcPath[nHDnum] ) &&  ++nTotalFileCount <= nFileCount )
  {
    nFile++;

//    printf("nSeg -[%i] ; nSegsUsed -[%i] ; nFile -[%i] ; nFilesPerSeg -[%i]\n", nSeg, nSegsUsed, nFile, nFilesPerSeg );

    if( nFile >= nFilesPerSeg )
    {
      *pWord = AKH;

      nSeg++; nFile = 0;

      pWord = apnFirstBlocks[nHDnum]+(3072+(nSeg-1)*1024);

//      printf("New seg-[%i] ; nSegsUsed -[%i] ; pWord-[%08LX]\n", nSeg, nSegsUsed, pWord );

      *pWord++ = 31;

      if( nSeg < nSegsUsed )
      {
        *pWord++ = nSeg+1;
      }
      else
      {
        *pWord++ = 0;
      }

      *pWord++ = nSegsUsed;
      *pWord++ = 0;
      *pWord++ = nBlock;
    }

    *pWord++ = nFileType;
    *pWord++ = nFileName1;
    *pWord++ = nFileName2;
    *pWord++ = nFileExt;
    *pWord++ = nFileSize;
    *pWord++ = 0;
    *pWord++ = nFileDate;

    nBlock += nFileSize;
  }

  nFile++;

  if( nFile > nFilesPerSeg )
  {
    *pWord = AKH;

    nSeg++; nFile = 0;

    pWord = apnFirstBlocks[nHDnum]+(3072+(nSeg-1)*1024);
    *pWord++ = 31;
     if( nSeg < nSegsUsed )
     {
       *pWord++ = nSeg+1;
     }
     else
     {
       *pWord++ = 0;
     }
    *pWord++ = nSegsUsed;
    *pWord++ = 0;
    *pWord++ = nBlock;
  }

  nFileSize = DOS_HD_SIZE - nBlock;

  *pWord++ = EMPT_FILE;
  *pWord++ = ASCII_R50("EMP");
  *pWord++ = ASCII_R50("TY ");
  *pWord++ = ASCII_R50("FIL");
  *pWord++ = nFileSize;
  *pWord++ = 0;
  *pWord++ = 0;


//  strcpy( str, apcPath[nHDnum] );
//  strcat( str, strTmpDir );
//  strcat( str, "/" );
//  sprintf( str1, "#%u.bin", nBlock );
//  strcat( str, str1 );
//
//  hEmptyFile = open( str, O_CREAT | O_TRUNC	| O_WRONLY | O_BINARY, S_IWRITE	);
//  close( hEmptyFile );

  *pWord = AKH;

  anDSKlen[nHDnum] = DOS_HD_SIZE;

}


void RemountHD( unsigned int nHDnum )
{
  ClearTmpDir(nHDnum);
  MountHD( nHDnum );
}


int MountDosDir( unsigned int nHDnum, char* pcItemStr )
{
  DIR           *dir;
  char cLastSim;


  if( (dir = opendir( pcItemStr )) == NULL ) { return 0; }
  closedir(dir);

  hDSK[nHDnum] = 1;
  apnFirstBlocks[nHDnum] = malloc( FIRST_BLOCKS_SIZE );

  cLastSim = pcItemStr[strlen( pcItemStr )-1];

  if( cLastSim != '/' && cLastSim != '\\' )
  {
    strcat( pcItemStr, "/" );
  }

  apcPath[nHDnum] = malloc( strlen( pcItemStr ) );
  strcpy( apcPath[nHDnum], pcItemStr );

  printf("Mounting DOS dir-[%s] ...\n", apcPath[nHDnum] );

  MountHD( nHDnum );

//  getch();

  return 1;
}

int MountHdUnit( unsigned int nHDnum, char* pcItemStr, char* pcIni_str )
{
  long  lFileLen;

    hDSK[nHDnum] = open( pcItemStr, O_RDWR	| O_BINARY );

    if( hDSK[nHDnum] <= 0 )
    {
      if( !MountDosDir( nHDnum, pcItemStr ) )
      {
        printf("DOS dir or DSK file not found--[%s]\n", pcItemStr );
        printf("Error in command--[%s]\n", pcIni_str );
        return 0;
      }
      nDSKtype[nHDnum] = DIR_TYPE;
    }
    else
    {
      nDSKtype[nHDnum] = DSK_TYPE;
      lFileLen = filelength( hDSK[nHDnum] );
      anDSKlen[nHDnum] = lFileLen/512;
    }
//    printf("HD%i attached to [%s] \n", nHDnum, pcItemStr );

 LogFileData.LogState = LOG_ON;
 sprintf(str2, "HD%i attached to [%s] \n", nHDnum, pcItemStr );
 HDLogFileStrOut( str2 );
 printf(str2);
 LogFileData.LogState = LOG_OFF;


  return 1;
}


void CreateXFile()
{
 int i,j;
 int hXFile;
 int anBuf[1000];


 hXFile = open( "x.bin", O_CREAT | O_TRUNC	| O_WRONLY | O_BINARY, S_IWRITE	);

 for( i = 0 ; i <= 500 ; i++ )
 {
   for( j = 0 ; j < 256 ; j++ )
   {
     anBuf[j] = i;
   }

   write( hXFile, anBuf, 512 );
 }

 close( hXFile );
}


void ReadIniFile( char* pcIniFileName )
{
  int    i;
  static char   cByte[4];
  char   *pIniStr;
  int    not_eof = 1;
  int hIni;

  if( (hIni = open( pcIniFileName, O_RDONLY ) ) == -1L)
  {
    sprintf(str,"INI file '%s' error",pcIniFileName);
    perror(str);
    getch();
    exit(0);
  }

  printf("Using INI file: %s\n", pcIniFileName );
// sleep(1);

  while( not_eof )
  {
    pIniStr = str;
    cByte[0] = 0;

    while( not_eof )
    {
      not_eof = read(  hIni, &cByte, 1 );

      *pIniStr = toupper(cByte[0]);

      if( cByte[0] == '\n' )
      {
        *pIniStr = 0;
        break;
      }

      pIniStr++;
    }

    if( !UseIniStr( str ) )
    {
      printf("Wrong command in ini file--[%s]\n", pcIniFileName );
      sleep(3);
      exit(0);
    }
  }
}


int UseIniStr( char* pcIni_str )
{
static char *pcChar;
static char item[60];

int         nHDnum;
//long        lFileLen;

 pcChar = pcIni_str;

// printf("Ini str--[%s]\n", pcChar );
// sleep(1);

  GetItem( &pcChar, &item[0] );

  if( item[0] == 'A' && item[1] == 'T' && item[2] == 'T' )
  { //  'ATT'
    GetItem( &pcChar, &item[0] );
    if( item[0] == 'H' && item[1] == 'D' )
    { // 'ATT HD0' .. 'ATT HD7'
      nHDnum = item[2] - '0';
      if( nHDnum < 0 || nHDnum > 7 )
      {
        printf("Wrong HD drive number--[%i]\n", nHDnum );
        printf("Error in command--[%s]\n", pcIni_str );
        return 0;
      }
    }

    GetItem( &pcChar, &item[0] );

//    if( hDSK[nHDnum] > 0 ) { close( hDSK[nHDnum] ); }
//    hDSK[nHDnum] = open( &item[0], O_RDWR	| O_BINARY );
//
//    if( hDSK[nHDnum] <= 0 )
//    {
//      printf("DSK file not found--[%s]\n", &item[0] );
//      printf("Error in command--[%s]\n", pcIni_str );
//      return 0;
//    }
//    else
//    {
//      lFileLen = filelength( hDSK[nHDnum] );
//      anDSKlen[nHDnum] = lFileLen/512;
//      printf("HD%i attached to [%s] \n", nHDnum, &item[0] );
//    }

    return MountHdUnit( nHDnum, &item[0], pcIni_str );
  }
  else
  if( item[0] == 'B' && item[1] == 'O' && item[2] == 'O' )
  { //  'BOOT'
    GetItem( &pcChar, &item[0] );
    if( item[0] == 'H' && item[1] == 'D' )
    { // 'BOOT HD0' ... 'BOOT HD7'
      nHDnum = item[2] - '0';
      if( nHDnum < 0 || nHDnum > 7 )
      {
        printf("Wrong HD drive number--[%i]\n", nHDnum );
        printf("Error in command--[%s]\n", pcIni_str );
        return 0;
      }
      nBootHDnum = nHDnum;
    }
    nBootRt11Flag = 0;
    GetItem( &pcChar, &item[0] );
    if( item[0] == 'R' && item[1] == 'T' )
    {
      nBootRt11Flag = 1;
    }
  }
  else
  if( item[0] == 'S' && item[1] == 'E' && item[2] == 'T' )
  { //  'SET'
    GetItem( &pcChar, &item[0] );
    if( strstr( item, "CPU_LIMIT") )
    { // 'SET CPU_LIMIT'
      GetItem( &pcChar, &item[0] );
      nCPU_Limit = strtol(&item[0], NULL, 0);
    }
    else
    if( strstr( item, "BPS_LIMIT") )
    { // 'SET BPS_LIMIT'
      GetItem( &pcChar, &item[0] );
      nBPS_Limit = strtol(&item[0], NULL, 0);
    }
    else
    if( strstr( item, "RECODE") )
    { // 'SET RECODE ON/OFF'
      GetItem( &pcChar, &item[0] );
      if( strstr( &item[0], "ON") )
      {
        nRecodeFlag = 1;
      }
      else
      {
        nRecodeFlag = 0;
      }
    }
    else
    if( strstr( item, "CURSOR") )
    { // 'SET CURSOR NORMAL/BLOCK'
      GetItem( &pcChar, &item[0] );
      if( strstr( item, "BLOCK") || strstr( item, "UNDER") )
      {
        nNormalCursor = 0;
      }
      else
      {
        nNormalCursor = 1;
      }
    }
    else
    if( strstr( item, "EXTERN") )
    { // 'SET EXTERNAL_CODEPAGE WIN/DOS'
      GetItem( &pcChar, &item[0] );
      if( strstr( item, "DOS")  )
      {
        nExternalCP_WIN = 0;
      }
      else
      {
        nExternalCP_WIN = 1;
      }
    }
    else
    if( strstr( item, "INTERN") )
    { // 'SET INTERNAL_CODEPAGE KOI7/KOI8'
      GetItem( &pcChar, &item[0] );
      if( strstr( item, "8")  )
      {
        nInternalCP_KOI7 = 0;
      }
      else
      {
        nInternalCP_KOI7 = 1;
      }
    }
  }

  return 1;
}


void GetItem( char** ppcChar , char* pcItemStr )
{
  char *pcChar = *ppcChar;
  char *pcItem = pcItemStr;

  while( *pcChar == ' ' ) { pcChar++; }

  while( *pcChar && *pcChar != ' ' ) { *pcItem++ = *pcChar++; }

  *pcItem = 0;

  *ppcChar = pcChar;

// printf("Item str--[%s]\n", pcItemStr );
}


//void CreateManyFiles( int nNumberOfFiles )
//{
//  int x = 0;
//  int handle;
//
//
//  while( x++ < nNumberOfFiles )
//  {
//    sprintf(str, "RT11.DSK/%u.txt", x);
//
//    handle = open( str, O_CREAT | O_TRUNC	| O_WRONLY | O_BINARY, S_IWRITE	);
//    write( handle, str, strlen(str) );
//    close( handle );
//  }
//}



//void interrupt trap_handler(void)
//{
//  int nIntNum;
//
//  asm{
//       sti
//
//       mov ax, cs
//       ror ax, 1
//       mov nIntNum, ax
//  }
//
//  trap_counts[nIntNum]++;
//  total_trap_count++;
//
//}


