# include <sys/stat.h>

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>
#include <fcntl.h>
#include <time.h>
#include <stdlib.h>
#include <bios.h>
#include <errno.h>
#include <io.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#include "em.h"


#define NORM_FILE      02000
#define PROT_FILE      0100000


#define  ESC     27
#define  CR      13
#define  LF      10
#define  DEL      8
#define  TAB      9
#define  SPACE   32
#define  BEEP     7
#define  BS       8
#define  RUS     14
#define  LAT     15
#define  CTRL_Z  26


typedef unsigned char  byte;
typedef unsigned int   radix50;



const byte  KOI_LAT[]={
                      00,  01,  02,  03,  04,  05,  06,  07, 010, 011,
                     012, 013, 014, 015, 016, 017,

                     020, 021, 022, 023, 024, 025, 026, 027, 030, 031,
                     032, 033, 034, 035, 036, 037,

                     ' ', '!', '"', '#', '$', '%', '&','\'', '(', ')',
                     '*', '+', ',', '-', '.', '/',

                     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
                     ':', ';', '<', '=', '>', '?',

                     '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
                     'J', 'K', 'L', 'M', 'N', 'O',

                     'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y',
                     'Z', '[','\\', ']', '^', '_',

                     '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i',
                     'j', 'k', 'l', 'm', 'n', 'o',

                     'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y',
                     'z', '{', '|', '}', '~', '',

                     //  - KOI8 //

                      00,  01,  02,  03,  04,  05,  06,  07, 010, 011,
                     012, 013, 014, 015, 016, 017,

                     020, 021, 022, 023, 024, 025, 026, 027, 030, 031,
                     032, 033, 034, 035, 036, 037,

                     ' ', '!', '"', '#', '$', '%', '&','\'', '(', ')',
                     '*', '+', ',', '-', '.', '/',

                     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
                     ':', ';', '<', '=', '>', '?',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', '',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', '',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', '',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', ''

                    };


const byte  KOI_RUS[]={
                      00,  01,  02,  03,  04,  05,  06,  07, 010, 011,
                     012, 013, 014, 015, 016, 017,

                     020, 021, 022, 023, 024, 025, 026, 027, 030, 031,
                     032, 033, 034, 035, 036, 037,

                     ' ', '!', '"', '#', '$', '%', '&','\'', '(', ')',
                     '*', '+', ',', '-', '.', '/',

                     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
                     ':', ';', '<', '=', '>', '?',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', '',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', '',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', '',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', '',

                     //  - KOI8 //

                      00,  01,  02,  03,  04,  05,  06,  07, 010, 011,
                     012, 013, 014, 015, 016, 017,

                     020, 021, 022, 023, 024, 025, 026, 027, 030, 031,
                     032, 033, 034, 035, 036, 037,

                     ' ', '!', '"', '#', '$', '%', '&','\'', '(', ')',
                     '*', '+', ',', '-', '.', '/',

                     '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
                     ':', ';', '<', '=', '>', '?',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', '',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', '',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', '',

                     '', '', '', '', '', '', '', '', '', '',
                     '', '', '', '', '', ''

                    };



const byte  DOS_KOI7[]={ 00,  01,  02,  03,  04,  05,  06,  07, 010, 011, 012,
                        013, 014, 015, 016, 017,

                        020, 021, 022, 023, 024, 025, 026, 027, 030, 031, 032,
                        033, 034, 035, 036, 037,

                        ' ', '!', '"', '#', '$', '%', '&','\'', '(', ')', '*',
                        '+', ',', '-', '.', '/',

                        '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':',
                        ';', '<', '=', '>', '?',

                        '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
                        'K', 'L', 'M', 'N', 'O',

                        'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
                        '[','\\', ']', '^', '_',

                        '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j',
                        'k', 'l', 'm', 'n', 'o',

                        'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
                        '{', '|', '}', '~', '',

                        'a', 'b', 'w', 'g', 'd', 'e', 'v', 'z', 'i', 'j', 'k',
                        'l', 'm', 'n', 'o', 'p',

                        'r', 's', 't', 'u', 'f', 'h', 'c', '~', '{', '}', '',
                        'y', 'x', '|', '`', 'q',

                        'A', 'B', 'W', 'G', 'D', 'E', 'V', 'Z', 'I', 'J', 'K',
                        'L', 'M', 'N', 'O', 'P',

                        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
                        '?', '?', '?', '?', '?',

                        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
                        '?', '?', '?', '?', '?',

                        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
                        '?', '?', '?', '?', '?',

                        'R', 'S', 'T', 'U', 'F', 'H', 'C', '^', '[', ']', '_',
                        'Y', 'X', '\\', '@', 'Q',

                        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
                        '?', '?', '?', '?', '?',
                       };


const char *WinPatterns[] = {
//                   "",  "",   "",   "",
//                   "",   "",  "",  "",
//                   "",  "",  "",   "",
                     "on",  "j",   "q",   "ee",
                     "b",   "m`",  "me",  "nr",
                     "dn",  "hg",  "s",   "n",
                     NULL
};


const char *KOI8Patterns[] = {
                     "po",  "k",   "s",   "ee",
                     "w",   "na",  "ne",  "ot",
                     "do",  "iz",  "u",   "o",
                     NULL
};


enum { LOG_OFF, LOG_ON, LOG_SUSPENDED };

extern struct LogFileDataType {
       char FileName[120];
       int  AppendFlag;
       int  LogState;
} LogFileData;

extern void HDLogFileStrOut( char* );




struct date_type {
       int   year;   //  .                 //
       byte  month;  //   .        //
       byte  day;    //    .    //
} DosFileDate;


extern radix50 nFileName1;
extern radix50 nFileName2;
extern radix50 nFileExt;
extern unsigned int  nFileSize;
extern unsigned int  nFileDate;
extern int  nFileType;


extern int  nRecodeFlag;
extern int nInternalCP_KOI7;
extern int nExternalCP_WIN;
extern char strNotRecodedFileExt[];

extern char strTmpDir[];

extern int  nNextRT11FileHDnum;
extern char *apcPath[9];

extern int           *nInputCache;
extern unsigned int  nInputCacheSize;


extern char str[];
extern char str1[];
extern char str2[];

extern radix50 ASCII_R50( char *str );


int  nCodePageChecked;
unsigned int  nCacheBytesGot;
unsigned int  nCacheBytesStored;

char strLatCrLfExt[]="MAC BAS C PAS COM";

char *asCodePages[] = {"CP_NONE","CP_BIN","CP_DOS","CP_WIN","CP_KOI7","CP_KOI8","CP_ASC"};

//enum code_page_type { CP_NONE, CP_BIN, CP_DOS, CP_WIN,
//                      CP_KOI7, CP_KOI8, CP_ASC };

int  nCodePage;
int  nRusLatChange;
int  nRusLat;
int  nRusFlag;
int  nLatCrLfFlag;





unsigned int Get_Date_From_DOS_Format( unsigned short date, unsigned short time )
{
 unsigned int rt_date = 0;
 unsigned int year_up;

   DosFileDate.day   =  date & 0x1F;
   DosFileDate.month = (date & 0x1E0) >> 5;
   DosFileDate.year  = ((date & 0xFE00) >> 9) + 1980;

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " DOS date -[%X] ; '%u.%u.%u' \n", date, DosFileDate.day, DosFileDate.month, DosFileDate.year );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;


//   printf("Date-[%i.%i.%i] ; ", DosFileDate.day, DosFileDate.month, DosFileDate.year );

   if( DosFileDate.year > 2003 )
   {
     year_up = DosFileDate.year - 1972;
     year_up >>= 5;
     rt_date |= year_up;
     rt_date <<= 4;
     DosFileDate.year -= year_up*32;

  //   printf(" year_up -[%u] ; year-[%u] ", year_up, DosFileDate.year );
  //   getch();
   }
   else
   if( (DosFileDate.year == 1980)&& time && (time <= 8) )
   {
     DosFileDate.year -= time;

  //   printf(" time -[%u] ; year-[%u] ", time, DosFileDate.year );
  //   getch();
   }

   rt_date |= DosFileDate.month;
   rt_date <<= 5;

   rt_date |= DosFileDate.day;
   rt_date <<= 5;

   rt_date |= DosFileDate.year - 1972;

//   printf("RT-[%04X]\n", rt_date );

  return rt_date;
}



int WIN_To_DOS( int arg )
{
  int c = arg & 0xFF;

  if( c > 127 )
  {
    if( (c >= 192) && (c <= 239) ) { c -= 64; }
    else
    if( c >= 240 ) { c -= 16; }
    else
    { c = '?'; }
  }

  return c;
}


int IsRusLatDependent( int byte )
{
  if( (byte == '*') || (byte >= 64 ) ||
      (byte == '"') || (byte == '/') || (byte == '\'') )
  {
    return 1;
  }

  if( nLatCrLfFlag && ( (byte == CR) || (byte == LF) ) )
  {
    return 1;
  }

  return 0;
}


int DOS_To_KOI7( int arg )
{
  int byte = arg;

  nRusLatChange = 0;

  if( (byte & 128) && !nRusFlag )
  {
    nRusLatChange++;
    nRusFlag = 1;
    nRusLat = RUS;
  }
  else
  if( !(byte & 128) && nRusFlag && IsRusLatDependent( byte ) )
  {
    nRusLatChange++;
    nRusFlag = 0;
    nRusLat = LAT;
  }

//  if( nRusFlag )
//  {
    byte = DOS_KOI7[ byte ];
//  }

  return byte;
}


int DOS_To_KOI8( int arg )
{
  int byte = arg;

  nRusLatChange = 0;

  if( byte & 128 )
  {
    nRusFlag = 1;
  }
  else
  {
    nRusFlag = 0;
  }

  byte = DOS_KOI7[ byte ];

  if( nRusFlag )
  {
    byte |= 0200;
  }

  return byte;
}



int IsCodePage_BIN( int res )
{
  static unsigned int nBadResCount;
  static unsigned int nZerosCount;
  static unsigned long int nByteCount;

  if( nCacheBytesStored == 1 )
  {
    nZerosCount = 0;
    nBadResCount = 0;
    nByteCount = 1;
  }
  else
  {
    nByteCount++;
  }

  if( !res )
  {
    nZerosCount++;
  }
  else
  if( res && ( res < 07 ) )
  {

    if( ++nBadResCount > nByteCount/1024 + 1 )
    {
//printf( "\nBIN#1 nByteCount-[%lu] res-[%03o] stored-[%i] RUS-[%i] nBadResCount-[%u]",
//         nByteCount, res, nCacheBytesStored, nRUS_Count, nBadResCount );
//while(!kbhit());
 //getch();

      nCodePage = CP_BIN;
      return 1;
    }
  }

  if( (res > 0 ) && nZerosCount )
  {

//printf( "\nBIN#2 nByteCount-[%lu] res-[%03o] stored-[%i] RUS-[%i] Zeros-[%i]",
//          nByteCount, res, nCacheBytesStored, nRUS_Count, nZerosCount );
//while(!kbhit());
 //getch();

    nCodePage = CP_BIN;
    return 1;
  }

  return 0;
}


int IsCodePage_KOI7( int res )
{
  static int nRUS_Count;

  if( nCacheBytesStored == 1 ) { nRUS_Count = 0; }

  if( res == RUS ) { nRUS_Count++; }

  if( ( (res < 0) || (nCacheBytesStored >= nInputCacheSize/2 -24) )
      && nRUS_Count )
  {

//printf( "\nKOI7 res-[%03o] stored-[%i] RUS-[%i]",
//         res, nCacheBytesStored, nRUS_Count );

    nCodePage = CP_KOI7;
    return 1;
  }

  return 0;
}

//
//
//

int CheckKOI8Str( char* tested_str )
{
  char *pcPatternStr;
  int i;

  if( !(*tested_str) || (*tested_str == CR) ) { return 0; }

//printf( " TSTR[%s] ", pcTestedStr );

  i = 0;

  while( pcPatternStr = (char*)KOI8Patterns[i++] )
  {
    if( !strcmp( pcPatternStr, tested_str ) )
    {
//printf( "([%s])", pcPatternStr );
//while(!kbhit());
//getch();

      return 1;
    }
  }


  i = 0;

  while( pcPatternStr = (char*)WinPatterns[i++] )
  {
    if( !strcmp( pcPatternStr, tested_str ) )
    {
//printf( "<[%s]>", pcPatternStr );
//while(!kbhit());
//getch();

      return -1;
    }
  }

  return 0;
}

//

int IsCodePage_KOI8( int res )
{
  static char  *pcTestedChar;
  static int   nKoi8UC = 0;
  static int   nKoi8LC = 0;
  static int   nKoi8Count = 0;
  static char  tested_str[12];


  if( nCacheBytesStored == 1 )
  {
    pcTestedChar = tested_str;
    *tested_str = 0;

    nKoi8UC = 0;
    nKoi8LC = 0;
    nKoi8Count = 0;
  }

  //         KOI8

  if( ( (res&0177) == ' ' ) || ( !(res&0200) ) )
  {
    *pcTestedChar = 0;
    pcTestedChar = tested_str;

    nKoi8Count += CheckKOI8Str( tested_str );

    *tested_str = 0;
  }
  else
  if( pcTestedChar - tested_str < 2 )
  {
    *pcTestedChar++ = tolower(res&0177);
  }
  else
  {
    *tested_str = 0; //      2 .
  }


  //       WIN  KOI8
  //      .  
  //      WIN  KOI8  
  //    (,    WIN -  ,
  //    KOI8 - ,  ).

  if( (res >= 0200+'@') && (res <= 0200+'_') )
  {
    nKoi8LC++;
    if( nKoi8UC ) { nKoi8Count++; }
    nKoi8UC = 0;
  }
  else
  {
    if( (res >= 0200+'`') && (res <= 0200+'~') )
    {
      nKoi8UC++;
      if( nKoi8LC ) { nKoi8Count--; }
      nKoi8LC = 0;
    }
    else
    {
      nKoi8UC = 0;
    }

    nKoi8LC = 0;
  }


  if( ( (res < 0) || (nCacheBytesStored >= nInputCacheSize/2 -24) )
      && ( nKoi8Count > 0 ) )
  {

//printf( "\nKOI8 res-[%03o] stored-[%i] RUS-[%i] nKoi8Count-[%i]",
//         res, nCacheBytesStored, nRUS_Count, nKoi8Count );
//while(!kbhit());

    nCodePage = CP_KOI8;
    return 1;
  }

  return 0;
}



int IsCodePage_WIN( int res )
{
  static int nWIN_Count;

  if( nCacheBytesStored == 1 ) { nWIN_Count = 0; }

  if( (res > 0xF1) && ( res < 0xFF ) ) { nWIN_Count++; }
  if( (res > 0xBF) && ( res < 0xE0 ) ) { nWIN_Count++; }

  if(( (res < 0) || (nCacheBytesStored >= nInputCacheSize/2 -24) )
       && nWIN_Count )
  {

//printf( "\nWIN res-[%03o] stored-[%i] RUS-[%i]",
//         res, nCacheBytesStored, nRUS_Count );

    nCodePage = CP_WIN;
    return 1;
  }

  return 0;
}


int IsCodePage_DOS( int res )
{
  static int nDOS_Count;

  if( nCacheBytesStored == 1 ) { nDOS_Count = 0; }

  if( (res > 0x7F) && ( res < 0xB0 ) )
  {
    nDOS_Count++;

//printf("[%X:%c]", res, (unsigned char)res );
  }

  if(( (res < 0) || (nCacheBytesStored >= nInputCacheSize/2 -24) )
       && nDOS_Count )
  {

//printf( "\nDOS res -[%03o] ; stored-[%i] ; DOS_Count -[%i]\n",
//         res, nCacheBytesStored, nDOS_Count );

    nCodePage = CP_DOS;
    return 1;
  }

  return 0;
}



void CheckCodePage( int handle )
{
  static int buf[2];
  int res = 0;

  nCacheBytesStored = 0;
  nCacheBytesGot = 0;
  nCodePageChecked = 0;
  nCodePage = CP_NONE;

  if( handle == -1)
  {
    nCodePageChecked++;
    return;
  }

  while( !nCodePageChecked && (res >= 0)
         && (nCacheBytesStored < (nInputCacheSize/2 -12) ))
  {
    res = read(handle, &buf, 1 );

    if( res <= 0 ) { res = -2; }
    else { res = buf[0]; }

    nInputCache[ nCacheBytesStored++ ] = res;

    if(   IsCodePage_BIN ( res )
       || IsCodePage_KOI8( res )
       || IsCodePage_KOI7( res )
       || IsCodePage_WIN ( res )
       || IsCodePage_DOS ( res )
      )
    {
      nCodePageChecked++;
      return;
    }
  }

  //      . //

  nCodePage = CP_ASC;
  nCodePageChecked++;
}



int ReadByte( int handle )
{
  static int buf[2];
  int res;

  if( !nCodePageChecked )
  {
    CheckCodePage( handle );
  }


  if( nCacheBytesGot < nCacheBytesStored )
  {
    res = nInputCache[ nCacheBytesGot++ ];
  }
  else
  {
    res = read(handle, &buf, 1 );
    if( res <= 0 ) { res = -2; }
    else { res = buf[0]; }
  }

  return res;
}



void WriteByte( int handle1, int byte )
{
  static char buf[2];

  buf[0] = (unsigned char)byte;

  write( handle1, buf, 1 );
}



void RecodeFile( char *str, char *str1 )
{
  int byte, byte_count = 0;
  int handle, handle1;

  handle  = open( str,  O_RDONLY | O_BINARY, S_IWRITE);

//printf("File -[%s] :\n", str);

  CheckCodePage( handle );

//printf("checked -[%u] : codepage -[%s]\n", nCacheBytesStored, asCodePages[nCodePage] );

  switch( nCodePage )
  {
    case CP_NONE:
    case CP_BIN:
    case CP_ASC:
    default:

      close( handle  );
      return;

//    break;

    // ..... //

    case CP_WIN:
    case CP_DOS:

      nRusFlag = 0;
      nRusLatChange = 0;

    break;

    // ..... //

    case CP_KOI8:

      if( !nInternalCP_KOI7 )
      {
        nRusFlag = 0;
        nRusLatChange = 0;
      }
      else
      {
        close( handle  );
        return;
      }

    break;

    // ..... //

    case CP_KOI7:

      if( nInternalCP_KOI7 )
      {
        nRusFlag = 0;
        nRusLatChange = 0;
      }
      else
      {
        close( handle  );
        return;
      }

    break;

  }


  handle1 = open( str1, O_CREAT | O_TRUNC	| O_WRONLY | O_BINARY, S_IWRITE	);

  while( ( byte = ReadByte(handle) ) >= 0 )
  {
    byte_count++;

    if( nCodePage == CP_WIN )
    {
      byte = WIN_To_DOS( byte );
    }

    if( nInternalCP_KOI7 && ( nCodePage != CP_KOI7 ) )
    {
      byte = DOS_To_KOI7( byte );
    }
    else
    if( !nInternalCP_KOI7 && ( nCodePage != CP_KOI8 ) )
    {
      byte = DOS_To_KOI8( byte );
    }


    if( nRusLatChange )
    {
      byte_count++;
      WriteByte( handle1, nRusLat );
    }

    WriteByte( handle1, byte );
  }

  close( handle  );
  close( handle1 );

  nFileSize = byte_count/512;

  if( byte_count%512 ) { nFileSize++; }

}


void ConvertFileName( struct ffblk* pffblk )
{
  char acFileName1[4], acFileName2[4], acFileExt[4], sim;
  long x = (*pffblk).ff_fsize/512;
  char *pChar = (*pffblk).ff_name;
  char *f_name = pChar;
  int  i;

//printf("NAME : [%s]\n", f_name );

//  if( (*pffblk).ff_fsize%512 || !(*pffblk).ff_fsize ) { x++; }
  if( (*pffblk).ff_fsize%512 ) { x++; }

  nFileSize = x;

//  printf("Name-[%s] ; Size-[%i] ; ", (*pffblk).ff_name, nFileSize );

// LogFileData.LogState = LOG_ON;
// sprintf( str2, " !!! DOS File -[%s] ; ", (*pffblk).ff_name );
// HDLogFileStrOut( str2 );
// LogFileData.LogState = LOG_OFF;

  nFileDate = Get_Date_From_DOS_Format( (*pffblk).ff_fdate, (*pffblk).ff_ftime );

  nFileType = NORM_FILE;

  if( (*pffblk).ff_attrib & FA_SYSTEM )
  {
    nFileType = PROT_FILE | NORM_FILE;
  }

  acFileName1[3] = 0;
  acFileName2[3] = 0;
  acFileExt[3]   = 0;

  for( i = 0 ; i <= 5 ; i++ )
  {
    if( !*pChar || *pChar == '.' )
    {
      sim = ' ';
    }
    else
    {
      sim = toupper(*pChar++);
    }

    if( i < 3 ) { acFileName1[i]   = sim; }
    else        { acFileName2[i-3] = sim; }
  }

  if( *pChar == '.' ) { pChar++; }

  for( i = 0 ; i < 3 ; i++ )
  {
    if( !*pChar )
    {
      sim = ' ';
    }
    else
    {
      sim = toupper(*pChar++);
    }

    if( i < 3 ) { acFileExt[i]   = sim; }
  }

  nFileName1 = ASCII_R50(acFileName1);
  nFileName2 = ASCII_R50(acFileName2);
  nFileExt = ASCII_R50(acFileExt);


  if( nRecodeFlag && (nNextRT11FileHDnum >= 0)
      && (!strstr( strNotRecodedFileExt, acFileExt )) )
  {
    strcpy( str,  apcPath[ nNextRT11FileHDnum ] );
    strcat( str, f_name );

    strcpy( str1, apcPath[ nNextRT11FileHDnum ] );
    strcat( str1, strTmpDir );
    strcat( str1, "/" );
    strcat( str1, f_name );

    // CRLF   LAT       //
    nLatCrLfFlag = 0;

    if( strstr( strLatCrLfExt, acFileExt ) )
    {
      nLatCrLfFlag++;
    }

    RecodeFile( str, str1 );
  }
}


int KOI_To_DOS( int arg )
{
//  int byte = arg & 0177;
  int byte = arg & 0377;

  while( byte >= 0 )
  {
    if( byte == RUS )
    {
       nRusFlag = 1;
       return 0;
    }
    else
    if( byte == LAT )
    {
       nRusFlag = 0;
       return 0;
    }


    if( nRusFlag == 1 )
    {
      return KOI_RUS[ byte ];
    }
    else
    {
      return KOI_LAT[ byte ];
    }

  };

  return byte;
}


int DOS_To_WIN( int arg )
{
  int c = arg;

  if( c > 127 )
  {
    if( (c >= 128) && (c <= 175) ) { c += 64; }
    else
    if( (c >= 224) && (c <= 239) ) { c += 16; }
    else
    { c = '?'; }
  }

  return c;
}


void MirrorFile( int handle, char *str )
{
  int byte;
  int handle1;

  handle1 = open( str, O_CREAT | O_TRUNC	| O_WRONLY | O_BINARY, S_IWRITE	);

  nRusFlag = 0;

  while( ( byte = ReadByte(handle) ) >= 0 )
  {
    byte = KOI_To_DOS( byte );

    //  RUS  LAT   0
    if( !byte ) { continue; }

    if( nExternalCP_WIN )
    {
      byte = DOS_To_WIN( byte );
    }  

    WriteByte( handle1, byte );
  }

  close( handle1 );

}


