#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <SYS\STAT.H>
#include <io.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <strsafe.h>
#include <string>

#include "wcxhead.h"


//////////////////////////////////
typedef unsigned char        byte;
typedef unsigned short       word;
typedef unsigned long       dword;
typedef unsigned long long  qword;
typedef unsigned short int  radix50;
//////////////////////////////////


/* mandatory functions */
static HANDLE	(__stdcall *pOpenArchive)(tOpenArchiveData *ArchiveData) = NULL;
static int		(__stdcall *pReadHeader)(HANDLE hArcData, tHeaderData *HeaderData) = NULL;
static int		(__stdcall *pProcessFile)(HANDLE hArcData, int Operation, char *DestPath, char *DestName) = NULL;
static int		(__stdcall *pCloseArchive)(HANDLE hArcData) = NULL;

/* optional functions */
static int		(__stdcall *pPackFiles)(char *PackedFile, char *SubPath, char *SrcPath, char *AddList, int Flags) = NULL;
static int		(__stdcall *pDeleteFiles)(char *PackedFile, char *DeleteList) = NULL;
static int		(__stdcall *pGetPackerCaps)(void) = NULL;
static BOOL		(__stdcall *pCanYouHandleThisFile)(char *FileName) = NULL;



void WINtoDOS( byte *pFileBuf, unsigned int uLength )
{
    byte    *pChar = pFileBuf;

	for( int i = 0 ; i < uLength ; i++ )
	{
		if( *pChar == 0xA8 ) { *pChar = 0xF0; }
		else
		if( *pChar == 0xB8 ) { *pChar = 0xF1; }
		else
		if( *pChar > 127 )
		{
			if((*pChar >= 192) && (*pChar <= 239))
			{
				*pChar -= 64;
			}
			else
			if( *pChar >= 240 ) 
			{
			    *pChar -= 16;
			}
		}
		pChar++;
	}
}


void PrintError(LPTSTR lpszFunction) 
{ 
    // Retrieve the system error message for the last-error code

    LPVOID lpMsgBuf;
    LPVOID lpDisplayBuf;
    DWORD dw = GetLastError(); 

    FormatMessage(
        FORMAT_MESSAGE_ALLOCATE_BUFFER | 
        FORMAT_MESSAGE_FROM_SYSTEM |
        FORMAT_MESSAGE_IGNORE_INSERTS,
        NULL,
        dw,
        MAKELANGID(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT),
        (LPTSTR) &lpMsgBuf,
        0, NULL );

    // Display the error message

    lpDisplayBuf = (LPVOID)LocalAlloc(LMEM_ZEROINIT, 
        (lstrlen((LPCTSTR)lpMsgBuf) + lstrlen((LPCTSTR)lpszFunction) + 40) * sizeof(TCHAR)); 
    StringCchPrintfA((LPTSTR)lpDisplayBuf, 
        LocalSize(lpDisplayBuf) / sizeof(TCHAR),
        TEXT("%s failed with error %d: %s"), 
        lpszFunction, dw, lpMsgBuf); 

//    MessageBox(NULL, (LPCTSTR)lpDisplayBuf, TEXT("Error"), MB_OK); 

	WINtoDOS( (byte*)lpDisplayBuf, lstrlen((LPCTSTR)lpDisplayBuf) );
    printf("%s\n", lpDisplayBuf );

    LocalFree(lpMsgBuf);
    LocalFree(lpDisplayBuf);
}


int main(int argc, char *argv[])
{
	int hINI = open( "XDSK.ini", O_RDONLY | O_BINARY );

	if( hINI <= 0 )
	{
CREATE_INI: ;

		hINI = open( "XDSK.ini", O_RDWR | O_BINARY | O_CREAT, S_IREAD|S_IWRITE );
		if( hINI > 0 )
		{
			char str[512];
			sprintf(str,"DSK.wcx_path = C:\\totalcmd\\PLUGINS\\wcx\\RT-11dsk\\RT-11dsk.wcx\r\n");
			write( hINI, str, strlen(str)+1 );
			close( hINI );
		}
		
		printf("Place DSK.wcx path in XDSK.ini\n");
		
		return 0;		
	}

	char wcx_path[2048];

	{
		char ini_str[2048];
		
		int nRes = read( hINI, ini_str, sizeof(ini_str) );
		close( hINI );
		
		char *pSrc = strchr(ini_str,'=');
		
		if( !pSrc++ ) { goto CREATE_INI; }
		
		char *pDst = wcx_path;
		
		while( (*pSrc == ' ' || *pSrc == '\t' || *pSrc == '"' ) && pSrc < ini_str+sizeof(ini_str)-8 ) { pSrc++; }
		while( (*pSrc != '\r' && *pSrc != '\n' && *pSrc != '"') && pSrc < ini_str+sizeof(ini_str)   ) { *pDst++ = *pSrc++; }
		*pDst = '\0';

		if( argc < 2 )
		{
			sprintf(ini_str,"wcx_path:[%s]\n", wcx_path );
			printf(ini_str);
		}

		int hTst = open( wcx_path, O_RDONLY | O_BINARY );
		if( hTst <= 0 )
		{
			printf("wcx file NOT found !!!\n");
			return 0;
		}
		close(hTst);
	}

	//////////////////////////////////////

	HINSTANCE  hWCX;
	
	if( !( hWCX = LoadLibrary(wcx_path)) )
	{
		PrintError("LoadLibrary");
		return 0;
	}

	//////////////////////////////////////

	if( argc < 2 )
	{
		printf("\n");
		printf("DSK.wcx plugin interface utility v0.1 ("__DATE__")\n");
		printf("\n");
		printf("Usage:\n");
		printf("  XDSK <image_name> [/?]");
		printf("\n");
		printf("  /T - list image type\n");
		printf("  /H - list image header\n");

		goto END;
	}


	char acDskFile[2048];

	
	{
		strcpy( acDskFile, argv[1] );
		
		if( !strchr( acDskFile, '\\' ) )
		{
			strcpy( acDskFile, ".\\" );
			strcat( acDskFile, argv[1] );
		}

		int hTst = open( acDskFile, O_RDONLY | O_BINARY );
		if( hTst <= 0 )
		{
			printf("\n");
			printf("Image NOT found: %s\n", acDskFile );
			goto END;
		}
		close(hTst);
	}


	/* mandatory */
	pOpenArchive =			(HANDLE (__stdcall *)(tOpenArchiveData *))    GetProcAddress( hWCX, "OpenArchive" );
	pReadHeader =			(int (__stdcall *)(HANDLE,tHeaderData *))     GetProcAddress( hWCX, "ReadHeader"  );
	pProcessFile =			(int (__stdcall *)(HANDLE,int,char *,char *)) GetProcAddress( hWCX, "ProcessFile" );
	pCloseArchive =			(int (__stdcall *)(HANDLE))                   GetProcAddress( hWCX, "CloseArchive");

	/* optional */
	pPackFiles =			(int (__stdcall *)(char *,char *,char *,char *,int)) GetProcAddress( hWCX, "PackFiles"    );
	pDeleteFiles =			(int (__stdcall *)(char *,char *))                   GetProcAddress( hWCX, "DeleteFiles"  );
	pGetPackerCaps =		(int (__stdcall *)(void))                            GetProcAddress( hWCX, "GetPackerCaps");



	if( !pOpenArchive )
	{
		printf("DLL function NOT found: OpenArchive\n");
		goto END;
	}

	if( !pReadHeader )
	{
		printf("DLL function NOT found: ReadHeader\n");
		goto END;
	}

	if( !pCloseArchive )
	{
		printf("DLL function NOT found: CloseArchive\n");
		goto END;
	}



	tOpenArchiveData  ArcData;
	ArcData.ArcName = acDskFile;
	
	HANDLE pDD = pOpenArchive( &ArcData );

	if( !pDD )
	{
//		printf("Image Type: \n");
		printf("UNKNOWN");
		goto END;
	}

	tHeaderData  HeaderData;

	while( !pReadHeader( pDD, &HeaderData ) )
	{
//		printf( HeaderData.FileName );	printf("\n");
	}

	pCloseArchive( pDD );


	char acClipboardText[64*1024];

	if( OpenClipboard( NULL ) )//  
	{
		HANDLE hData;

		hData = GetClipboardData( CF_TEXT );//    
		char* chBuffer = (char*)GlobalLock(hData);// 
		if( chBuffer ) { strcpy( acClipboardText, chBuffer ); }
		GlobalUnlock(hData);// 
		CloseClipboard();//  
	}

	WINtoDOS( (byte*)acClipboardText, strlen(acClipboardText) );


 	if( argc == 3 )
	{
		char argv2[256];
		strcpy( argv2, argv[2] );
		
		if( strlen(argv2)< 2 || ( argv2[0] != '-' && argv2[0] != '/' ) )
		{
			printf( acClipboardText );
			goto END;
		}
		
		switch( argv2[1] )
		{
			case 't':
			case 'T':
			{// Print Image Type
				char substr[] = "Format :   ";
				char *pFirst = strstr( acClipboardText, substr );
				pFirst += strlen( substr );
				char *pLast = pFirst;
				while( *pLast != '\r' ) 
				{
//					printf("%c\n", *pLast );
					pLast++;
				};
				*pLast = '\0';
//				printf("Image Type:\n");
				printf("%s", pFirst );
				goto END;
			}
			
			case 'h':
			case 'H':
			{// Print Image Header
				char *pLast = acClipboardText;
				for( int i = 0 ; i < 7 ; i++ )
				{
					pLast = strchr( pLast, '\r' );
					pLast++;
				}
				*--pLast = '\0';
			}
		}
	}

	printf( acClipboardText );

END: ;

	FreeLibrary( hWCX );

    return 0;
}
