//
// heap.h
//

#ifndef HEAP_DEFS
#define HEAP_DEFS

struct heap_stats {
	DWORD	nTotal;
	DWORD	nUsed;
	DWORD	nFree;
};

extern void xHeapStats( HANDLE, heap_stats* );
extern DWORDLONG xFreeMemorySize( void );


inline HANDLE xHeapCreate( DWORD nInitialSize = 10*1024*1024 )
{
	return HeapCreate( 0, nInitialSize, 0 );
}

inline void xHeapDestroy( HANDLE hHeap )
{
	HeapDestroy( hHeap );
}

inline void* xMalloc( HANDLE heap, size_t size )
{
    return HeapAlloc( heap, HEAP_ZERO_MEMORY, size );
}

inline void xFree( HANDLE heap, void* block )
{
    if( heap && block )
        HeapFree( heap, 0, block );
}

inline void* xRealloc( HANDLE heap, void* block, size_t size )
{
    if( block && !size )
    {
        HeapFree( heap, 0, block );
        return 0;
    }
    else if( block && size )
        return HeapReAlloc( heap, HEAP_ZERO_MEMORY, block, size );
    else if( !block && size )
        return HeapAlloc( heap, HEAP_ZERO_MEMORY, size );
    else // !block && !size
        return 0;
}

inline void xHeapCompact( HANDLE heap )
{
	HeapCompact( heap, 0 );
}


#endif

