//
// heap.cpp -   .
//

#include <windows.h>

// #include <stdlib.h>
// #include <stdio.h>
// #include <string.h>

#include "heap.h"


void xHeapStats( HANDLE hHeap, heap_stats* pStats )
{
	PROCESS_HEAP_ENTRY pr_h_en;

	pStats->nTotal = 0;
	pStats->nUsed  = 0;
	pStats->nFree  = 0;

	pr_h_en.lpData = NULL;

	while( HeapWalk( hHeap, &pr_h_en ) != FALSE )
	{
		pStats->nTotal += pr_h_en.cbData;

		if( pr_h_en.wFlags & PROCESS_HEAP_ENTRY_BUSY )
			pStats->nUsed += pr_h_en.cbData;
		else
			pStats->nFree += pr_h_en.cbData;
	}
}

DWORDLONG xFreeMemorySize( void )
{
	MEMORYSTATUSEX Stats;

	GlobalMemoryStatusEx( &Stats );

	return Stats.ullAvailVirtual;
}