// WCX.cpp : Defines the entry point for the DLL application.
//

#include "main.h"
#include "heap.h"

static FILE *WCX_log = 0;

 #define LOG(x) fwrite(x,1,strlen(x),WCX_log); fflush(WCX_log);
// #define LOG(x)

static 	tProcessDataProc  ProcessDataProc;

static HANDLE hHeap = 0;

static HINSTANCE  ghInstance;
static dword      dwThreadId;


BOOL APIENTRY DllMain( HANDLE hinstDLL, DWORD fdwReason, LPVOID )
{
    if( !hinstDLL )
    {
        return FALSE;
    }

    switch( fdwReason )
    {
        case DLL_PROCESS_ATTACH:
        {
			hHeap = xHeapCreate();
        
			WCX_log = fopen( "WCX.log", "a");
            LOG( "process attach \n" );
            
			ghInstance = (HINSTANCE)hinstDLL;
			dwThreadId = GetCurrentThreadId();
        }  
        break;
            
        case DLL_THREAD_ATTACH:
        {
//            LOG( "thread attach \n" );
        }
        break;
            
        case DLL_THREAD_DETACH:
        {
//            LOG( "thread detach \n" );
        }
        break;
            
        case DLL_PROCESS_DETACH:
        {
            if( hHeap )
            {
                xHeapDestroy( hHeap );
                hHeap = 0;
            }

            LOG( "process detach \n" );
            fclose( WCX_log );
        }
        break;
    }

	return TRUE;
}

HANDLE __stdcall OpenArchive( tOpenArchiveData* ArchiveData )
{
	char str[512];
	if( ArchiveData->OpenMode == PK_OM_LIST	) { sprintf( str, "OpenArchive - PK_OM_LIST :  ArcName--[%s]\n", ArchiveData->ArcName );    }
	else                                      { sprintf( str, "OpenArchive - PK_OM_EXTRACT :  ArcName--[%s]\n", ArchiveData->ArcName ); }
	LOG( str );

	dsk_descriptor *pDD = (dsk_descriptor*) xMalloc( hHeap, sizeof(dsk_descriptor) );

    strcpy( pDD->DSK_File, ArchiveData->ArcName ); 
    return pDD;
}


static int  uRecord_Num = 0;

int __stdcall ReadHeader( HANDLE hArcData, tHeaderData* HeaderData )
{
	LOG( "ReadHeader \n" );

    dsk_descriptor *pDD = (dsk_descriptor*) hArcData;

	if( !pDD || !HeaderData ) 
		return E_BAD_DATA;

	if( uRecord_Num )
	{
		uRecord_Num = 0;
		return E_END_ARCHIVE;
	}

    uRecord_Num++;

	DWORD uRes;
	HANDLE hDSK = CreateFile( pDD->DSK_File, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, 0, OPEN_EXISTING, 0, 0 );
	ReadFile( hDSK, HeaderData->FileName, sizeof( HeaderData->FileName ), &uRes, NULL );
	CloseHandle( hDSK );
    
    return 0;
}


int __stdcall ProcessFile( HANDLE hArcData, int Operation, char* DestPath, char* DestName )
{
	if( Operation == PK_SKIP ) 
	{
		LOG( "ProcessFile -- PK_SKIP\n" );
		return 0;
	}

	if( Operation == PK_TEST ) 
	{
		LOG( "ProcessFile -- PK_TEST\n" );
		return 0;
	}

	LOG( "ProcessFile: PK_EXTRACT \n" );
	
    dsk_descriptor *pDD = (dsk_descriptor*) hArcData;

	char str[512];
	sprintf( str, "ProcessFile :  DestPath--[%s]\n", DestPath );
	LOG( str );
	sprintf( str, "ProcessFile :  DestName--[%s]\n", DestName );
	LOG( str );

	char  path[ MAX_PATH ];
	
	path[0] = '\0';
	
	if( DestPath )
	{
		strcpy( path, DestPath );
	}
	
    if( DestName )
    {
		strcat( strcat( path, path[0] ? "\\" : "" ), DestName );
    }

	HANDLE hFile = CreateFile( path, GENERIC_WRITE, FILE_SHARE_READ, 0, CREATE_ALWAYS, FILE_ATTRIBUTE_ARCHIVE, 0 );
	if( !hFile )
	{
		return E_ECREATE;
	}

    DWORD writed;
	
	char acFileBuf[512];
	strcpy( acFileBuf, "file content" );
	
	WriteFile( hFile, acFileBuf, strlen(acFileBuf), &writed, 0 );

	CloseHandle( hFile );

	return 0;
}


void __stdcall SetChangeVolProc( HANDLE hArcData, tChangeVolProc pChangeVolProc )
{
  //  ChangeVolProc = pChangeVolProc;
}

void __stdcall SetProcessDataProc( HANDLE hArcData, tProcessDataProc pProcessDataProc )
{
	ProcessDataProc = pProcessDataProc;
}

int __stdcall CloseArchive ( HANDLE hArcData )
{
	char str[512];
	LOG( "CloseArchive \n" );

    dsk_descriptor *pDD = (dsk_descriptor*) hArcData;

	xFree( hHeap, pDD );
	xHeapCompact( hHeap );

	heap_stats stats;
	xHeapStats( hHeap, &stats );
	sprintf(str,"HEAP : Total -[%i] ; Used -[%i] ; Free -[%i]\n", stats.nTotal, stats.nUsed, stats.nFree );
	LOG( str );

  	return 0;
}

int __stdcall PackFiles( char *PackedFile, char *SubPath, char *SrcPath, char *AddList, int Flags )
{
	char str[512];
	sprintf( str, "PackFiles :  PackedFile--[%s]\n", PackedFile );
	LOG( str );
	sprintf( str, "PackFiles :  SrcPath--[%s]\n", SrcPath );
	LOG( str );

	HANDLE hDSK = CreateFile( PackedFile, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, 0, OPEN_EXISTING, 0, 0 );

	if( hDSK == INVALID_HANDLE_VALUE && GetLastError() == ERROR_FILE_NOT_FOUND )
	{
		LOG( "PackFiles - NEW DSK !!!\n" );
	}

	CloseHandle( hDSK );

	tHeaderData        HeaderData;
	tOpenArchiveData   ArchiveData;
	char acArcName[MAX_PATH*2];

	ArchiveData.ArcName = acArcName;

	strcpy( ArchiveData.ArcName, PackedFile );

	ArchiveData.OpenMode = PK_OM_LIST;

	dsk_descriptor *pDD = (dsk_descriptor*)OpenArchive( &ArchiveData );
	
	if( !pDD )
	{
		LOG( "PackFiles -E- UNKNOWN_FORMAT\n" );
		return E_UNKNOWN_FORMAT;
	}

	char	acFile[ MAX_PATH ];

	for( char *pChar = AddList ; strlen(pChar) ; pChar += strlen(pChar)+1 )
	{
		sprintf( str, "--> [%s]\n", pChar );
		LOG( str );

		strcpy( acFile, SrcPath );
		strcat( acFile, pChar );

		HANDLE hFile = CreateFile( acFile, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, 0, OPEN_EXISTING, 0, 0 );
		
		DWORD ulFileSize = 0;
		DWORD FileSizeHigh = 0;
		
		if( hFile != INVALID_HANDLE_VALUE )
		{
			ulFileSize = GetFileSize( hFile, &FileSizeHigh );
		}

		if( FileSizeHigh )
		{
			LOG( "Too big file..\n" );
			CloseHandle( hFile );
			continue;
		}

		//
		//  Pack file here..
		//
			DWORD uRes;
			hDSK = CreateFile( PackedFile, GENERIC_WRITE, FILE_SHARE_READ, 0, OPEN_EXISTING, 0, 0 );
			WriteFile( hDSK, pChar, strlen( pChar ), &uRes, NULL );
			SetEndOfFile( hDSK );
			CloseHandle( hDSK );
		//
		//
		//

		CloseHandle( hFile );
	}

	CloseArchive( (HANDLE)pDD );

	return 0;
}

int __stdcall DeleteFiles (char *PackedFile, char *DeleteList)
{
	char str[512];
	sprintf( str, "DeleteFiles :  PackedFile--[%s]\n", PackedFile );
	LOG( str );


	tHeaderData        HeaderData;
	tOpenArchiveData   ArchiveData;
	char acArcName[MAX_PATH*2];

	ArchiveData.ArcName = acArcName;

	strcpy( ArchiveData.ArcName, PackedFile );

	ArchiveData.OpenMode = PK_OM_LIST;

	dsk_descriptor *pDD = (dsk_descriptor*)OpenArchive( &ArchiveData );

	if( !pDD )
	{
		LOG( "DeleteFiles -E- UNKNOWN_FORMAT\n" );
		return E_UNKNOWN_FORMAT;
	}
	
	int nFilesToDelete = 0;
	for( char *pChar = DeleteList ; strlen(pChar) ; pChar += strlen(pChar)+1 )
	{
		nFilesToDelete++;
	}

	int  nFilesDeleted = 0;
	bool bSkip = false;

	char FileName[512];
	memset( FileName, '\0', sizeof( FileName ) );
	DWORD uRes;
	HANDLE hDSK = CreateFile( PackedFile, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, 0, OPEN_EXISTING, 0, 0 );
	ReadFile( hDSK, FileName, sizeof( FileName ), &uRes, NULL );
	CloseHandle( hDSK );
	

	while( ReadHeader( (HANDLE)pDD, &HeaderData ) != E_END_ARCHIVE )
	{
		if( bSkip ) { continue; }
		
		for( char *pChar = DeleteList ; strlen(pChar) ; pChar += strlen(pChar)+1 )
		{
			if( !strcmp(pChar, FileName) )
			{
				sprintf( str, "Deleted file ---> [%s]\n", FileName );
				LOG( str );
				
				//
				//  Delete file here..
				//	

				DWORD uRes;
				hDSK = CreateFile( PackedFile, GENERIC_WRITE, FILE_SHARE_READ, 0, OPEN_EXISTING, 0, 0 );
				WriteFile( hDSK, "DELETED", strlen("DELETED"), &uRes, NULL );
				SetEndOfFile( hDSK );
				CloseHandle( hDSK );
				
				//
				//
				//

				nFilesDeleted++;
					
				if( !ProcessDataProc( FileName, -1*nFilesDeleted*100/nFilesToDelete ) )
				{
					bSkip = true;
				}

				break;
			}
		}
	}

	CloseArchive( (HANDLE)pDD );

	return 0;
};


BOOL __stdcall CanYouHandleThisFile( char* FileName )
{
char str[512];
sprintf( str, "CanYouHandleThisFile --[%s]\n", FileName );
LOG( str );

	if( !FileName )
        return FALSE;

    return FALSE;
}

int __stdcall GetPackerCaps()
{
	LOG( "--- GetPackerCaps ---\n" );
	return PK_CAPS_NEW | PK_CAPS_MODIFY | PK_CAPS_MULTIPLE | PK_CAPS_DELETE | PK_CAPS_BY_CONTENT;
}

