#include "stdafx.h"
#include "vm1g_plm.h"

#include "defmacros.h"


vm1g_plm::vm1g_plm()
{
}


vm1g_plm::~vm1g_plm()
{
}

/*
    .     0
 1  0   1,
*/
const DWORD vm1g_plm::ignore_bits[250] = {
	BIN32(00000000, 00000000, 11111111, 11110000), //       
	BIN32(00011110, 00111000, 01010000, 00110111),
	BIN32(00000111, 11111000, 01010000, 00011111),
	BIN32(11110111, 00000000, 01110000, 00011111),
	BIN32(00000000, 00000111, 00000000, 01111110),
	BIN32(10000111, 00000000, 00000111, 01110111),
	BIN32(00000000, 00111111, 01110000, 01110111),
	BIN32(10010111, 00000000, 00000101, 01011110),
	BIN32(00000001, 11000000, 00000000, 00111011),
	BIN32(01110000, 00000000, 01000000, 01101110),
	BIN32(00000111, 00000000, 00000100, 01111111),
	BIN32(10000011, 10000000, 00010000, 00011111),
	BIN32(10000111, 00000000, 00000111, 01110111),
	BIN32(11111111, 11111000, 01110000, 00011111),
	BIN32(00000100, 00000000, 00000010, 01111000),
	BIN32(00000000, 00111000, 00000000, 01101101),
	BIN32(01111111, 11000000, 01110000, 00011111),
	BIN32(11111110, 00111000, 01110000, 00011111),
	BIN32(00000000, 00110000, 00000000, 00011111),
	BIN32(00000000, 00000000, 00000000, 01011101),
	BIN32(01110000, 00000000, 01000000, 01101110),
	BIN32(11111110, 00000000, 01010000, 01001111),
	BIN32(00000011, 11000000, 01000000, 01110110),
	BIN32(10010111, 00000000, 00000100, 01011110),
	BIN32(10000111, 00000000, 00000111, 01110111),
	BIN32(10000000, 00000000, 00000000, 01111110),
	BIN32(00000000, 00000110, 00000000, 00101110),
	BIN32(10000111, 00000000, 00000010, 01110111),
	BIN32(10000111, 00000000, 00000010, 11111110),
	BIN32(10000111, 00000000, 00000001, 01110111),
	BIN32(10000111, 00000000, 00000000, 11111110),
	BIN32(00000000, 00000100, 00000000, 01011111),
	BIN32(10000111, 00000000, 00000101, 01111110),
	BIN32(00000000, 00000111, 00000000, 01100110),
	BIN32(11110000, 00000000, 01000000, 01101110),
	BIN32(10000101, 00000000, 00000101, 01111110),
	BIN32(10000111, 00000000, 00000001, 01111110),
	BIN32(11111111, 11111111, 01110000, 00011111),
	BIN32(10000000, 00000000, 00000100, 01001111),
	BIN32(00000000, 00000000, 00000110, 01111011),
	BIN32(10000101, 11000000, 01000100, 01110110),
	BIN32(00000000, 00000000, 00000100, 01011111),
	BIN32(00000000, 00000000, 00000000, 01101110),
	BIN32(10000011, 00000000, 00000000, 11110111),
	BIN32(00000001, 00000000, 00001000, 01111111),
	BIN32(11111110, 00000000, 01110000, 00011111),
	BIN32(00000001, 00000000, 00000000, 01011101),
	BIN32(00001110, 00000000, 00000000, 01110111),
	BIN32(00000000, 00000000, 00000001, 01101111),
	BIN32(10010011, 00000000, 00000101, 01011111),
	BIN32(10000111, 00000000, 00000010, 01111110),
	BIN32(00000101, 10000000, 01000000, 01110110),
	BIN32(00000111, 00000000, 00000010, 01111110),
	BIN32(11111111, 10111000, 01110000, 01110111),
	BIN32(01111110, 00000000, 01110000, 00011111),
	BIN32(00000011, 11000000, 01000000, 01110110),
	BIN32(00000101, 01000000, 01000000, 01110110),
	BIN32(10000000, 00000000, 00010000, 01101110),
	BIN32(00000000, 00000000, 00000000, 01111011),
	BIN32(00000000, 00111000, 00000000, 01100111),
	BIN32(01111110, 00111000, 01110000, 01110111),
	BIN32(00000000, 00000000, 00000100, 01111111),
	BIN32(00000000, 10000000, 00000000, 01011101),
	BIN32(00000000, 00100000, 00000000, 00111111),
	BIN32(11111110, 00000000, 01110000, 01110111),
	BIN32(00000001, 01000000, 00000000, 01111011),
	BIN32(10001110, 00000000, 01000000, 01110111),
	BIN32(11111110, 00111000, 01110000, 01110111),
	BIN32(10000011, 11000000, 01010000, 01110111),
	BIN32(10001000, 10000000, 01000000, 01111111),
	BIN32(00000000, 01000000, 00000000, 01011101),
	BIN32(00000000, 00000000, 00000000, 01111101),
	BIN32(00000000, 00000000, 00000000, 01111011),
	BIN32(00000000, 00100000, 01000010, 00011111),
	BIN32(00000000, 00000000, 00000000, 01110111),
	BIN32(00000001, 01000000, 00000000, 01111011),
	BIN32(00000000, 00000000, 01110000, 01111111),
	BIN32(10000000, 00000000, 00000000, 01100100),
	BIN32(11111111, 00000000, 01110000, 00011111),
	BIN32(00000000, 00000000, 00000000, 01011101),
	BIN32(11111111, 11111111, 01110000, 00011111),
	BIN32(00000000, 00111000, 00000000, 01111011),
	BIN32(01110000, 00000000, 01000000, 01101110),
	BIN32(11111111, 01111000, 01110000, 00011111),
	BIN32(00000100, 00000000, 00000000, 01111111),
	BIN32(10000000, 01000000, 00000000, 01001111),
	BIN32(00000000, 00000000, 00000000, 11111111),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(10000011, 01000000, 01010000, 01110111),
	BIN32(01111111, 00111000, 01110000, 00011111),
	BIN32(11111000, 00000000, 01000000, 01101110),
	BIN32(11111111, 00111000, 01110000, 00011111),
	BIN32(00000000, 00000000, 00000000, 01011111),
	BIN32(11111110, 00011000, 01110000, 01011111),
	BIN32(00000000, 00000000, 00010000, 01100100),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00010010, 00000000, 00000000, 01111000),
	BIN32(00000011, 11000000, 01000000, 01111110),
	BIN32(11111010, 00000000, 01110000, 01011111),
	BIN32(00000000, 00110000, 00000000, 01110111),
	BIN32(01100000, 00000000, 00000000, 00111110),
	BIN32(00000100, 00000000, 00000000, 01111001),
	BIN32(00001100, 00000000, 00000000, 01110011),
	BIN32(01100000, 00000000, 01000000, 01110111),
	BIN32(00000000, 00000000, 01100000, 01110111),
	BIN32(00000000, 00000000, 00000110, 01111111),
	BIN32(00000000, 00000000, 00000000, 01011111),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00001110, 00000000, 00000000, 01110111),
	BIN32(00000000, 01000000, 00000000, 00011110),
	BIN32(00000000, 00000000, 01100000, 01110111),
	BIN32(00001110, 00000000, 00000000, 01110111),
	BIN32(00000000, 00001100, 00001000, 00111111),
	BIN32(00000000, 00100000, 00000000, 00011111),
	BIN32(00000000, 00010000, 00000000, 01110110),
	BIN32(00000000, 10000000, 00000000, 01111111),
	BIN32(00000000, 00100000, 01000010, 00111111),
	BIN32(00000000, 00000000, 00000000, 01111101),
	BIN32(00000000, 00000000, 00000000, 01111101),
	BIN32(11111000, 00000000, 00000000, 01110111),
	BIN32(01110000, 00000000, 00000000, 01110110),
	BIN32(10000110, 00000000, 01000000, 01111111),
	BIN32(00000011, 11000000, 01000000, 01111110),
	BIN32(10000000, 01000000, 00000000, 01101111),
	BIN32(00000000, 00000000, 00000000, 01101111),
	BIN32(01111110, 00111000, 01110000, 01011011),
	BIN32(00000000, 00001000, 00000000, 00111111),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00000011, 11000000, 01000000, 01111110),
	BIN32(01100000, 00000000, 01000000, 01101110),
	BIN32(00000000, 00000000, 00010000, 01111111),
	BIN32(00000000, 00000001, 00000000, 01100010),
	BIN32(00000000, 00000000, 00000000, 01110111),
	BIN32(00000011, 11000000, 01000000, 01111110),
	BIN32(00000001, 00000000, 00000000, 00011110),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00000000, 10000000, 00000000, 00011010),
	BIN32(11100000, 00000000, 00000000, 01111110),
	BIN32(00000100, 00000000, 00000000, 01110111),
	BIN32(00000000, 00000000, 00000000, 11111111),
	BIN32(00000000, 00000100, 00000000, 01100010),
	BIN32(00000000, 00000010, 00000000, 01100010),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00000001, 00000000, 00000000, 01110110),
	BIN32(00001100, 00000000, 00000000, 01110111),
	BIN32(10000000, 00000000, 00000000, 00011000),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00000100, 00000000, 00001000, 01101111),
	BIN32(10000000, 00000000, 00000000, 01011111),
	BIN32(00000101, 01000000, 01000000, 01111110),
	BIN32(00000000, 00000000, 00000000, 01101111),
	BIN32(00110000, 00000000, 01000000, 01101110),
	BIN32(00000000, 00000000, 01100000, 01110111),
	BIN32(00000011, 10000000, 01000000, 01111110),
	BIN32(11100000, 00000000, 00000000, 01111110),
	BIN32(00000000, 00000000, 00000000, 01111110),
	BIN32(00000000, 00000000, 00000100, 01111011),
	BIN32(11111111, 01000000, 01110000, 01110111),
	BIN32(00000011, 10000000, 01000000, 01111110),
	BIN32(11111111, 11111000, 01110000, 01011111),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(11111111, 11111000, 01110000, 01011111),
	BIN32(00000101, 00000000, 01000000, 01111110),
	BIN32(00000000, 00000000, 01000000, 01111111),
	BIN32(00000000, 00000000, 00000000, 01110111),
	BIN32(00001000, 00000000, 00000000, 01110111),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00000000, 00000000, 00000000, 01111110),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00000000, 00000000, 00000000, 01101111),
	BIN32(00000000, 00000000, 00100000, 01111110),
	BIN32(00000010, 00000000, 00000000, 01111011),
	BIN32(00000000, 00001000, 00000000, 00111111),
	BIN32(00000000, 00111000, 00000000, 01110111),
	BIN32(00000000, 00000000, 00000000, 01111011),
	BIN32(00000000, 00000000, 00000000, 01101111),
	BIN32(11111111, 11100000, 01110000, 01110111),
	BIN32(00110000, 00000000, 00000000, 01110110),
	BIN32(11111111, 11111111, 01110000, 01011111),
	BIN32(00000000, 00100000, 00000000, 00111011),
	BIN32(00000000, 00000000, 00000000, 01110110),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(01111010, 00000000, 01110000, 01011111),
	BIN32(00000000, 00000000, 00010000, 01111111),
	BIN32(00000000, 00000000, 00100000, 01110110),
	BIN32(11111111, 11111011, 01110000, 01110111),
	BIN32(00000000, 00000000, 00000000, 01111110),
	BIN32(00001110, 00000000, 00000000, 01110111),
	BIN32(11111111, 11111111, 01110000, 01011111),
	BIN32(00000000, 00000000, 00000000, 01011111),
	BIN32(00000000, 00000000, 00000010, 01111111),
	BIN32(11111110, 00001000, 01110000, 01011111),
	BIN32(00000000, 00110000, 00000000, 01110111),
	BIN32(00000000, 00001000, 00001000, 01111111),
	BIN32(00000000, 00101000, 00000000, 01111111),
	BIN32(11111111, 11111111, 01110000, 01110111),
	BIN32(00010000, 00000000, 00000000, 01110110),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00000000, 00000000, 00000000, 01011111),
	BIN32(01101110, 00111000, 01110000, 01011111),
	BIN32(00000000, 00000000, 00000000, 00111111),
	BIN32(00000010, 00000000, 00000000, 01101100),
	BIN32(01111110, 00111000, 01110000, 01011111),
	BIN32(00001110, 00000000, 00000000, 01110111),
	BIN32(00000000, 00000000, 00000000, 01111011),
	BIN32(01101110, 00111000, 01110000, 01011111),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00000000, 00001000, 00000000, 00111111),
	BIN32(00000000, 00000000, 00000010, 01111111),
	BIN32(00000000, 00000000, 00000000, 01101111),
	BIN32(00000000, 00000000, 00000000, 01111110),
	BIN32(00000000, 00000000, 00000100, 01111111),
	BIN32(11111111, 11000000, 01110000, 01011111),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(10010000, 00000000, 00000000, 00111111),
	BIN32(00001110, 00000000, 00000000, 01110111),
	BIN32(00000010, 00000000, 00000000, 01111111),
	BIN32(11111110, 00000000, 01110000, 01011111),
	BIN32(00000000, 00000000, 00000000, 01111111),
	BIN32(00000000, 00000000, 00000110, 01111100),
	BIN32(00000000, 00000000, 00000000, 11111111),
	BIN32(00000000, 00000000, 00000000, 01101111),
	BIN32(00000000, 00000000, 00100000, 01111110),
	BIN32(00000000, 00000000, 00000000, 11111111),
	BIN32(00000000, 00000000, 00000000, 01100111),
	BIN32(00000000, 00000000, 00000000, 01111011),
	BIN32(11111111, 11000000, 01110000, 01011111),
	BIN32(00000000, 00000000, 00000000, 00111111),
	BIN32(00000000, 00001100, 00001000, 00111111),
	BIN32(00000001, 00000000, 00000000, 01111111),
	BIN32(00010001, 10000000, 00000010, 00111111),
	BIN32(00000000, 00000000, 00000000, 01111110),
	BIN32(00000000, 00000000, 00000100, 01111001),
	BIN32(00010000, 00000000, 00000000, 01101111),
	BIN32(00000000, 00000000, 00000000, 01111011),
	BIN32(00000000, 00000000, 00000000, 01011011),
	BIN32(00000010, 00000000, 00000000, 00101011),
	BIN32(00000000, 00010000, 00000000, 01110110),
	BIN32(01111111, 00000000, 01110000, 01110111),
	BIN32(00000000, 00000000, 00000000, 01111110),
	BIN32(00000000, 00000000, 00000000, 01100110),
	BIN32(00000000, 00000000, 00000000, 01111101),
	BIN32(01110010, 11000000, 01110000, 01011111),
	BIN32(00000000, 00000000, 00000000, 01110100),
	BIN32(01111100, 00000000, 01110000, 01011111),
	BIN32(01110000, 00000000, 01110000, 01011011),
	BIN32(11111110, 00111000, 01110000, 01110111),
	BIN32(01110000, 00000000, 01110000, 01110111),
	BIN32(01100000, 00000000, 01110000, 01110111),
	BIN32(01100000, 00000000, 01110000, 01110111)
};
/*
  .     0
  -    
*/
const DWORD vm1g_plm::mask_bits[250] = {
	-1,
	BIN32(00010000, 00000000, 00010000, 00110110),
	BIN32(00000001, 11000000, 00010000, 00011110),
	BIN32(10000000, 00000000, 00010000, 00011110),
	BIN32(00000000, 00000111, 00000000, 01111010),
	BIN32(00000110, 00000000, 00000100, 01000110),
	BIN32(00000000, 00000111, 00010000, 01110110),
	BIN32(00000101, 00000000, 00000101, 01000110),
	BIN32(00000001, 11000000, 00000000, 00100011),
	BIN32(01000000, 00000000, 01000000, 00100110),
	BIN32(00000000, 00000000, 00000100, 01000110),
	BIN32(10000001, 10000000, 00010000, 00011000),
	BIN32(00000111, 00000000, 00000000, 01000110),
	BIN32(00000000, 01000000, 00010000, 00011110),
	BIN32(00000100, 00000000, 00000010, 01011000),
	BIN32(00000000, 00000000, 00000000, 01100001),
	BIN32(00001011, 11000000, 00010000, 00011110),
	BIN32(00001000, 00000000, 00010000, 00011110),
	BIN32(00000000, 00100000, 00000000, 00011011),
	BIN32(00000000, 00000000, 00000000, 01011001),
	BIN32(00100000, 00000000, 01000000, 00100110),
	BIN32(10001000, 00000000, 00010000, 01001110),
	BIN32(00000010, 10000000, 00000000, 00110110),
	BIN32(10000001, 00000000, 00000000, 01000110),
	BIN32(00000111, 00000000, 00000101, 01000110),
	BIN32(10000000, 00000000, 00000000, 01100110),
	BIN32(00000000, 00000110, 00000000, 00101010),
	BIN32(00000011, 00000000, 00000000, 01000110),
	BIN32(10000011, 00000000, 00000000, 01000110),
	BIN32(10000101, 00000000, 00000000, 01000110),
	BIN32(10000111, 00000000, 00000000, 01000110),
	BIN32(00000000, 00000100, 00000000, 01000111),
	BIN32(00000101, 00000000, 00000000, 01000110),
	BIN32(00000000, 00000111, 00000000, 00100110),
	BIN32(01100000, 00000000, 01000000, 00100110),
	BIN32(00000100, 00000000, 00000001, 01000110),
	BIN32(10000100, 00000000, 00000001, 01000110),
	BIN32(00000000, 00000101, 00010000, 00011110),
	BIN32(10000000, 00000000, 00000000, 00001110),
	BIN32(00000000, 00000000, 00000000, 00000000),
	BIN32(00000101, 11000000, 00000100, 00110110),
	BIN32(00000000, 00000000, 00000000, 00000010),
	BIN32(00000000, 00000000, 00000000, 01100000),
	BIN32(10000010, 00000000, 00000000, 11000110),
	BIN32(00000000, 00000000, 00000000, 01010101),
	BIN32(01111110, 00000000, 00010000, 00011110),
	BIN32(00000001, 00000000, 00000000, 00000101),
	BIN32(00000000, 00000000, 00000000, 00110000),
	BIN32(00000000, 00000000, 00000000, 00000100),
	BIN32(00000000, 00000000, 00000100, 01000110),
	BIN32(00000110, 00000000, 00000010, 01000110),
	BIN32(00000100, 10000000, 00000000, 00110110),
	BIN32(00000010, 00000000, 00000010, 01000110),
	BIN32(00000000, 10000000, 00010000, 01110110),
	BIN32(00001000, 00000000, 00010000, 00011110),
	BIN32(00000011, 01000000, 00000000, 00110110),
	BIN32(00000100, 01000000, 00000000, 00110110),
	BIN32(10000000, 00000000, 00010000, 00100110),
	BIN32(00000000, 00000000, 00000000, 00100010),
	BIN32(00000000, 00101000, 00000000, 00100010),
	BIN32(00001010, 00000000, 00010000, 01110110),
	BIN32(00000000, 00000000, 00000100, 00001001),
	BIN32(00000000, 10000000, 00000000, 00000101),
	BIN32(00000000, 00000000, 00000000, 00111101),
	BIN32(00000100, 00000000, 00010000, 01110110),
	BIN32(00000000, 01000000, 00000000, 00101011),
	BIN32(00001000, 00000000, 00000000, 00110111),
	BIN32(01111000, 00100000, 00010000, 01110110),
	BIN32(10000001, 11000000, 00010000, 00110111),
	BIN32(00000000, 10000000, 00000000, 00110111),
	BIN32(00000000, 01000000, 00000000, 00000101),
	BIN32(00000000, 00000000, 00000000, 00000100),
	BIN32(00000000, 00000000, 00000000, 01111011),
	BIN32(00000000, 00000000, 01000010, 00011011),
	BIN32(00000000, 00000000, 00000000, 01100000),
	BIN32(00000000, 00000000, 00000000, 00101011),
	BIN32(00000000, 00000000, 00000000, 01111110),
	BIN32(00000000, 00000000, 00000000, 00100000),
	BIN32(00000001, 00000000, 00010000, 00011110),
	BIN32(00000000, 00000000, 00000000, 00011101),
	BIN32(00000000, 00000000, 00010000, 00011110),
	BIN32(00000000, 00011000, 00000000, 00111010),
	BIN32(00110000, 00000000, 01000000, 00100110),
	BIN32(00001101, 01000000, 00010000, 00011110),
	BIN32(00000000, 00000000, 00000000, 00011001),
	BIN32(00000000, 01000000, 00000000, 00001110),
	BIN32(00000000, 00000000, 00000000, 00010110),
	BIN32(00000000, 00000000, 00000000, 01000010),
	BIN32(10000001, 00000000, 00010000, 00110111),
	BIN32(00001100, 00000000, 00010000, 00011110),
	BIN32(01111000, 00000000, 01000000, 00100110),
	BIN32(10001101, 00000000, 00010000, 00011110),
	BIN32(00000000, 00000000, 00000000, 01011101),
	BIN32(01111000, 00010000, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 00100000),
	BIN32(00000000, 00000000, 00000000, 00100101),
	BIN32(00010000, 00000000, 00000000, 01011000),
	BIN32(00000010, 00000000, 00000000, 00110110),
	BIN32(10000000, 00000000, 00010000, 01011110),
	BIN32(00000000, 00110000, 00000000, 00110010),
	BIN32(00100000, 00000000, 00000000, 00100110),
	BIN32(00000000, 00000000, 00000000, 00011000),
	BIN32(00001000, 00000000, 00000000, 01100011),
	BIN32(00000000, 00000000, 01000000, 00110111),
	BIN32(00000000, 00000000, 00100000, 01110110),
	BIN32(00000000, 00000000, 00000010, 00000011),
	BIN32(00000000, 00000000, 00000000, 01001101),
	BIN32(00000000, 00000000, 00000000, 00111100),
	BIN32(00001010, 00000000, 00000000, 00110000),
	BIN32(00000000, 01000000, 00000000, 00011000),
	BIN32(00000000, 00000000, 01000000, 01110110),
	BIN32(00000110, 00000000, 00000000, 00110000),
	BIN32(00000000, 00000000, 00001000, 00001110),
	BIN32(00000000, 00100000, 00000000, 00011101),
	BIN32(00000000, 00000000, 00000000, 00100010),
	BIN32(00000000, 00000000, 00000000, 00101111),
	BIN32(00000000, 00000000, 00000010, 00011011),
	BIN32(00000000, 00000000, 00000000, 01110000),
	BIN32(00000000, 00000000, 00000000, 00000101),
	BIN32(01110000, 00000000, 00000000, 00110111),
	BIN32(01010000, 00000000, 00000000, 00110010),
	BIN32(00000000, 00000000, 00000000, 00110111),
	BIN32(00000011, 11000000, 00000000, 00110110),
	BIN32(10000000, 01000000, 00000000, 00101111),
	BIN32(00000000, 00000000, 00000000, 01001000),
	BIN32(01100000, 00000000, 00010000, 01011010),
	BIN32(00000000, 00001000, 00000000, 00111011),
	BIN32(00000000, 00000000, 00000000, 00111110),
	BIN32(00000010, 01000000, 00000000, 00110110),
	BIN32(01000000, 00000000, 01000000, 00100110),
	BIN32(00000000, 00000000, 00010000, 01001111),
	BIN32(00000000, 00000001, 00000000, 00100010),
	BIN32(00000000, 00000000, 00000000, 01110000),
	BIN32(00000011, 10000000, 00000000, 00110110),
	BIN32(00000001, 00000000, 00000000, 00011000),
	BIN32(00000000, 00000000, 00000000, 01101110),
	BIN32(00000000, 10000000, 00000000, 00011000),
	BIN32(00000000, 00000000, 00000000, 00100110),
	BIN32(00000100, 00000000, 00000000, 01100111),
	BIN32(00000000, 00000000, 00000000, 10001010),
	BIN32(00000000, 00000100, 00000000, 00100010),
	BIN32(00000000, 00000010, 00000000, 00100010),
	BIN32(00000000, 00000000, 00000000, 00010000),
	BIN32(00000001, 00000000, 00000000, 01010100),
	BIN32(00001100, 00000000, 00000000, 00110000),
	BIN32(00000000, 00000000, 00000000, 00011000),
	BIN32(00000000, 00000000, 00000000, 01101100),
	BIN32(00000000, 00000000, 00000000, 00001110),
	BIN32(10000000, 00000000, 00000000, 00001110),
	BIN32(00000101, 01000000, 00000000, 00110110),
	BIN32(00000000, 00000000, 00000000, 01001011),
	BIN32(00100000, 00000000, 01000000, 00100110),
	BIN32(00000000, 00000000, 01100000, 01110110),
	BIN32(00000010, 10000000, 00000000, 00110110),
	BIN32(10000000, 00000000, 00000000, 00100110),
	BIN32(00000000, 00000000, 00000000, 01111100),
	BIN32(00000000, 00000000, 00000100, 00000000),
	BIN32(00001101, 00000000, 00010000, 01110110),
	BIN32(00000011, 00000000, 00000000, 00110110),
	BIN32(00000000, 00001000, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 00010011),
	BIN32(00000000, 11000000, 00010000, 01011110),
	BIN32(00000100, 00000000, 00000000, 00110110),
	BIN32(00000000, 00000000, 01000000, 00110111),
	BIN32(00000000, 00000000, 00000000, 01000100),
	BIN32(00000000, 00000000, 00000000, 01100111),
	BIN32(00000000, 00000000, 00000000, 00001000),
	BIN32(00000000, 00000000, 00000000, 01101000),
	BIN32(00000000, 00000000, 00000000, 00110111),
	BIN32(00000000, 00000000, 00000000, 00001001),
	BIN32(00000000, 00000000, 00000000, 01100010),
	BIN32(00000010, 00000000, 00000000, 00111001),
	BIN32(00000000, 00001000, 00000000, 00001110),
	BIN32(00000000, 00100000, 00000000, 00110010),
	BIN32(00000000, 00000000, 00000000, 01000000),
	BIN32(00000000, 00000000, 00000000, 01100110),
	BIN32(00000000, 10100000, 00010000, 01110110),
	BIN32(00110000, 00000000, 00000000, 00110010),
	BIN32(00000000, 00000011, 00010000, 01011110),
	BIN32(00000000, 00100000, 00000000, 00011011),
	BIN32(00000000, 00000000, 00000000, 01010000),
	BIN32(00000000, 00000000, 00000000, 01101010),
	BIN32(00000010, 00000000, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 01001111),
	BIN32(00000000, 00000000, 00000000, 00110010),
	BIN32(00000000, 00000010, 00010000, 01110110),
	BIN32(00000000, 00000000, 00000000, 00011100),
	BIN32(00000010, 00000000, 00000000, 00110000),
	BIN32(00000000, 00000100, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 01000011),
	BIN32(00000000, 00000000, 00000000, 00000001),
	BIN32(01111000, 00001000, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 00110010),
	BIN32(00000000, 00000000, 00000000, 01001110),
	BIN32(00000000, 00000000, 00000000, 00111010),
	BIN32(00000000, 00000001, 00010000, 01110110),
	BIN32(00000000, 00000000, 00000000, 00110010),
	BIN32(00000000, 00000000, 00000000, 00010001),
	BIN32(00000000, 00000000, 00000000, 01000111),
	BIN32(00100000, 00000000, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 00110011),
	BIN32(00000010, 00000000, 00000000, 00001000),
	BIN32(00010000, 00000000, 00010000, 01011110),
	BIN32(00001000, 00000000, 00000000, 00110000),
	BIN32(00000000, 00000000, 00000000, 00000010),
	BIN32(01000000, 00000000, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 00001011),
	BIN32(00000000, 00000000, 00000000, 00111011),
	BIN32(00000000, 00000000, 00000010, 00000001),
	BIN32(00000000, 00000000, 00000000, 01000100),
	BIN32(00000000, 00000000, 00000000, 00110000),
	BIN32(00000000, 00000000, 00000100, 00000011),
	BIN32(10001101, 00000000, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 00010010),
	BIN32(00000000, 00000000, 00000000, 00011010),
	BIN32(00000100, 00000000, 00000000, 00110000),
	BIN32(00000000, 00000000, 00000000, 00111001),
	BIN32(01110000, 00000000, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 01001010),
	BIN32(00000000, 00000000, 00000000, 00000000),
	BIN32(00000000, 00000000, 00000000, 00001010),
	BIN32(00000000, 00000000, 00000000, 00000100),
	BIN32(00000000, 00000000, 00100000, 01100010),
	BIN32(00000000, 00000000, 00000000, 10010110),
	BIN32(00000000, 00000000, 00000000, 01100011),
	BIN32(00000000, 00000000, 00000000, 01011011),
	BIN32(00000000, 01000000, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 00011110),
	BIN32(00000000, 00000100, 00001000, 00001110),
	BIN32(00000000, 00000000, 00000000, 01010101),
	BIN32(00000000, 00000000, 00000000, 00011011),
	BIN32(00000000, 00000000, 00000000, 01110000),
	BIN32(00000000, 00000000, 00000000, 00000000),
	BIN32(00000000, 00000000, 00000000, 00001010),
	BIN32(00000000, 00000000, 00000000, 01011000),
	BIN32(00000000, 00000000, 00000000, 01011001),
	BIN32(00000010, 00000000, 00000000, 00001010),
	BIN32(00000000, 00010000, 00000000, 00100010),
	BIN32(00001100, 00000000, 00010000, 01110110),
	BIN32(00000000, 00000000, 00000000, 01111010),
	BIN32(00000000, 00000000, 00000000, 00100110),
	BIN32(00000000, 00000000, 00000000, 01000100),
	BIN32(00000000, 11000000, 00010000, 01011110),
	BIN32(00000000, 00000000, 00000000, 00110000),
	BIN32(00001000, 00000000, 00010000, 01011110),
	BIN32(01100000, 00000000, 00010000, 01011010),
	BIN32(01111000, 00000000, 00010000, 01110110),
	BIN32(00010000, 00000000, 00010000, 01110110),
	BIN32(01000000, 00000000, 00010000, 01110110),
	BIN32(00100000, 00000000, 00010000, 01110110)
};
//______________________________________________________________________________
//
// Main matrix inputs format:
//
//    ir[15:0] - instruction code latched in instrustion register (opcode)
//    mr[14:0] - microinstruction state word also latched
//       mr[6:0] - address/state field, controlled by PLM outputs
//          sp[0]  -> mr[6]
//          sp[5]  -> mr[5]
//          sp[9]  -> mr[4]
//          sp[15] -> mr[3]
//          sp[19] -> mr[2]
//          sp[24] -> mr[1]
//          spl29] -> mr[0] + reset
//
//       mr[7]  - psw[0] - C (carry) flag or condition
//       mr[8]  - psw[1] - V (overflow) flag or condition)
//       mr[9]  - psw[2] - Z (zero) flag or condition
//       mr[10] - psw[3] - N (negative) flag or condition
//       mr[11] - psw[4] - T (trap) flag
//
//       mr[14:12] - multiplexed
//       priority encoder branch:
//          mr[12]   - sp[9] priority encoder
//          mr[13]   - sp[7] priority encoder
//          mr[14]   - sp[5] priority encoder
//       feedback from main matrix
//          mr[12]   - ~plr17
//          mr[13]   -  plr16
//          mr[14]   - ~plr14
//
// Main matrix outputs format (after SOP inversion):
//      plx[0]   ~mj[6]   - next microcode address
//      plx[5]    mj[5]
//      plx[9]    mj[4]
//      plx[15]   mj[3]
//      plx[19]  ~mj[2]
//      plx[24]  ~mj[1]
//      plx[29]  ~mj[0]
//
//      plx[1]  IR register operation
//      plx[2]  
//      plx[3]              irq_check   wait_IR     start_IR    Note
//                      000 no          no          no          no operation
//                      001 no          yes         no          RTT opcode, wait fetch completion
//                      010 no          no          no          non-IR data retrieving
//                      011 yes         yes         yes         usual IR fetch
//                      100 no          no          yes         early IR prefetch       
//                      101 yes         no          no          WAIT opcode, check irq only
//                      110 no          no          no          no operation
//                      111 yes         yes         no          ~RTT opcode, wait fetch completion
//                                                                  
//      plx[6]  QBUS operation type: byte operation flag
//      plx[7]  QBUS operation type: write flag
//      plx[8]  QBUS operation type: read flag
//                      00x - nothing
//                      010 - write word
//                      011 - write byte
//                      100 - read word
//                      101 - read byte
//                      110 - read-modify-write word
//                      111 - read-modify-write byte
//
//      plx[10] not to wait data from Q-bus
//      plx[12]  opcode is not recognized
//      plx[11] Y bus operand type selector
//      plx[13] Y bus operand type selector/ALU operation
//      plx[14] Y bus operand type selector/ALU operation
//      plx[16] ALU opcode
//      plx[17] ALU opcode
//      plx[18] word operation (0 - byte operation)
//      plx[20] write ALU result flag to register
//      plx[4]  PSW and microcode control (plop)
//      plx[21]
//      plx[22]
//      plx[23] no wait areg free or write completion
//      plx[25] 
//      plx[26] 
//      plx[27] if (~plr[11] & ~plr[13]):   
//      plx[28]
//                      0000        - Q             1111    - R0
//                      0001        - R7            0111    - R1
//                      0010        - R11           1011    - R2
//                      0011        - R3            0011    - R3
//                      0100        - R13           1101    - R4
//                      0101        - R5            0101    - R5
//                      0110        - R9            1001    - R6
//                      0111        - R1            0001    - R7
//                      1000        - PSW           1110    - R8
//                      1001        - R6            0110    - R9
//                      1010        - R10           1010    - R10
//                      1011        - R2            0010    - R11
//                      1100        - R12           1100    - R12
//                      1101        - R4            0100    - R13
//                      1110        - R8            1000    - PSW
//                      1111        - R0            0000    - Q
//
//      plx[30] X selector, inverted and bit order reversed
//      plx[31]     
//      plx[32]         0000        - Q             1111    - R0
//      plx[33]         0001        - R7            0111    - R1
//                      0010        - R11           1011    - R2
//                      0011        - R3            0011    - R3
//                      0100        - R13           1101    - R4
//                      0101        - R5            0101    - R5
//                      0110        - R9            1001    - R6
//                      0111        - R1            0001    - R7
//                      1000        - PSW           1110    - R8
//                      1001        - R6            0110    - R9
//                      1010        - R10           1010    - R10
//                      1011        - R2            0010    - R11
//                      1100        - R12           1100    - R12
//                      1101        - R4            0100    - R13
//                      1110        - R8            1000    - PSW
//                      1111        - R0            0000    - Q
//
//      Instruction decoding phase - (plm[11] & plm[13])
//          plx[7]  - 0 - set wait mode
//          plx[10] - 0 - assert INIT
//          plx[12] - 1 - invalid opcode
//          plx[14] - inverted mj[14] input
//          plx[16] - direct   mj[13] input
//          plx[17] - inverted mj[12] input
//          plx[18] - vector selector
//          plx[20] - vector selector
//          plx[21] - vector selector
//          plx[22] - vector selector
//          plx[23] - 0 - deassert INIT
//          plx[25] - 0 - set stop mode
//          plx[26] - 0 - set error 2
//          plx[27] - 0 - reset wait mode/ack interrupt
//          plx[28] - 0 - set error 3
//          plx[30] - 0 - set error 7
//
//______________________________________________________________________________
//
void vm1g_plm::eval(WORD ir, WORD mr, BOOL *sp)
{
	//assign
	DWORD ai = (((DWORD)ir) << 16) | (((DWORD)mr) & 077777);
	for (int i = 1; i < 250; ++i)
	{
		p[i] = cmp(ai, mask_bits[i], ignore_bits[i]);
	}

	pl[0]  = p[246] || p[241] || p[236] || p[234] || p[233] || p[232] || p[228] || p[227] || p[225] || p[224]
                    || p[222] || p[219] || p[218] || p[216] || p[215] || p[213] || p[210] || p[209] || p[205] || p[204]
                    || p[203] || p[202] || p[201] || p[199] || p[198] || p[193] || p[190] || p[189] || p[188] || p[187]
                    || p[185] || p[182] || p[180] || p[179] || p[178] || p[175] || p[174] || p[172] || p[170] || p[169]
                    || p[168] || p[167] || p[165] || p[164] || p[162] || p[160] || p[159] || p[158] || p[156] || p[153]
                    || p[152] || p[151] || p[150] || p[149] || p[148] || p[147] || p[143] || p[137] || p[135] || p[133]
                    || p[132] || p[129] || p[128] || p[127] || p[124] || p[122] || p[119] || p[117] || p[116] || p[115]
                    || p[112] || p[110] || p[106] || p[104] || p[98]  || p[97]  || p[92]  || p[90]  || p[85]  || p[82]
                    || p[80]  || p[78]  || p[76]  || p[75]  || p[74]  || p[73]  || p[72]  || p[64]  || p[63]  || p[44]
                    || p[37]  || p[21]  || p[17]  || p[15]  || p[13];

	pl[1]  = p[249] || p[248] || p[247] || p[246] || p[245] || p[244] || p[243] || p[242] || p[241] || p[239]
                    || p[238] || p[237] || p[236] || p[235] || p[234] || p[233] || p[232] || p[231] || p[230] || p[229]
                    || p[228] || p[227] || p[226] || p[225] || p[224] || p[223] || p[222] || p[221] || p[220] || p[219]
                    || p[217] || p[214] || p[213] || p[212] || p[211] || p[209] || p[208] || p[206] || p[204] || p[201]
                    || p[198] || p[197] || p[195] || p[191] || p[190] || p[189] || p[188] || p[186] || p[185] || p[183]
                    || p[182] || p[181] || p[180] || p[178] || p[176] || p[175] || p[174] || p[172] || p[170] || p[169]
                    || p[168] || p[167] || p[166] || p[165] || p[164] || p[160] || p[159] || p[157] || p[156] || p[155]
                    || p[154] || p[152] || p[150] || p[147] || p[146] || p[143] || p[142] || p[139] || p[138] || p[136]
                    || p[132] || p[130] || p[127] || p[124] || p[123] || p[119] || p[118] || p[117] || p[116] || p[115]
                    || p[114] || p[112] || p[110] || p[107] || p[106] || p[105] || p[104] || p[102] || p[101] || p[98]
                    || p[96]  || p[95]  || p[93]  || p[87]  || p[86]  || p[80]  || p[79]  || p[78]  || p[75]  || p[74]
                    || p[73]  || p[67]  || p[65]  || p[64]  || p[53]  || p[45]  || p[37]  || p[33]  || p[8];

	pl[2]  = p[246] || p[239] || p[228] || p[218] || p[205] || p[202] || p[199] || p[176] || p[172] || p[161]
                    || p[125] || p[91]  || p[89]  || p[83]  || p[76]  || p[72]  || p[60];

	pl[3]  = p[225] || p[224] || p[218] || p[216] || p[215] || p[213] || p[210] || p[203] || p[196] || p[193]
                    || p[189] || p[187] || p[185] || p[181] || p[177] || p[174] || p[171] || p[160] || p[152] || p[144]
                    || p[135] || p[126] || p[120] || p[111] || p[108] || p[104] || p[99]  || p[81]  || p[59];

	pl[4]  = p[230] || p[229] || p[223] || p[221] || p[220] || p[214] || p[211] || p[208] || p[206] || p[201]
                    || p[166] || p[165] || p[162] || p[158] || p[156] || p[154] || p[151] || p[139] || p[133] || p[132]
                    || p[128] || p[123] || p[122] || p[105] || p[97]  || p[86]  || p[85]  || p[39];

	pl[5]  = p[246] || p[235] || p[230] || p[229] || p[228] || p[225] || p[224] || p[223] || p[222] || p[221]
                    || p[220] || p[214] || p[211] || p[209] || p[208] || p[206] || p[205] || p[202] || p[201] || p[199]
                    || p[197] || p[189] || p[186] || p[185] || p[183] || p[182] || p[174] || p[172] || p[170] || p[166]
                    || p[164] || p[160] || p[159] || p[157] || p[155] || p[146] || p[142] || p[139] || p[138] || p[130]
                    || p[124] || p[119] || p[116] || p[113] || p[110] || p[106] || p[105] || p[104] || p[102] || p[101]
                    || p[98]  || p[96]  || p[86]  || p[78]  || p[64]  || p[45]  || p[37]  || p[31]  || p[1];

	pl[6]  = p[249] || p[248] || p[247] || p[246] || p[245] || p[244] || p[242] || p[241] || p[240] || p[239]
                    || p[238] || p[237] || p[236] || p[235] || p[234] || p[233] || p[232] || p[231] || p[230] || p[229]
                    || p[228] || p[227] || p[226] || p[225] || p[224] || p[223] || p[222] || p[221] || p[220] || p[219]
                    || p[218] || p[217] || p[214] || p[213] || p[212] || p[211] || p[209] || p[208] || p[206] || p[204]
                    || p[201] || p[198] || p[197] || p[195] || p[193] || p[191] || p[190] || p[189] || p[188] || p[186]
                    || p[185] || p[183] || p[182] || p[181] || p[180] || p[179] || p[178] || p[176] || p[175] || p[174]
                    || p[172] || p[171] || p[170] || p[169] || p[167] || p[166] || p[165] || p[164] || p[160] || p[159]
                    || p[157] || p[156] || p[155] || p[152] || p[150] || p[147] || p[146] || p[145] || p[144] || p[143]
                    || p[142] || p[139] || p[138] || p[135] || p[130] || p[126] || p[124] || p[118] || p[117] || p[114]
                    || p[112] || p[111] || p[110] || p[108] || p[107] || p[106] || p[105] || p[104] || p[102] || p[99]
                    || p[98]  || p[95]  || p[94]  || p[87]  || p[86]  || p[81]  || p[77]  || p[76]  || p[74]  || p[72]
                    || p[59]  || p[47];

	pl[7]  = p[246] || p[241] || p[240] || p[239] || p[237] || p[236] || p[235] || p[234] || p[233] || p[232]
                    || p[231] || p[230] || p[229] || p[228] || p[227] || p[225] || p[224] || p[223] || p[221] || p[220]
                    || p[219] || p[216] || p[215] || p[214] || p[213] || p[211] || p[210] || p[209] || p[208] || p[206]
                    || p[205] || p[204] || p[203] || p[202] || p[201] || p[199] || p[198] || p[197] || p[195] || p[193]
                    || p[190] || p[189] || p[187] || p[186] || p[185] || p[184] || p[183] || p[181] || p[180] || p[179]
                    || p[176] || p[175] || p[172] || p[171] || p[167] || p[166] || p[165] || p[164] || p[161] || p[160]
                    || p[159] || p[157] || p[156] || p[155] || p[152] || p[150] || p[146] || p[144] || p[143] || p[142]
                    || p[139] || p[138] || p[135] || p[132] || p[130] || p[126] || p[125] || p[118] || p[117] || p[114]
                    || p[113] || p[111] || p[108] || p[106] || p[105] || p[101] || p[99]  || p[96]  || p[95]  || p[91]
                    || p[89]  || p[86]  || p[84]  || p[83]  || p[81]  || p[79]  || p[61]  || p[60]  || p[59]  || p[47];
//
// Auxilliary selectable inversion at the matrix output buffer (VM1G revision)
//
	pl[8] = !(p[249] || p[248] || p[247] || p[246] || p[245] || p[244] || p[242] || p[239] || p[238] || p[228]
                     || p[225] || p[224] || p[216] || p[215] || p[213] || p[212] || p[210] || p[203] || p[196] || p[193]
                     || p[189] || p[187] || p[185] || p[181] || p[177] || p[176] || p[174] || p[172] || p[171] || p[160]
                     || p[152] || p[144] || p[135] || p[126] || p[120] || p[111] || p[108] || p[104] || p[99]  || p[81]
                     || p[59]);

	pl[9]  = p[246] || p[241] || p[239] || p[236] || p[234] || p[233] || p[232] || p[229] || p[228] || p[227]
                    || p[222] || p[221] || p[219] || p[217] || p[213] || p[211] || p[209] || p[208] || p[205] || p[204]
                    || p[202] || p[199] || p[198] || p[197] || p[194] || p[191] || p[190] || p[182] || p[180] || p[175]
                    || p[174] || p[173] || p[172] || p[170] || p[168] || p[167] || p[166] || p[165] || p[164] || p[161]
                    || p[159] || p[156] || p[154] || p[150] || p[146] || p[143] || p[139] || p[127] || p[124] || p[123]
                    || p[119] || p[117] || p[115] || p[110] || p[107] || p[105] || p[104] || p[98]  || p[93]  || p[91]
                    || p[87]  || p[86]  || p[84]  || p[78]  || p[75]  || p[73]  || p[67]  || p[65]  || p[64]  || p[53]
                    || p[47]  || p[33]  || p[19]  || p[8];

	pl[10] = p[234] || p[231] || p[229] || p[216] || p[213] || p[210] || p[209] || p[207] || p[200] || p[198]
                    || p[180] || p[171] || p[168] || p[164] || p[155] || p[143] || p[127] || p[126] || p[117] || p[92]
                    || p[37];

	pl[11] = p[246] || p[239] || p[235] || p[234] || p[233] || p[231] || p[229] || p[228] || p[227] || p[224]
                    || p[223] || p[221] || p[220] || p[218] || p[216] || p[215] || p[213] || p[210] || p[209] || p[208]
                    || p[207] || p[206] || p[205] || p[202] || p[200] || p[199] || p[194] || p[193] || p[192] || p[187]
                    || p[186] || p[185] || p[181] || p[180] || p[179] || p[176] || p[175] || p[172] || p[171] || p[167]
                    || p[166] || p[165] || p[163] || p[162] || p[161] || p[155] || p[154] || p[151] || p[150] || p[146]
                    || p[144] || p[143] || p[139] || p[137] || p[135] || p[132] || p[130] || p[129] || p[127] || p[126]
                    || p[125] || p[123] || p[121] || p[119] || p[118] || p[114] || p[111] || p[105] || p[99]  || p[96] 
                    || p[95]  || p[91]  || p[90]  || p[89]  || p[86]  || p[84]  || p[83]  || p[82]  || p[81]  || p[68] 
                    || p[65]  || p[61]  || p[60]  || p[47];

	pl[12] = p[249] || p[248] || p[247] || p[246] || p[245] || p[244] || p[243] || p[242] || p[241] || p[240]
                    || p[239] || p[238] || p[237] || p[236] || p[235] || p[234] || p[233] || p[232] || p[231] || p[230]
                    || p[229] || p[228] || p[227] || p[226] || p[225] || p[224] || p[223] || p[222] || p[221] || p[220]
                    || p[219] || p[218] || p[217] || p[214] || p[213] || p[212] || p[211] || p[209] || p[208] || p[206]
                    || p[204] || p[201] || p[198] || p[197] || p[195] || p[193] || p[191] || p[190] || p[189] || p[188]
                    || p[186] || p[185] || p[183] || p[182] || p[181] || p[180] || p[179] || p[178] || p[176] || p[175]
                    || p[174] || p[172] || p[170] || p[169] || p[167] || p[166] || p[165] || p[164] || p[160] || p[159]
                    || p[157] || p[156] || p[155] || p[152] || p[150] || p[147] || p[146] || p[143] || p[142] || p[139]
                    || p[138] || p[136] || p[135] || p[132] || p[130] || p[124] || p[118] || p[117] || p[116] || p[114]
                    || p[112] || p[110] || p[107] || p[106] || p[105] || p[104] || p[102] || p[101] || p[98]  || p[96]
                    || p[95]  || p[93]  || p[87]  || p[86]  || p[80]  || p[79]  || p[78]  || p[76]  || p[74]  || p[73] 
                    || p[72]  || p[67]  || p[64]  || p[53]  || p[45]  || p[37];

	pl[13] = p[241] || p[237] || p[236] || p[235] || p[234] || p[233] || p[232] || p[231] || p[230] || p[229]
                    || p[227] || p[225] || p[223] || p[222] || p[219] || p[218] || p[216] || p[214] || p[213] || p[211]
                    || p[210] || p[209] || p[207] || p[204] || p[203] || p[201] || p[200] || p[198] || p[197] || p[195]
                    || p[190] || p[189] || p[186] || p[183] || p[180] || p[179] || p[174] || p[173] || p[171] || p[170]
                    || p[167] || p[164] || p[160] || p[159] || p[158] || p[157] || p[156] || p[155] || p[154] || p[153]
                    || p[152] || p[151] || p[149] || p[148] || p[146] || p[143] || p[142] || p[138] || p[137] || p[133]
                    || p[132] || p[129] || p[128] || p[127] || p[126] || p[124] || p[123] || p[122] || p[118] || p[117]
                    || p[115] || p[113] || p[110] || p[108] || p[106] || p[104] || p[103] || p[102] || p[101] || p[97] 
                    || p[96]  || p[95]  || p[90]  || p[88]  || p[85]  || p[84]  || p[82]  || p[75]  || p[61]  || p[59];

	pl[14] = p[249] || p[248] || p[247] || p[246] || p[245] || p[243] || p[241] || p[239] || p[237] || p[236]
                    || p[235] || p[234] || p[231] || p[230] || p[229] || p[228] || p[227] || p[225] || p[224] || p[223]
                    || p[222] || p[218] || p[217] || p[214] || p[213] || p[211] || p[209] || p[201] || p[197] || p[195]
                    || p[193] || p[191] || p[189] || p[188] || p[186] || p[185] || p[183] || p[181] || p[180] || p[178]
                    || p[176] || p[174] || p[172] || p[170] || p[169] || p[167] || p[161] || p[160] || p[159] || p[158]
                    || p[157] || p[155] || p[154] || p[153] || p[152] || p[151] || p[150] || p[149] || p[147] || p[146]
                    || p[143] || p[142] || p[137] || p[135] || p[133] || p[132] || p[130] || p[127] || p[124] || p[123]
                    || p[119] || p[118] || p[116] || p[114] || p[113] || p[112] || p[110] || p[107] || p[106] || p[104]
                    || p[103] || p[102] || p[97]  || p[96]  || p[95]  || p[93]  || p[91]  || p[89]  || p[87]  || p[83]
                    || p[71] || p[67]  || p[60]  || p[39]  || p[21]  || p[17]  || p[13];

	pl[15] = p[246] || p[239] || p[237] || p[225] || p[224] || p[223] || p[220] || p[217] || p[216] || p[215]
                    || p[213] || p[211] || p[210] || p[209] || p[208] || p[207] || p[206] || p[205] || p[203] || p[202]
                    || p[200] || p[199] || p[192] || p[191] || p[187] || p[183] || p[182] || p[174] || p[171] || p[160]
                    || p[159] || p[155] || p[152] || p[150] || p[146] || p[142] || p[130] || p[126] || p[114] || p[111]
                    || p[108] || p[107] || p[105] || p[103] || p[98]  || p[96]  || p[93]  || p[89]  || p[87]  || p[83] 
                    || p[81]  || p[78]  || p[67]  || p[64]  || p[60]  || p[59]  || p[47]  || p[19];

	pl[16] = p[249] || p[246] || p[241] || p[239] || p[235] || p[234] || p[233] || p[232] || p[231] || p[229]
                    || p[228] || p[227] || p[226] || p[225] || p[224] || p[223] || p[221] || p[220] || p[219] || p[218]
                    || p[217] || p[216] || p[215] || p[214] || p[213] || p[212] || p[210] || p[209] || p[208] || p[207]
                    || p[206] || p[205] || p[204] || p[202] || p[200] || p[198] || p[197] || p[195] || p[194] || p[193]
                    || p[192] || p[190] || p[188] || p[187] || p[186] || p[185] || p[181] || p[180] || p[179] || p[178]
                    || p[176] || p[175] || p[174] || p[172] || p[171] || p[167] || p[166] || p[165] || p[164] || p[162]
                    || p[161] || p[160] || p[159] || p[157] || p[155] || p[154] || p[152] || p[150] || p[149] || p[148]
                    || p[147] || p[146] || p[144] || p[143] || p[142] || p[139] || p[137] || p[135] || p[132] || p[130]
                    || p[129] || p[127] || p[126] || p[125] || p[124] || p[123] || p[121] || p[119] || p[118] || p[115]
                    || p[114] || p[113] || p[112] || p[111] || p[107] || p[106] || p[105] || p[104] || p[103] || p[99]
                    || p[97]  || p[96]  || p[95]  || p[91]  || p[89]  || p[88]  || p[87]  || p[86]  || p[85]  || p[84]
                    || p[83]  || p[81]  || p[79]  || p[65]  || p[60]  || p[55]  || p[54]  || p[47]  || p[34]  || p[22]
                    || p[16];

	pl[17] = p[249] || p[248] || p[247] || p[246] || p[244] || p[242] || p[241] || p[239] || p[238] || p[228]
                    || p[226] || p[225] || p[224] || p[223] || p[217] || p[216] || p[215] || p[212] || p[207] || p[198]
                    || p[195] || p[194] || p[193] || p[191] || p[188] || p[185] || p[181] || p[178] || p[176] || p[172]
                    || p[171] || p[160] || p[158] || p[157] || p[156] || p[147] || p[144] || p[135] || p[128] || p[126]
                    || p[125] || p[115] || p[112] || p[111] || p[99]  || p[93]  || p[90]  || p[88]  || p[87]  || p[85]
                    || p[81]  || p[80]  || p[67]  || p[53]  || p[45]  || p[38]  || p[34]  || p[22]  || p[20]  || p[18]
                    || p[9];

	pl[18] = p[233] || p[226] || p[188] || p[178] || p[165] || p[147] || p[138] || p[123] || p[115] || p[112]
                    || p[88]  || p[85]  || p[68]  || p[57]  || p[25]  || p[17]  || p[3];

	pl[19] = p[241] || p[239] || p[237] || p[236] || p[233] || p[232] || p[229] || p[225] || p[224] || p[223]
                    || p[222] || p[220] || p[219] || p[218] || p[217] || p[207] || p[206] || p[204] || p[200] || p[198]
                    || p[195] || p[193] || p[192] || p[191] || p[190] || p[189] || p[188] || p[186] || p[185] || p[182]
                    || p[181] || p[180] || p[179] || p[178] || p[176] || p[175] || p[174] || p[170] || p[165] || p[163]
                    || p[162] || p[161] || p[158] || p[157] || p[156] || p[154] || p[153] || p[151] || p[149] || p[148]
                    || p[147] || p[146] || p[143] || p[137] || p[135] || p[133] || p[129] || p[128] || p[127] || p[125]
                    || p[123] || p[122] || p[119] || p[118] || p[117] || p[115] || p[114] || p[112] || p[107] || p[104]
                    || p[98]  || p[97]  || p[93]  || p[92]  || p[91]  || p[90]  || p[89]  || p[88]  || p[87]  || p[85] 
                    || p[83]  || p[82]  || p[80]  || p[78]  || p[76]  || p[74]  || p[73]  || p[72]  || p[69]  || p[67]
                    || p[66]  || p[65]  || p[64]  || p[63]  || p[60]  || p[53]  || p[47]  || p[21]  || p[17]  || p[13];

	pl[20] = p[237] || p[226] || p[225] || p[222] || p[218] || p[216] || p[214] || p[213] || p[212] || p[211]
                    || p[210] || p[207] || p[200] || p[198] || p[192] || p[189] || p[187] || p[174] || p[171] || p[165] 
                    || p[164] || p[163] || p[160] || p[159] || p[157] || p[152] || p[142] || p[126] || p[124] || p[117] 
                    || p[115] || p[114] || p[113] || p[104] || p[100] || p[85]  || p[79]  || p[75]  || p[54]  || p[52] 
                    || p[50]  || p[49]  || p[47]  || p[43]  || p[39]  || p[36]  || p[35]  || p[32]  || p[30]  || p[29]
                    || p[28]  || p[27]  || p[24]  || p[23]  || p[14]  || p[12]  || p[10]  || p[7]   || p[6]   || p[5]
                    || p[4]   || p[2];

	pl[21] = p[230] || p[229] || p[223] || p[220] || p[214] || p[211] || p[208] || p[206] || p[201] || p[178]
                    || p[166] || p[154] || p[147] || p[139] || p[123] || p[112] || p[105] || p[80]  || p[3];

	pl[22] = p[230] || p[229] || p[220] || p[214] || p[211] || p[208] || p[206] || p[201] || p[188] || p[178]
                    || p[175] || p[166] || p[154] || p[153] || p[149] || p[148] || p[147] || p[139] || p[137] || p[129]
                    || p[123] || p[112] || p[105] || p[90]  || p[82]  || p[80];

	pl[23] = p[246] || p[239] || p[228] || p[225] || p[224] || p[222] || p[216] || p[215] || p[213] || p[210]
                    || p[207] || p[205] || p[203] || p[202] || p[200] || p[199] || p[198] || p[194] || p[193] || p[192]
                    || p[189] || p[187] || p[185] || p[183] || p[181] || p[176] || p[175] || p[174] || p[173] || p[172]
                    || p[171] || p[170] || p[168] || p[164] || p[161] || p[160] || p[157] || p[152] || p[150] || p[144]
                    || p[142] || p[135] || p[130] || p[126] || p[125] || p[124] || p[116] || p[115] || p[111] || p[110]
                    || p[108] || p[104] || p[102] || p[101] || p[99]  || p[91]  || p[89]  || p[83]  || p[81]  || p[73]
                    || p[60]  || p[59];

	pl[24] = p[246] || p[244] || p[242] || p[241] || p[239] || p[238] || p[237] || p[236] || p[235] || p[234]
                    || p[233] || p[232] || p[231] || p[230] || p[229] || p[228] || p[227] || p[226] || p[222] || p[220]
                    || p[219] || p[218] || p[214] || p[212] || p[208] || p[207] || p[206] || p[205] || p[204] || p[202]
                    || p[201] || p[200] || p[199] || p[198] || p[197] || p[194] || p[193] || p[192] || p[190] || p[188]
                    || p[186] || p[182] || p[181] || p[180] || p[179] || p[178] || p[175] || p[174] || p[173] || p[172]
                    || p[170] || p[167] || p[166] || p[165] || p[162] || p[159] || p[158] || p[156] || p[155] || p[154]
                    || p[153] || p[152] || p[151] || p[150] || p[149] || p[148] || p[147] || p[146] || p[143] || p[142]
                    || p[138] || p[137] || p[135] || p[133] || p[129] || p[128] || p[127] || p[126] || p[124] || p[123]
                    || p[122] || p[118] || p[116] || p[115] || p[114] || p[113] || p[112] || p[110] || p[107] || p[106]
                    || p[103] || p[99]  || p[98]  || p[97]  || p[95]  || p[90]  || p[88]  || p[87]  || p[85]  || p[82]
                    || p[81]  || p[80]  || p[78]  || p[76]  || p[73]  || p[72]  || p[69]  || p[66]  || p[65]  || p[64]
                    || p[63]  || p[59]  || p[53]  || p[37];

	pl[25] = p[241] || p[236] || p[235] || p[234] || p[233] || p[231] || p[229] || p[223] || p[221] || p[218]
                    || p[216] || p[213] || p[211] || p[210] || p[209] || p[207] || p[200] || p[198] || p[186] || p[180]
                    || p[179] || p[171] || p[167] || p[166] || p[164] || p[163] || p[162] || p[159] || p[157] || p[155]
                    || p[152] || p[146] || p[143] || p[142] || p[133] || p[132] || p[128] || p[127] || p[126] || p[124]
                    || p[123] || p[122] || p[113] || p[101] || p[96]  || p[86]  || p[75]  || p[68]  || p[61]  || p[58]
                    || p[55] || p[40];

	pl[26] = p[241] || p[236] || p[234] || p[233] || p[231] || p[229] || p[227] || p[223] || p[220] || p[218]
                    || p[216] || p[214] || p[213] || p[210] || p[209] || p[207] || p[206] || p[200] || p[197] || p[186]
                    || p[180] || p[179] || p[174] || p[171] || p[167] || p[157] || p[155] || p[148] || p[146] || p[143]
                    || p[133] || p[127] || p[126] || p[123] || p[117] || p[113] || p[104] || p[92]  || p[86]  || p[85]
                    || p[84]  || p[71]  || p[68]  || p[61]  || p[55]  || p[51]  || p[48]  || p[46];

	pl[27] = p[246] || p[241] || p[239] || p[234] || p[233] || p[231] || p[230] || p[229] || p[228] || p[225]
                    || p[224] || p[222] || p[216] || p[214] || p[213] || p[210] || p[209] || p[207] || p[205] || p[202]
                    || p[200] || p[199] || p[197] || p[195] || p[193] || p[189] || p[185] || p[183] || p[181] || p[180]
                    || p[176] || p[172] || p[171] || p[170] || p[163] || p[161] || p[160] || p[159] || p[155] || p[152]
                    || p[144] || p[143] || p[142] || p[138] || p[135] || p[127] || p[126] || p[125] || p[124] || p[123]
                    || p[115] || p[113] || p[111] || p[110] || p[108] || p[102] || p[99]  || p[96]  || p[94]  || p[92]
                    || p[91]  || p[89]  || p[88]  || p[84]  || p[83]  || p[81]  || p[77]  || p[71]  || p[69]  || p[68]
                    || p[65]  || p[62]  || p[60]  || p[59]  || p[58]  || p[56]  || p[42]  || p[26]  || p[11];

	pl[28] = p[246] || p[243] || p[239] || p[237] || p[236] || p[235] || p[234] || p[233] || p[231] || p[230]
                    || p[229] || p[228] || p[227] || p[225] || p[224] || p[222] || p[219] || p[214] || p[213] || p[211]
                    || p[209] || p[205] || p[202] || p[201] || p[199] || p[195] || p[193] || p[190] || p[189] || p[185]
                    || p[183] || p[181] || p[180] || p[176] || p[174] || p[172] || p[170] || p[163] || p[161] || p[160]
                    || p[157] || p[156] || p[155] || p[153] || p[152] || p[143] || p[142] || p[135] || p[128] || p[127]
                    || p[125] || p[122] || p[113] || p[110] || p[104] || p[102] || p[101] || p[96]  || p[91]  || p[89]
                    || p[84]  || p[83]  || p[75]  || p[71]  || p[70]  || p[60]  || p[58]  || p[41]  || p[40];

	pl[29] = p[237] || p[235] || p[234] || p[230] || p[227] || p[224] || p[222] || p[217] || p[216] || p[215]
                    || p[214] || p[211] || p[210] || p[207] || p[203] || p[200] || p[197] || p[195] || p[192] || p[191]
                    || p[189] || p[187] || p[176] || p[174] || p[171] || p[170] || p[161] || p[159] || p[155] || p[144]
                    || p[139] || p[132] || p[126] || p[124] || p[119] || p[118] || p[115] || p[114] || p[113] || p[111]
                    || p[110] || p[108] || p[107] || p[101] || p[99]  || p[96]  || p[93]  || p[91]  || p[88]  || p[87]
                    || p[81]  || p[75]  || p[69]  || p[67]  || p[66]  || p[59]  || p[53]  || p[47];

	pl[30] = p[233] || p[232] || p[231] || p[230] || p[229] || p[225] || p[223] || p[222] || p[221] || p[220]
                    || p[219] || p[211] || p[209] || p[208] || p[206] || p[204] || p[198] || p[197] || p[190] || p[189]
                    || p[180] || p[179] || p[175] || p[168] || p[166] || p[165] || p[164] || p[160] || p[156] || p[150]
                    || p[139] || p[138] || p[118] || p[117] || p[106] || p[105] || p[96]  || p[95]  || p[86]  || p[61];

	pl[31] = p[249] || p[248] || p[247] || p[246] || p[245] || p[244] || p[242] || p[241] || p[239] || p[238]
                    || p[236] || p[234] || p[233] || p[232] || p[230] || p[229] || p[228] || p[227] || p[225] || p[224]
                    || p[222] || p[219] || p[212] || p[209] || p[204] || p[198] || p[195] || p[193] || p[190] || p[189]
                    || p[186] || p[185] || p[183] || p[181] || p[180] || p[179] || p[176] || p[175] || p[172] || p[170]
                    || p[168] || p[167] || p[165] || p[164] || p[160] || p[157] || p[156] || p[155] || p[150] || p[146]
                    || p[144] || p[143] || p[140] || p[138] || p[135] || p[134] || p[130] || p[117] || p[110] || p[102]
                    || p[99]  || p[92];

	pl[32] = p[249] || p[248] || p[247] || p[246] || p[245] || p[244] || p[242] || p[241] || p[239] || p[238]
                    || p[236] || p[234] || p[233] || p[232] || p[231] || p[229] || p[228] || p[227] || p[224] || p[220]
                    || p[219] || p[212] || p[209] || p[206] || p[204] || p[198] || p[195] || p[193] || p[190] || p[186]
                    || p[185] || p[183] || p[181] || p[180] || p[179] || p[176] || p[175] || p[172] || p[170] || p[168]
                    || p[167] || p[165] || p[164] || p[157] || p[156] || p[155] || p[150] || p[146] || p[144] || p[141]
                    || p[139] || p[138] || p[136] || p[135] || p[130] || p[118] || p[117] || p[110] || p[102] || p[99]
                    || p[96]  || p[95]  || p[92];

	pl[33] = p[249] || p[248] || p[247] || p[246] || p[245] || p[244] || p[242] || p[241] || p[239] || p[238]
                    || p[236] || p[235] || p[234] || p[231] || p[228] || p[227] || p[220] || p[212] || p[208] || p[206]
                    || p[198] || p[197] || p[195] || p[193] || p[183] || p[176] || p[175] || p[172] || p[168] || p[167]
                    || p[166] || p[165] || p[164] || p[157] || p[155] || p[146] || p[144] || p[143] || p[135] || p[131]
                    || p[130] || p[118] || p[117] || p[109] || p[105] || p[99]  || p[95];

	for (int i = 0; i < 34; ++i)
	{
		sp[i] = !pl[i];
	}
}
