#include "stdafx.h"
#include "vm1g_pli.h"

#include "defmacros.h"

vm1g_pli::vm1g_pli()
{
	for (int i = 0; i < 12; ++i)
	{
		psw[i] = FALSE;
	}
	for (int i = 0; i < 4; ++i)
	{
		irq[i] = FALSE;
	}
}


vm1g_pli::~vm1g_pli()
{
}

void vm1g_pli::eval(BOOL *rq, BOOL *sp)
{
	psw[10] = rq[0];
	plir    = rq[1];
	psw[11] = rq[2];
	uerr    = rq[3];
	psw[7]  = rq[4];
	virq    = rq[8];       // low active level
	qbto    = rq[9];
	dble    = rq[10];
	aclo    = rq[11];
	wcpu    = rq[12];      // low active level
	acok    = rq[13];
	irq[1]  = rq[14];
	psw[4]  = rq[15];
	irq[2]  = rq[16];
	iato    = rq[17];
	irq[3]  = rq[18];
	tve     = rq[19];

//______________________________________________________________________________
//
// wcpu = 0, simplified matrix to demostrate priority encoding
//
//                             &  iato   &  qbto;
//                             & ~iato   &  qbto &  dble;


//          psw[11]            & ~iato   &  qbto & ~dble;
//                  &  psw[10] & ~iato   &  qbto & ~dble;
//         ~psw[11] & ~psw[10] & ~iato   &  qbto & ~dble;
//
//                                uerr   & ~qbto;

//                    ~psw[10] &  psw[4] & ~qbto         & ~uerr;
//                    ~psw[10] & ~psw[4] & ~qbto &  aclo & ~uerr;
//         ~psw[11] & ~psw[10] & ~psw[4] & ~qbto & ~aclo & ~uerr           &  irq[1];
//   tve &          & ~psw[10] & ~psw[4] & ~qbto & ~aclo & ~uerr & ~psw[7] & ~irq[1];
//  ~tve &          & ~psw[10] & ~psw[4] & ~qbto & ~aclo & ~uerr & ~psw[7] & ~irq[1] &  irq[2];
//  ~tve &          & ~psw[10] & ~psw[4] & ~qbto & ~aclo & ~uerr & ~psw[7] & ~irq[1] & ~irq[2] &  irq[3];
//  ~tve &          & ~psw[10] & ~psw[4] & ~qbto & ~aclo & ~uerr & ~psw[7] & ~irq[1] & ~irq[2] & ~irq[3] & ~virq;
//
	p[0]  = !tve && plir                                    && !qbto && !aclo && !uerr &&  wcpu            && !irq[1] && !irq[2] && !irq[3] && virq;
	p[10] =         plir             && !psw[10] && !qbto                     && !uerr &&  wcpu            && !irq[1];
	p[4]  =         plir             && !psw[10] && psw[4]  && !qbto          && !uerr &&  wcpu            &&  irq[1];

	p[1]  =         plir && !psw[11] && !psw[10] && !psw[4] && !qbto && !aclo && !uerr                     &&  irq[1];
	p[6]  =  tve && plir             && !psw[10] &&  psw[4] && !qbto          && !uerr &&  wcpu && !psw[7] && !irq[1];
	p[8]  =  tve && plir             && !psw[10] && !psw[4] && !qbto && !aclo && !uerr          && !psw[7] && !irq[1];
	p[13] = !tve && plir             && !psw[10] &&  psw[4] && !qbto          && !uerr &&  wcpu && !psw[7] && !irq[1] &&  irq[2];
	p[3]  = !tve && plir             && !psw[10] && !psw[4] && !qbto && !aclo && !uerr          && !psw[7] && !irq[1] &&  irq[2];
	p[14] = !tve && plir             && !psw[10] &&  psw[4] && !qbto          && !uerr &&  wcpu && !psw[7] && !irq[1] && !irq[2] &&  irq[3];
	p[9]  = !tve && plir             && !psw[10] && !psw[4] && !qbto && !aclo && !uerr          && !psw[7] && !irq[1] && !irq[2] &&  irq[3];
	p[2]  = !tve && plir             && !psw[10] &&  psw[4] && !qbto          && !uerr &&  wcpu && !psw[7] && !irq[1] && !irq[2] && !irq[3] && !virq;
	p[5]  = !tve && plir             && !psw[10] && !psw[4] && !qbto && !aclo && !uerr          && !psw[7] && !irq[1] && !irq[2] && !irq[3] && !virq;

	p[11] =         plir             && !psw[10] &&  psw[4] && !qbto          && !uerr && !wcpu;
	p[12] =         plir             && !psw[10] && !psw[4] && !qbto &&  aclo && !uerr;
	p[21] =         plir && !psw[11] && !psw[10] && !iato   &&  qbto && !dble;
	p[15] =         plir &&  psw[11] && !iato    &&  qbto   && !dble;
	p[19] =         plir             &&  psw[10] && !iato   &&  qbto && !dble;
	p[20] =         plir                         && !iato   &&  qbto &&  dble;
	p[17] =         plir                         &&  iato   &&  qbto;
	p[16] =         plir                         &&  uerr   && !qbto;
	p[7]  =        !plir && !acok;
	p[18] =        !plir &&  acok;

	pl[0]  = p[21] || p[20] || p[16] || p[14] || p[13] || p[9]  || p[8]  || p[6]  || p[3]  || p[2];
	pl[1]  = p[21] || p[20] || p[18] || p[14] || p[12] || p[9]  || p[8]  || p[6];
	pl[2]  = p[21] || p[18] || p[17] || p[5]  || p[2];
	pl[3]  = p[21] || p[20] || p[18] || p[17] || p[16] || p[11];
	pl[4]  = p[7];
	pl[5]  = p[21] || p[18] || p[16] || p[14] || p[13] || p[12] || p[11] || p[9]  || p[8]  || p[6] || p[5] || p[3] || p[2];
	pl[6]  = p[21] || p[20] || p[19] || p[17] || p[16] || p[15] || p[14] || p[13] || p[11] || p[9] || p[5] || p[3] || p[2];
	pl[7]  = p[20] || p[19] || p[18] || p[17] || p[15] || p[4]  || p[1];
	pl[8]  = p[21] || p[20] || p[19] || p[18] || p[17] || p[16] || p[15] || p[14] || p[12] || p[9] || p[8] || p[6];
	pl[9]  = p[14] || p[13] || p[12] || p[11] || p[10] || p[9]  || p[8]  || p[7]  || p[5]  || p[4] || p[3] || p[1] || p[0];
	pl[10] = p[21] || p[20] || p[19] || p[18] || p[17] || p[16] || p[15] || p[12] || p[11] || p[5] || p[2];
	
	for (int i = 0; i < 11; ++i)
	{
		sp[i] = !pl[i];
	}
}

