#pragma once

// Main matrix inputs format:
//
//    ir[15:0] - instruction code latched in instrustion register (opcode)
//    mr[14:0] - microinstruction state word also latched
//       mr[6:0] - address/state field, controlled by PLM outputs
//          sp[0]  -> mr[6]
//          sp[5]  -> mr[5]
//          sp[9]  -> mr[4]
//          sp[15] -> mr[3]
//          sp[19] -> mr[2]
//          sp[24] -> mr[1]
//          spl29] -> mr[0] + reset
//
//       mr[7]  - psw[0] - C (carry) flag or condition
//       mr[8]  - psw[1] - V (overflow) flag or condition)
//       mr[9]  - psw[2] - Z (zero) flag or condition
//       mr[10] - psw[3] - N (negative) flag or condition
//       mr[11] - psw[4] - T (trap) flag
//
//       mr[14:12] - multiplexed
//       priority encoder branch:
//          mr[12]   - sp[9] priority encoder
//          mr[13]   - sp[7] priority encoder
//          mr[14]   - sp[5] priority encoder
//       feedback from main matrix
//          mr[12]   - ~plr17
//          mr[13]   -  plr16
//          mr[14]   - ~plr14
//
// Main matrix outputs format (after SOP inversion):
//      plx[0]   ~mj[6];
//      plx[5]    mj[5]
//      plx[9]    mj[4]
//      plx[12]   opcode is not recognized
//      plx[15]   mj[3]
//      plx[19]  ~mj[2]
//      plx[24]  ~mj[1]
//      plx[29]  ~mj[0]
//
//		plx[6]	QBUS operation type: byte operation flag
//		plx[7]	QBUS operation type: write flag
//		plx[8]	QBUS operation type: read flag
//						00x - nothing
//						010 - write word
//						011 - write byte
//						100 - read word
//						101 - read byte
//						110 - read-modify-write word
//						111 - read-modify-write byte
//______________________________________________________________________________
//

class vm1a_plm
{
	// 
	BOOL p[250];	//wire [249:2]
	BOOL pl[34];	//wire [33:0]
	DWORD m_ai;
	/*
	 cmp       
	*/
	static const DWORD ignore_bits[250];
	static const DWORD mask_bits[250];

public:
	vm1a_plm(void) {}
	~vm1a_plm(void) {}
	void eval(WORD ir, WORD mr, BOOL *sp);

};
