#pragma once

//______________________________________________________________________________
//
// Interrupt priority matrix input description:
//
//    rq[0]    - psw[10]
//    rq[1]    - feedback - output  sp[4] (pli4r net)
//    rq[2]    - psw[11]
//    rq[3]    - unknown opcode error
//    rq[4]    - psw[7] interrupt priority/disable
//    rq[5]    - unused (former some error 2 request)
//    rq[6]    - unused (former start request)
//    rq[7]    - unused (former some error 3 request)
//    rq[8]    - vectored interrupt request (low active)
//    rq[9]    - normal qbus timeout trap or odd address
//    rq[10]   - double error trap
//    rq[11]   - nACLO falling edge detector (nACLO failed)
//    rq[12]   - wait mode (bit 2 of mode register 177700)
//    rq[13]   - nACLO raising edge detector (nACLO restored)
//    rq[14]   - radial interrupt request IRQ1
//    rq[15]   - psw[4] T-bit
//    rq[16]   - radial interrupt request IRQ2
//    rq[17]   - vector fetch qbus timeout
//    rq[18]   - radial interrupt request IRQ3
//    rq[19]   - unused (used to be the VE-timer request)
//
// Interrupt priority matrix output description:
//
//    sp[0]    - vector generator selector  bit 0
//    sp[1]    - vector generator selector  bit 1
//    sp[2]    - vector generator selector ~bit 2
//    sp[3]    - vector generator selector  bit 3
//    sp[4]    - feedback to priority matrix - plir
//
//    sp[6]    - controls the request detectors rearm
//    sp[8]    - controls the request detectors rearm
//    sp[10]   - controls the request detectors rearm
//
//    sp[5]    - goes to the main microcode register ~mj[14]
//    sp[7]    - goes to the main microcode register ~mj[13]
//    sp[9]    - goes to the main microcode register ~mj[12]
//
//
// On schematics vsel is {pli[3], ~pli[2], pli[1], pli[0]}
//
// 4'b0000: vmux = 16'o160006;      // double error
// 4'b0001: vmux = 16'o000020;      // IOT instruction
// 4'b0010: vmux = 16'o000010;      // reserved opcode
// 4'b0011: vmux = 16'o000014;      // T-bit trap
// 4'b0100: vmux = 16'o000004;      // invalid opcode
// 4'b0101:                         // or qbus timeout
//    case (pa[1:0])                // initial start
//       2'b00: vmux = 16'o177716;  // register base
//       2'b01: vmux = 16'o177736;  // depends on
//       2'b10: vmux = 16'o177756;  // processor number
//       2'b10: vmux = 16'o177776;  //
//    endcase                       //
// 4'b0110: vmux = 16'o000030;      // EMT instruction
// 4'b0111: vmux = 16'o160012;      // int ack timeout
// 4'b1000: vmux = 16'o000270;      // IRQ3 falling edge
// 4'b1001: vmux = 16'o000024;      // ACLO falling edge
// 4'b1010: vmux = 16'o000100;      // IRQ2 falling edge
// 4'b1011: vmux = 16'o160002;      // IRQ1 low level/HALT
// 4'b1100: vmux = 16'o000034;      // TRAP instruction
// 4'b1101: vmux = vreg;            // vector register
// 4'b1110: vmux = svec;            // start @177704
// 4'b1111: vmux = 16'o000000;      // unused vector
//
//______________________________________________________________________________
//
class vm1a_pli {
	// 
	BOOL	p[21];

public:
	vm1a_pli(void);
	~vm1a_pli(void);
	/*
	 * : rq - ,  20 BOOL
	 * : sp - ,   11 BOOL
	 *        .
	 **/
	void eval(BOOL *rq, BOOL *sp);
};
