#pragma once

struct VM1_QBUS_WIRES
{
	//input wire
	BYTE pin_pa;		// processor number
	BOOL pin_init_in;   // peripheral reset input

	BOOL pin_dclo;      // processor reset
	BOOL pin_aclo;      // power fail notification
	BOOL pin_irq[4];	// radial interrupt requests, pin_irq[0] == pin_virq// vectored interrupt request

	WORD pin_ad_in;		// data bus input

	BOOL pin_dout_in;   // data output strobe input
	BOOL pin_din_in;    // data input strobe input

	BOOL pin_sync_in;   // address strobe input

	BOOL pin_rply_in;   // transaction reply input
	BOOL pin_dmr_in;    // bus request shared line
	BOOL pin_sack_in;   // bus acknowledgement

	BOOL pin_dmgi;      // bus granted input
	BOOL pin_sp;

	//output wire
	BOOL pin_init_out;  // peripheral reset output

	WORD pin_ad_out;	// address/data bus output
	BOOL pin_ad_ena;    // address/data bus enable

	BOOL pin_dout_out;  // data output strobe output
	BOOL pin_din_out;   // data input strobe output
	BOOL pin_wtbt_out;  // write/byte status
	BOOL pin_ctrl_ena;  // enable control outputs

	BOOL pin_sync_out;  // address strobe output
	BOOL pin_sync_ena;  // address strobe enable

	BOOL pin_rply_out;  // transaction reply output
	BOOL pin_dmr_out;   // bus request shared line
	BOOL pin_sack_out;  // bus acknowledgement

	BOOL pin_dmgo_out;  // bus granted output
	BOOL pin_iako_out;  // interrupt vector input
	BOOL pin_sel1_out;	// register select outputs
	BOOL pin_sel2_out;	// register select outputs
	BOOL pin_bsy_out;   // bus busy flag


	BOOL	wb_pio_dat_i[16];	//wire[15:0]	//
//	WORD	wb_cpu_dat_i;		//wire[15:0]	//
	BOOL	plx[34];			//wire[33:0]	// main microcode matrix output
	BOOL	pli[11];			//wire[10:0]	// interrupt priority encode matrix output
	BOOL	tve_irq;			//wire			// VE-timer interrupt request (vm1a_pli ignores)
	BOOL	tve_ack;			//wire			// VE-timer interrupt acknowledgement
	BOOL	exc_uop;			//wire			// Undefined opcode found
	BOOL	exc_oat;			//wire			// Odd address trap detector
	BOOL	exc_err2;			//wire			//
	BOOL	exc_err3;			//wire			//
	BOOL	exc_err7;			//wire			//
	BOOL	qbus_tena;			//wire			//
	BOOL	uop_ack;			//wire			// undefined instruction
	BOOL	aclo_ack;			//wire			// ACLO timer acknowlegement
	BOOL	irq2_ack;			//wire			// IRQ2 timer acknowlegement
	BOOL	irq3_ack;			//wire			// IRQ3 timer acknowlegement
	BOOL	ir_stb1;			//wire			//
	BOOL	ir_clr;				//wire			//
	BOOL	ir_set_fc;			//wire			//
	BOOL	ir_seq_rc;			//wire			//
	BOOL	pli_req_rc;			//wire			// interrupt encoder request
	BOOL	pli_stb;			//wire			// interrupt matrix strobe
//	BOOL	pli_nrdy;			//wire			// interrupt matrix not ready
	BOOL	plm_stb_rc;			//wire			// plm_register strobe source
	BOOL	plm1x_fc;			//wire			//
	BOOL	plm2x_fc;			//wire			// main matrix result strobes
	BOOL	plm_ena_fc;			//wire			//
//	BOOL	sop_up;				//wire			//
//	BOOL	plop[8];			//wire[7:0]		//
	BYTE	plop;
	BOOL	uplr_stb;			//wire			//
	BOOL	plm23_fc[4];		//wire[3:0]		//
	BOOL	tplm_rc[4];			//wire[3:1]		//
	BOOL	mjres_rc;			//wire			//
	BOOL	reset_rc;			//wire			//
	BOOL	abort_rc;			//wire			//
//	WORD	d;					//wire[15:0]	// internal data bus
//	WORD	tve_d;				//wire[15:0]	// timer module data output
//	BOOL	ad_oe;				//wire			// external AD pins output enable
//	BOOL	sel177x;			//wire			// peripheral block access
//	BOOL	sel_in;				//wire			//
	BOOL	sel_out;			//wire			//
	BOOL	rply_s1;			//wire			//
	BOOL	dmr_req_rc;			//wire			//
	BOOL	dmr_out;			//wire			//
	BOOL	iako_out;			//wire			//
	BOOL	qbus_done;			//wire			//
	BOOL	rply_ack_fc;		//wire			//
	BOOL	oe_set_fc;			//wire			//
	BOOL	oe_clr_fc;			//wire			//
//	BOOL	qbus_nrdy;			//wire			//
	BOOL	dout_start;			//wire			//
	BOOL	dout_req_rc;		//wire			//
//	BOOL	dout_ext;			//wire			//
	BOOL	din_done;			//wire			//
	BOOL	din_start;			//wire			//
//	BOOL	dmgo_out;			//wire			//
//	BOOL	qbus_yield;			//wire			//
//	BOOL	qbus_own;			//wire			//
	BOOL	qbus_flag_rc;		//wire			//
	BOOL	sync_stb;			//wire			//
	BOOL	sync_fedge;			//wire			//
	BOOL	qbus_nosr_rc;		//wire			//
	BOOL	qbus_gnt;			//wire			//
//	BOOL	qbus_free;			//wire			//
	WORD	x, xr;				//wire[15:0]	// X bus
	WORD	y, yr;				//wire[15:0]	// Y bus
//	WORD	f;					//wire[15:0]	// ALU function inverted output
//	WORD	h;					//wire[15:0]	// half summ
//	WORD	c;					//wire[15:0]	// carry
//	WORD	cpred;				//wire[15:0]	// carry form preceding but
//	BOOL	fmux[2];			//wire[1:0]		//
	BOOL	flag[4];			//wire[3:0]		//
//	BOOL	fbit7, fbit15;		//wire			//
//	BOOL	fctl[8];			//wire[7:1]		//
//	BOOL	fbitc;				//wire			//
	BOOL	cl_fc;				//wire			//
	BOOL	alu_b_fc;			//wire			//
	BOOL	alu_c_fc;			//wire			//
	BOOL	alu_d_fc;			//wire			//
	BOOL	alu_e_fc;			//wire			//
	BOOL	alu_x_fc;			//wire			//
	BOOL	alu_s_fc;			//wire			//
//	WORD	alu;				//wire[15:0]	// ALU output to X/Y bus
//	WORD	axy;				//wire[15:0]	// AND product
//	WORD	oxy;				//wire[15:0]	// OR product
	BOOL	alu_qrdy;			//wire			// Qbus data ready
	BOOL	au_qsx, au_qsy;		//wire			// qbus temporary register
	BOOL	au_pswx, au_pswy;	//wire			// PSW read enable
	BOOL	au_pstbx;			//wire			// PSW write strobe
	BOOL	au_astb;			//wire			//
	BOOL	au_qstbx;			//wire			//
	BOOL	au_qstbd;			//wire			//
	BOOL	au_is0;				//wire			// ALU X argument strobes
//	BOOL	au_is1;				//wire			// ALU X argument strobes
//	BOOL	au_qrdd;			//wire			//
//	WORD	qrd;				//wire[15:0]	// qbus byte swap data
//	WORD	nx;					//wire[15:0]	//
//	BOOL	vc_vsel, vc_csel;	//wire
//	BOOL	rs0[14], rs1[14];	//wire[13:0]	// register select
//	BOOL	rsw[14];			//wire[13:0]	// register select
	WORD	rsw;

	// 
//	BOOL	tve_reset;			//wire
//	BOOL	tve_csr_oe;			//wire
//	BOOL	tve_cnt_oe;			//wire
//	BOOL	tve_lim_oe;			//wire
	BOOL	tve_csr_wr;			//wire
	BOOL	tve_lim_wr;			//wire
	BOOL	tve_tclk128;		//wire			// prescaler /128 output
	BOOL	pin_spclk;			//wire			// extrenal event on SP
	BOOL	tve_zero;			//wire			// timer counter zero value
	BOOL	tve_load;			//wire			// timer counter load
	BOOL	tve_back;			//wire			// timer capture load


	void clear()
	{
		memset(this, 0, sizeof(VM1_QBUS_WIRES));
	};
	VM1_QBUS_WIRES &operator = (const VM1_QBUS_WIRES &src)
	{
		memcpy(this, &src, sizeof(VM1_QBUS_WIRES));
		return *this;
	};

	BOOL operator != (const VM1_QBUS_WIRES &src)
	{
		int n = memcmp(this, &src, sizeof(VM1_QBUS_WIRES));
		return (n != 0);
	};
	BOOL operator == (const VM1_QBUS_WIRES &src)
	{
		int n = memcmp(this, &src, sizeof(VM1_QBUS_WIRES));
		return (n == 0);
	};
};

struct VM1_QBUS_REGS
{
	BOOL	plr[34];			//reg[33:0]		// main matrix result register (last stage)
	__int64 nPLR, nPLM;
	BOOL	plm[34];			//reg[33:0]		// main matrix result register (first stage)
	BOOL	mj[15];				//reg[14:0]		// microcode stage and condition register
	WORD	ir;					//reg[15:0]		// instruction register (last stage)
	WORD	ira;				//reg[15:0]		// instruction register (first stage)
	BOOL	rq[20];				//reg[19:0]		// interrupt request register
	BOOL	aclo;				//reg			// ACLO falling edge detectors
	BOOL	acok;				//reg			// ACLO raising edge detectors
	BOOL	irq2;				//reg			// IRQ2 falling edge detectors
	BOOL	irq3;				//reg			// IRQ3 falling edge detectors
	BOOL	uop;				//reg			// undefined operation latch
	BOOL	qbto;				//reg			// I/O bus timeout & OAT latch
	BOOL	ivto;				//reg			// IAKO bus timeout latch
	BOOL	start_irq;			//reg			// raised by 1777x2 register write
	BOOL	exc_dbl[4];			//reg[3:0]		// double error detector
	BYTE	qbus_timer;			//reg[5:0]		// qbus timeout counter
	BOOL	qbus_tovf;			//reg			// Qbus timer overflow latch
	BOOL	vsel[4];			//reg[3:0]		// vector selection register
	BOOL	plir[4];			//reg[3:0]		// pli[10:8:6:4] outputs latch
	BOOL	ir_stb2;			//reg			// instruction register strobe
	BOOL	ir_set;				//reg			//
	BOOL	ir_stop;			//reg			//
	BOOL	ir_seq;				//reg			//
	BOOL	pli_req;			//reg			// source and latch
	BOOL	plm_stb;			//reg			// plm_register strobe latch
	BOOL	plm1x, plm2x;		//reg			//
	BOOL	plm1x_hl;			//reg			//
	BOOL	plm_ena;			//reg			//
	BOOL	sop_out[4];			//reg[3:0]		//
	BOOL	mj_stb1, mj_stb2;	//reg			//
	BOOL	psw_stb, psw_stbc;	//reg			//
	BOOL	psw_mj;				//reg			//
	BOOL	plm23_wait;			//reg			//
	BOOL	plm23_ichk;			//reg			//
	BOOL	tplm[4];			//reg[3:1]		//
	BOOL	tplmz[4];			//reg[3:1]		//
	BOOL	plrt[9];			//reg[8:6]		//
	BOOL	plrtz[9];			//reg[8:6]		//
	BOOL	reset;				//reg			// global device hardware reset
	BOOL	abort;				//reg			// odd address. bus hang, invalid opcode
	BOOL	mjres;				//reg			// reset microcode state machine
	BOOL	mjres_h;			//reg			//
	BOOL	abort_tm;			//reg			//
	BOOL	sel_00, sel_02,		//reg			// peripheral block selectors
		sel_04, sel_06,		//				//
		sel_10, sel_12,		//				//
		sel_14, sel_16,		//				//
		sel_xx;				//				//
	BOOL	rply_s2, rply_s3;	//reg			// disable rply generation if start_irq active
	BOOL	dmr_req;			//reg			//
	BOOL	dmr_req_l;			//reg			//
	BOOL	iako_out_lh;		//reg			//
	BOOL	iak_flag;			//reg			//
	BOOL	init_out[3];		//reg[2:0]		//
	BOOL	rply_ack[4];		//reg[3:1]		//
	BOOL	iako_oe;			//reg			//
	BOOL	oe_set;				//reg			//
	BOOL	oe_clr;				//reg			//
	BOOL	qbus_aseq[2];		//reg[1:0]		// address request sequencer
	BOOL	dout_done;			//reg			//
	BOOL	dout_req;			//reg			//
	BOOL	dout_out;			//reg			//
	BOOL	dout_out_l;			//reg			//
	BOOL	din_out;			//reg			//
	BOOL	din_out_l;			//reg			//
	BOOL	dmgi_in_l;			//reg			//
	BOOL	qbus_adr;			//reg			//
	BOOL	qbus_req;			//reg			//
	BOOL	qbus_win;			//reg			//
	BOOL	qbus_win_h;			//reg			//
	BOOL	qbus_own_fp;		//reg			//
	BOOL	qbus_own_rp;		//reg			//
	BOOL	qbus_flag;			//reg			//
	BOOL	sack_out;			//reg			//
	BOOL	sync_out;			//reg			//
	BOOL	sync_out_h;			//reg			//
	BOOL	sync_ena;			//reg			//
	BOOL	qbus_nosr_h;		//reg			//
	BOOL	qbus_gnt_l;			//reg			//
	BOOL	qbus_free_h;		//reg			//
	BOOL	reg_csr[3];			//reg[2:0]		// 177700: control register
	BOOL	reg_err[8];			//reg[7:0]		// 177704: error register
	BOOL	freg[4];			//reg[3:0]		//
	BOOL	psw[16];			//reg[15:0]		// processor status word
	BOOL	cl;					//reg			// inserted least bit carry
	BOOL	alu_b, alu_c;		//reg			// ALU function selector
	BOOL	alu_d, alu_e;		//reg			// registered for speed
	BOOL	alu_s, alu_x;		//reg			//
	BOOL	ustb, ustb_h;		//reg			//
	BOOL	ustb1, ustb1_h;		//reg			//
	BOOL	ustb1_hl;			//reg			//
	BOOL	alu_busy_fp;		//reg			// ALU busy (not ready phase shifted)
	BOOL	alu_busy_rp;		//reg			//
	BOOL	alu_nrdy;			//reg			// ALU not ready
	BOOL	au_alsl, au_alsh;	//reg			// ALU result strobes
	BOOL	au_ta0;				//reg			//
	BOOL	au_astb_xa;			//reg			// au_astb/au_qstb speed optimizers
	BOOL	au_qstb_xa;			//reg			//
	BOOL	au_astb_xu;			//reg			//
	BOOL	au_qstb_xu;			//reg			//
	WORD	qreg;				//reg[15:0]		// ALU Q register (Q-bus data)
	WORD	areg;				//reg[15:0]		// ALU A register (Q-bus address)
	WORD	xreg;				//reg[15:0]		// ALU X parameter register
	WORD	yreg;				//reg[15:0]		// ALU Y parameter register
	BOOL	vc_vreg[4];			//reg[3:0]
	WORD	gpr[14];			//reg[15:0]		// register array
	WORD	vmux;				//reg[15:0]		// variable for vector multiplexer
	WORD	cmux;				//reg[15:0]		// variable for constant multiplexer
	BYTE	xadr;				//reg[3:0]
	BYTE	yadr;				//reg[3:0]

	// 
	WORD	tve_limit;			//reg[15:0]		// timer reload & capture register
	WORD	tve_count;			//reg[15:0]		// timer counter register
	BOOL	tve_csr[8];			//reg[7:0]		// timer control register
	BYTE	tve_pre;			//reg[6:0]		// clock prescaler counter
	BYTE	tve_div;			//reg[5:0]		// timer clock divisor
	BOOL	tve_edge[3];		//reg[2:0]		// external falling edge detector
	BOOL	tve_tclk;			//reg			// selected timer clock
	BOOL	tve_tclk4;			//reg			// prescaler /4 output
	BOOL	tve_intrq[2];		//reg[1:0]		// hidden interrupt request


	void clear()
	{
		memset(this, 0, sizeof(VM1_QBUS_REGS));
	};
	VM1_QBUS_REGS &operator = (const VM1_QBUS_REGS &src)
	{
		memcpy(this, &src, sizeof(VM1_QBUS_REGS));
		return *this;
	};
	BOOL operator != (const VM1_QBUS_REGS &src)
	{
		int n = memcmp(this, &src, sizeof(VM1_QBUS_REGS));
		return (n != 0);
	};
	BOOL operator == (const VM1_QBUS_REGS &src)
	{
		int n = memcmp(this, &src, sizeof(VM1_QBUS_REGS));
		return (n == 0);
	};
};

