#pragma once
#include "defmacros.h"

#include "vm1a_pli.h"
#include "vm1a_plm.h"
#include "vm1g_pli.h"
#include "vm1g_plm.h"

#include "vm1_qbus_shared.h"

#include "..\Debugger.h"

#define DBG_OUT_PLM_LOG 1
#undef DBG_OUT_PLM_LOG
#define DBG_OUT_PLI_LOG 1
#undef DBG_OUT_PLI_LOG

//input-output
struct VM1_IO
{
	BOOL pin_ena;			//input			// processor clock enable
	BYTE pin_pa_n;			//input[1:0]	// processor number
	WORD pin_ad_n;			//inout[15:0]	// inverted address/data bus
	BOOL pin_init_n;		//inout			// peripheral reset
	BOOL pin_dclo_n;		//input			// processor reset
	BOOL pin_aclo_n;		//input			// power fail notificaton
	BOOL pin_irq1_n;		//input			// radial interrupt requests
	BOOL pin_irq2_n;		//input			// radial interrupt requests
	BOOL pin_irq3_n;		//input			// radial interrupt requests
	BOOL pin_virq_n;		//input			// vectored interrupt request
	BOOL pin_dout_n;		//inout			// data output strobe
	BOOL pin_din_n;			//inout			// data input strobe
	BOOL pin_wtbt_n;		//output		// write/byte status
	BOOL pin_sync_n;		//inout			// address strobe
	BOOL pin_rply_n;		//inout			// transaction reply
	BOOL pin_dmr_n;			//inout			// bus request shared line
	BOOL pin_sack_n;		//inout			// bus acknowlegement
	BOOL pin_dmgi_n;		//input			// bus granted input
	BOOL pin_dmgo_n;		//output		// bus granted output
	BOOL pin_iako_n;		//output		// interrupt vector input
	BOOL pin_sp_n;			//input			// peripheral timer input
	BOOL pin_sel1_n;		//output		// register select outputs
	BOOL pin_sel2_n;		//output		// register select outputs
	BOOL pin_bsy_n;			//output		// bus busy flag
	void clear()
	{
		pin_ena = TRUE;
		pin_pa_n = -1;
		pin_ad_n = -1;
		pin_init_n = TRUE;
		pin_dclo_n = TRUE;
		pin_aclo_n = TRUE;
		pin_irq1_n = TRUE;
		pin_irq2_n = TRUE;
		pin_irq3_n = TRUE;
		pin_virq_n = TRUE;
		pin_dout_n = TRUE;
		pin_din_n  = TRUE;
		pin_wtbt_n = TRUE;
		pin_sync_n = TRUE;
		pin_rply_n = TRUE;
		pin_dmr_n  = TRUE;
		pin_sack_n = TRUE;
		pin_dmgi_n = TRUE;
		pin_dmgo_n = TRUE;
		pin_iako_n = TRUE;
		pin_sp_n   = TRUE;
		pin_sel1_n = TRUE;
		pin_sel2_n = TRUE;
		pin_bsy_n  = TRUE;
	};
};

class C1801VM1 
{
	friend class CDebugger;


	DWORD m_nDeviceID;

	void setMPI(MPI *pMPI); //  CPU -> MPI
	void getMPI(MPI *pMPI); //  MPI -> CPU

	// 
	//,    
	VM1_QBUS_REGS	reg, snap_reg;

	//wires,     ,     
	VM1_QBUS_WIRES	wire, prev_wire;

	//
	vm1a_pli		*pli_matrix_a;
	vm1a_plm		*plm_matrix_a;
	vm1g_pli		*pli_matrix_g;
	vm1g_plm		*plm_matrix_g;

	enum CPU_TYPE
	{
		CPU_VM1A,
		CPU_VM1G
	};
	CPU_TYPE		m_nCpuType;
	int				m_nClk;
	BOOL			m_bInit;

protected:
	/*    
	: 
	  
	- 
	*/
	void data2bita(BYTE d, BOOL *pBa, int nLen)
	{
		for (int i = 0; i < nLen; ++i)
		{
			pBa[i] = ((d & 1) == 1);
			d >>= 1;
		}
	}
	void data2bita(WORD d, BOOL *pBa, int nLen)
	{
		for (int i = 0; i < nLen; ++i)
		{
			pBa[i] = ((d & 1) == 1);
			d >>= 1;
		}
	}
	void data2bita(DWORD d, BOOL *pBa, int nLen)
	{
		for (int i = 0; i < nLen; ++i)
		{
			pBa[i] = ((d & 1) == 1);
			d >>= 1;
		}
	}
	void data2bita(__int64 d, BOOL *pBa, int nLen)
	{
		for (int i = 0; i < nLen; ++i)
		{
			pBa[i] = ((d & 1) == 1);
			d >>= 1;
		}
	}
	// 
	void bita2data(BOOL *pBa, BYTE &d, int nLen)
	{
		d = 0;
		for (int i = nLen - 1; i >= 0; i--)
		{
			d <<= 1;
			if (pBa[i])
			{
				d++;
			}
		}
	}
	void bita2data(BOOL *pBa, WORD &d, int nLen)
	{
		d = 0;
		for (int i = nLen - 1; i >= 0; i--)
		{
			d <<= 1;
			if (pBa[i])
			{
				d++;
			}
		}
	}
	void bita2data(BOOL *pBa, DWORD &d, int nLen)
	{
		d = 0;
		for (int i = nLen - 1; i >= 0; i--)
		{
			d <<= 1;
			if (pBa[i])
			{
				d++;
			}
		}
	}
	void bita2data(BOOL *pBa, __int64 &d, int nLen)
	{
		d = 0;
		for (int i = nLen - 1; i >= 0; i--)
		{
			d <<= 1;
			if (pBa[i])
			{
				d++;
			}
		}
	}

	void initial();

	void assign_in();
	void assign_func();
	void assign_all(MPI *pMPI);
	void eval_all_p();
	void eval_all_n();

	void always_posedge_pin_clk_p_or_posedge_tve_reset(); // 
	void always_posedge_pin_clk_n();
	void always_posedge_pin_clk_p();

	void always_posedge_pin_clk_n_or_posedge_mjres_part_mjres();
	void always_posedge_pin_clk_n_or_posedge_mjres_part_pin_clk_n();

	void always_posedge_pin_clk_p_or_posedge_mjres_part_mjres();
	void always_posedge_pin_clk_p_or_posedge_mjres_part_pin_clk_p();

	void always_posedge_pin_clk_n_or_negedge_qbus_tena();

	void always_posedge_pin_clk_n_or_posedge_reset_part_reset();
	void always_posedge_pin_clk_n_or_posedge_reset_part_pin_clk_n();

	void always_posedge_pin_clk_p_or_posedge_reset_part_reset();
	void always_posedge_pin_clk_p_or_posedge_reset_part_pin_clk_p();

	void always_posedge_pin_clk_p_or_posedge_abort_part_abort();
	void always_posedge_pin_clk_p_or_posedge_abort_part_pin_clk_p();

	void always_a();

	// .
#ifdef DBG_OUT_PLI_LOG
	//	1.  PLI
	FILE *m_PLILog;
	void OutPLILog();
#endif
#ifdef DBG_OUT_PLM_LOG
	//	2.  PLM
	FILE *m_PLMLog;
	void OutPLMLog();
#endif


public:
	//input-output
	VM1_IO m_IOPins;	// .

	C1801VM1();
	~C1801VM1();

	void SetCpuType(CPU_TYPE nCPUType) { m_nCpuType = nCPUType; }
	CPU_TYPE GetCpuType() { return m_nCpuType; }

	void AttachDebugger(CDebugger *pDbg) { pDbg->AttachDebugger(this); }
	void eval_p(int nClk, MPI *pMPI);
	void eval_n(int nClk, MPI *pMPI);
	void RegisterDevice(MPI *pMPI);
};

