#pragma once

#define GETBIT(s,n) ((BOOL)(((s) >> (n)) & 1) == 1)

#define SETBIT(d,n,v) ((v) ? ((d) |= (1<<(n))) : ((d) &= ~(1<<(n))))

#define BIN__N(x) (x) | x>>3 | x>>6 | x>>9
#define BIN__B(x) (x) & 0xf | (x)>>12 & 0xf0

#define BIN8(v) (BIN__B(BIN__N(0x##v)))

#define BIN16(x1,x2) \
    ((BIN8(x1)<<8)+BIN8(x2))

#define BIN24(x1,x2,x3) \
    ((BIN8(x1)<<16)+(BIN8(x2)<<8)+BIN8(x3))

#define BIN32(x1,x2,x3,x4) \
    ((BIN16(x1,x2)<<16)+BIN16(x3,x4))

#define BIN64(x1,x2,x3,x4,x5,x6,x7,x8) \
    ((__int64(BIN32(x1,x2,x3,x4)) << 32) + __int64(BIN32(x5,x6,x7,x8)))



// ,   
class MPI
{
	int m_nRegDevNumber; //   .

	//    .
	DWORD m_nADmask;
	DWORD m_nAEmask;
	DWORD m_nSYNCmask;
	DWORD m_nDINmask;
	DWORD m_nDOUTmask;
	DWORD m_nRPLYmask;
	DWORD m_nWTBTmask;
	DWORD m_nBS7mask;
	DWORD m_nREFmask;
	DWORD m_nDMRmask;
	DWORD m_nDMGOmask;
	DWORD m_nSACKmask;
	DWORD m_nVIRQmask;
	DWORD m_nIRQ1mask;
	DWORD m_nIRQ2mask;
	DWORD m_nIRQ3mask;
	DWORD m_nIAKOmask;
	DWORD m_nIAK1mask;
	DWORD m_nIAK2mask;
	DWORD m_nIAK3mask;
	DWORD m_nEVNTmask;
	DWORD m_nINITmask;
	DWORD m_nHALTmask;
	DWORD m_nPOKmask;
	DWORD m_nDCOKmask;
	DWORD m_nDMGImask;
	DWORD m_nBSYmask;
	DWORD m_nSEL1mask;
	DWORD m_nSEL2mask;

public:
	//  
	WORD ad_n;		//- 15-0										-
	BYTE ae_n;		//  23-16									-
	//  
	BOOL sync_n;	// 										- 
	BOOL din_n;		// 												-
	BOOL dout_n;	// 												-
	BOOL rply_n;	// 											-
	BOOL wtbt_n;	// "-"										-
	BOOL bs7_n;		// 											-
	BOOL ref_n;		// "" -						 - 
	//  
	BOOL dmr_n;		// 											 -
					//  							 -
	BOOL dmgo_n;	//   							- 
					//    		- 
	BOOL sack_n;	// 										-
	// 
	BOOL irq0_n;	//  								4	-
	BOOL irq1_n;	//  								5	-
	BOOL irq2_n;	//  								6	-
	BOOL irq3_n;	//  								7	-
	BOOL iak0_n;	// 								4	-
	BOOL iak1_n;	// 								5	-
	BOOL iak2_n;	// 								6	-
	BOOL iak3_n;	// 								7	-
	BOOL evnt_n;	//   							-
	// 
	BOOL init_n;	//													, - 
	BOOL halt_n;	//													-
	BOOL pok_n;		//  					ACLO			 -
	BOOL dcok_n;	//  					DCLO			 - 
	// ,       ,     .
	BOOL dmgi_n;	// bus granted input
	BOOL bsy_n;  	// bus busy flag
	BOOL sel1_n;
	BOOL sel2_n;

	void clear()
	{
		ad_n = -1;
		ae_n = -1;
		sync_n = TRUE;
		din_n  = TRUE;
		dout_n = TRUE;
		rply_n = TRUE;
		wtbt_n = TRUE;
		bs7_n  = TRUE;
		ref_n  = TRUE;
		dmr_n  = TRUE;
		dmgo_n = TRUE;
		sack_n = TRUE;
		irq0_n = TRUE;
		irq1_n = TRUE;
		irq2_n = TRUE;
		irq3_n = TRUE;
		iak0_n = TRUE;
		iak1_n = TRUE;
		iak2_n = TRUE;
		iak3_n = TRUE;
		evnt_n = TRUE;
		init_n = TRUE;
		halt_n = TRUE;
		pok_n  = TRUE;
		dcok_n = TRUE;
		dmgi_n = TRUE;
		bsy_n  = TRUE;
		sel1_n = TRUE;
		sel2_n = TRUE;
		//
		m_nADmask = 0;
		m_nAEmask = 0;
		m_nRPLYmask = 0;
		m_nDOUTmask = 0;
		m_nDINmask  = 0;
		m_nWTBTmask = 0;
		m_nBS7mask = 0;
		m_nREFmask = 0;
		m_nSYNCmask = 0;
		m_nINITmask = 0;
		m_nSACKmask = 0;
		m_nVIRQmask = 0;
		m_nIRQ1mask = 0;
		m_nIRQ2mask = 0;
		m_nIRQ3mask = 0;
		m_nIAKOmask = 0;
		m_nIAK1mask = 0;
		m_nIAK2mask = 0;
		m_nIAK3mask = 0;
		m_nEVNTmask = 0;
		m_nDMRmask = 0;
		m_nDMGOmask = 0;
		m_nHALTmask = 0;
		m_nPOKmask  = 0;
		m_nDCOKmask = 0;
		m_nDMGImask = 0;
		m_nBSYmask  = 0;
		m_nSEL1mask = 0;
		m_nSEL2mask = 0;
	};
	//
	MPI()
		: m_nRegDevNumber(0){}
	//
	~MPI(){}
	/*
	 *    .
	 *    DeviceID - -  DWORD
	 * ..       32
	 **/
	DWORD RegisterDevice()
	{
		if (m_nRegDevNumber >= 32)
		{
			return -1; //  ,     
		}
		DWORD nID = 1 << m_nRegDevNumber++;
		return nID;
	}
	/*
	 *    
	 * : bEna -  
	 *       nData - 
	 *       nID -  ,    
	 */
	void SetAD(DWORD nID, BOOL bEna, WORD nData)
	{
		if (bEna)	//  
		{
			if (m_nADmask & nID) //     
			{
				ad_n = nData;		//      (     )
			}
			else	// -   .
			{
				ad_n &= nData;		//    
			}
			m_nADmask |= nID;	//,     
		}
		else
		{
			m_nADmask &= ~nID;	//   ,  ,      
		}

		if (m_nADmask == 0) //       ,
		{
			ad_n = -1;		//       Z 
		}
	}
	void SetAE(DWORD nID, BOOL bEna, BYTE nData)
	{
		if (bEna)	//  
		{
			if (m_nAEmask & nID) //     
			{
				ae_n = nData;		//      (     )
			}
			else	// -   .
			{
				ae_n &= nData;		//    
			}
			m_nAEmask |= nID;	//,     
		}
		else
		{
			m_nAEmask &= ~nID;	//   ,  ,      
		}

		if (m_nAEmask == 0) //       ,
		{
			ae_n = -1;		//       Z 
		}
	}
	void SetRPLY(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nRPLYmask & nID) //     
			{
				rply_n = nData;		//      (     )
			}
			else	// -   .
			{
				rply_n &= nData;		//    
			}
			m_nRPLYmask |= nID;	//,     
		}
		else
		{
			m_nRPLYmask &= ~nID;	//   ,  ,      
		}

		if (m_nRPLYmask == 0) //       ,
		{
			rply_n = TRUE;		//       Z 
		}
	}
	void SetDOUT(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nDOUTmask & nID) //     
			{
				dout_n = nData;		//      (     )
			}
			else	// -   .
			{
				dout_n &= nData;		//    
			}
			m_nDOUTmask |= nID;	//,     
		}
		else
		{
			m_nDOUTmask &= ~nID;	//   ,  ,      
		}

		if (m_nDOUTmask == 0) //       ,
		{
			dout_n = TRUE;		//       Z 
		}
	}
	void SetDIN(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nDINmask & nID) //     
			{
				din_n = nData;		//      (     )
			}
			else	// -   .
			{
				din_n &= nData;		//    
			}
			m_nDINmask |= nID;	//,     
		}
		else
		{
			m_nDINmask &= ~nID;	//   ,  ,      
		}

		if (m_nDINmask == 0) //       ,
		{
			din_n = TRUE;		//       Z 
		}
	}
	void SetWTBT(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nWTBTmask & nID) //     
			{
				wtbt_n = nData;		//      (     )
			}
			else	// -   .
			{
				wtbt_n &= nData;		//    
			}
			m_nWTBTmask |= nID;	//,     
		}
		else
		{
			m_nWTBTmask &= ~nID;	//   ,  ,      
		}

		if (m_nWTBTmask == 0) //       ,
		{
			wtbt_n = TRUE;		//       Z 
		}
	}
	void SetBS7(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nBS7mask & nID) //     
			{
				bs7_n = nData;		//      (     )
			}
			else	// -   .
			{
				bs7_n &= nData;		//    
			}
			m_nBS7mask |= nID;	//,     
		}
		else
		{
			m_nBS7mask &= ~nID;	//   ,  ,      
		}

		if (m_nBS7mask == 0) //       ,
		{
			bs7_n = TRUE;		//       Z 
		}
	}
	void SetREF(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nREFmask & nID) //     
			{
				ref_n = nData;		//      (     )
			}
			else	// -   .
			{
				ref_n &= nData;		//    
			}
			m_nREFmask |= nID;	//,     
		}
		else
		{
			m_nREFmask &= ~nID;	//   ,  ,      
		}

		if (m_nREFmask == 0) //       ,
		{
			ref_n = TRUE;		//       Z 
		}
	}
	void SetVIRQ(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nVIRQmask & nID) //     
			{
				irq0_n = nData;		//      (     )
			}
			else	// -   .
			{
				irq0_n &= nData;		//    
			}
			m_nVIRQmask |= nID;	//,     
		}
		else
		{
			m_nVIRQmask &= ~nID;	//   ,  ,      
		}

		if (m_nVIRQmask == 0) //       ,
		{
			irq0_n = TRUE;		//       Z 
		}
	}
	void SetIRQ1(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nIRQ1mask & nID) //     
			{
				irq1_n = nData;		//      (     )
			}
			else	// -   .
			{
				irq1_n &= nData;		//    
			}
			m_nIRQ1mask |= nID;	//,     
		}
		else
		{
			m_nIRQ1mask &= ~nID;	//   ,  ,      
		}

		if (m_nIRQ1mask == 0) //       ,
		{
			irq1_n = TRUE;		//       Z 
		}
	}
	void SetIRQ2(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nIRQ2mask & nID) //     
			{
				irq2_n = nData;		//      (     )
			}
			else	// -   .
			{
				irq2_n &= nData;		//    
			}
			m_nIRQ2mask |= nID;	//,     
		}
		else
		{
			m_nIRQ2mask &= ~nID;	//   ,  ,      
		}

		if (m_nIRQ2mask == 0) //       ,
		{
			irq2_n = TRUE;		//       Z 
		}
	}
	void SetIRQ3(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nIRQ3mask & nID) //     
			{
				irq3_n = nData;		//      (     )
			}
			else	// -   .
			{
				irq3_n &= nData;		//    
			}
			m_nIRQ3mask |= nID;	//,     
		}
		else
		{
			m_nIRQ3mask &= ~nID;	//   ,  ,      
		}

		if (m_nIRQ3mask == 0) //       ,
		{
			irq3_n = TRUE;		//       Z 
		}
	}

	void SetIAKO(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nIAKOmask & nID) //     
			{
				iak0_n = nData;		//      (     )
			}
			else	// -   .
			{
				iak0_n &= nData;		//    
			}
			m_nIAKOmask |= nID;	//,     
		}
		else
		{
			m_nIAKOmask &= ~nID;	//   ,  ,      
		}

		if (m_nIAKOmask == 0) //       ,
		{
			iak0_n = TRUE;		//       Z 
		}
	}
	void SetIAK1(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nIAK1mask & nID) //     
			{
				iak1_n = nData;		//      (     )
			}
			else	// -   .
			{
				iak1_n &= nData;		//    
			}
			m_nIAK1mask |= nID;	//,     
		}
		else
		{
			m_nIAK1mask &= ~nID;	//   ,  ,      
		}

		if (m_nIAK1mask == 0) //       ,
		{
			iak1_n = TRUE;		//       Z 
		}
	}
	void SetIAK2(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nIAK2mask & nID) //     
			{
				iak2_n = nData;		//      (     )
			}
			else	// -   .
			{
				iak2_n &= nData;		//    
			}
			m_nIAK2mask |= nID;	//,     
		}
		else
		{
			m_nIAK2mask &= ~nID;	//   ,  ,      
		}

		if (m_nIAK2mask == 0) //       ,
		{
			iak2_n = TRUE;		//       Z 
		}
	}
	void SetIAK3(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nIAK3mask & nID) //     
			{
				iak3_n = nData;		//      (     )
			}
			else	// -   .
			{
				iak3_n &= nData;		//    
			}
			m_nIAK3mask |= nID;	//,     
		}
		else
		{
			m_nIAK3mask &= ~nID;	//   ,  ,      
		}

		if (m_nIAK3mask == 0) //       ,
		{
			iak3_n = TRUE;		//       Z 
		}
	}
	void SetEVNT(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nEVNTmask & nID) //     
			{
				evnt_n = nData;		//      (     )
			}
			else	// -   .
			{
				evnt_n &= nData;		//    
			}
			m_nEVNTmask |= nID;	//,     
		}
		else
		{
			m_nEVNTmask &= ~nID;	//   ,  ,      
		}

		if (m_nEVNTmask == 0) //       ,
		{
			evnt_n = TRUE;		//       Z 
		}
	}
	void SetSYNC(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nSYNCmask & nID) //     
			{
				sync_n = nData;		//      (     )
			}
			else	// -   .
			{
				sync_n &= nData;		//    
			}
			m_nSYNCmask |= nID;	//,     
		}
		else
		{
			m_nSYNCmask &= ~nID;	//   ,  ,      
		}

		if (m_nSYNCmask == 0) //       ,
		{
			sync_n = TRUE;		//       Z 
		}
	}
	void SetINIT(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nINITmask & nID) //     
			{
				init_n = nData;		//      (     )
			}
			else	// -   .
			{
				init_n &= nData;		//    
			}
			m_nINITmask |= nID;	//,     
		}
		else
		{
			m_nINITmask &= ~nID;	//   ,  ,      
		}

		if (m_nINITmask == 0) //       ,
		{
			init_n = TRUE;		//       Z 
		}
	}
	void SetSACK(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nSACKmask & nID) //     
			{
				sack_n = nData;		//      (     )
			}
			else	// -   .
			{
				sack_n &= nData;		//    
			}
			m_nSACKmask |= nID;	//,     
		}
		else
		{
			m_nSACKmask &= ~nID;	//   ,  ,      
		}

		if (m_nSACKmask == 0) //       ,
		{
			sack_n = TRUE;		//       Z 
		}
	}
	void SetDMR(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nDMRmask & nID) //     
			{
				dmr_n = nData;		//      (     )
			}
			else	// -   .
			{
				dmr_n &= nData;		//    
			}
			m_nDMRmask |= nID;	//,     
		}
		else
		{
			m_nDMRmask &= ~nID;	//   ,  ,      
		}

		if (m_nDMRmask == 0) //       ,
		{
			dmr_n = TRUE;		//       Z 
		}
	}
	void SetDMGO(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nDMGOmask & nID) //     
			{
				dmgo_n = nData;		//      (     )
			}
			else	// -   .
			{
				dmgo_n &= nData;		//    
			}
			m_nDMGOmask |= nID;	//,     
		}
		else
		{
			m_nDMGOmask &= ~nID;	//   ,  ,      
		}

		if (m_nDMGOmask == 0) //       ,
		{
			dmgo_n = TRUE;		//       Z 
		}
	}
	void SetHALT(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nHALTmask & nID) //     
			{
				halt_n = nData;		//      (     )
			}
			else	// -   .
			{
				halt_n &= nData;		//    
			}
			m_nHALTmask |= nID;	//,     
		}
		else
		{
			m_nHALTmask &= ~nID;	//   ,  ,      
		}

		if (m_nHALTmask == 0) //       ,
		{
			halt_n = TRUE;		//       Z 
		}
	}
	void SetPOK(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nPOKmask & nID) //     
			{
				pok_n = nData;		//      (     )
			}
			else	// -   .
			{
				pok_n &= nData;		//    
			}
			m_nPOKmask |= nID;	//,     
		}
		else
		{
			m_nPOKmask &= ~nID;	//   ,  ,      
		}

		if (m_nPOKmask == 0) //       ,
		{
			pok_n = TRUE;		//       Z 
		}
	}
	void SetDCOK(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nDCOKmask & nID) //     
			{
				dcok_n = nData;		//      (     )
			}
			else	// -   .
			{
				dcok_n &= nData;		//    
			}
			m_nDCOKmask |= nID;	//,     
		}
		else
		{
			m_nDCOKmask &= ~nID;	//   ,  ,      
		}

		if (m_nDCOKmask == 0) //       ,
		{
			dcok_n = TRUE;		//       Z 
		}
	}
	void SetDMGI(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nDMGImask & nID) //     
			{
				dmgi_n = nData;		//      (     )
			}
			else	// -   .
			{
				dmgi_n &= nData;		//    
			}
			m_nDMGImask |= nID;	//,     
		}
		else
		{
			m_nDMGImask &= ~nID;	//   ,  ,      
		}

		if (m_nDMGImask == 0) //       ,
		{
			dmgi_n = TRUE;		//       Z 
		}
	}
	void SetBSY(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nBSYmask & nID) //     
			{
				bsy_n = nData;		//      (     )
			}
			else	// -   .
			{
				bsy_n &= nData;		//    
			}
			m_nBSYmask |= nID;	//,     
		}
		else
		{
			m_nBSYmask &= ~nID;	//   ,  ,      
		}

		if (m_nBSYmask == 0) //       ,
		{
			bsy_n = TRUE;		//       Z 
		}
	}
	void SetSEL1(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nSEL1mask & nID) //     
			{
				sel1_n = nData;		//      (     )
			}
			else	// -   .
			{
				sel1_n &= nData;		//    
			}
			m_nSEL1mask |= nID;	//,     
		}
		else
		{
			m_nSEL1mask &= ~nID;	//   ,  ,      
		}

		if (m_nSEL1mask == 0) //       ,
		{
			sel1_n = TRUE;		//       Z 
		}
	}
	void SetSEL2(DWORD nID, BOOL bEna, BOOL nData)
	{
		if (bEna)	//  
		{
			if (m_nSEL2mask & nID) //     
			{
				sel2_n = nData;		//      (     )
			}
			else	// -   .
			{
				sel2_n &= nData;		//    
			}
			m_nSEL2mask |= nID;	//,     
		}
		else
		{
			m_nSEL2mask &= ~nID;	//   ,  ,      
		}

		if (m_nSEL2mask == 0) //       ,
		{
			sel2_n = TRUE;		//       Z 
		}
	}
};
