#pragma once

//test board
#include "..\vm1cpu\vm1.h"
#include "qbus_memory.h"
#include "qbus_irps.h"

#define OUT_VM1PIN_DBG_LOG 1
#undef OUT_VM1PIN_DBG_LOG

class tboard
{
	MPI			*m_pMPI;	// 
	C1801VM1	*m_pCPU;
	QBUS_Memory *m_pMemory;
	QBUS_IRPS	*m_pIRPS;
#ifdef OUT_VM1PIN_DBG_LOG
	FILE		*m_pLog;
#endif
	int			m_nClk;		// ,  
public:
	tboard();
	~tboard();
	void AttachDebugger(CDebugger *pDbg) 
	{ 
		m_pCPU->AttachDebugger(pDbg);
		m_pMemory->AttachDebugger(pDbg);
	}
	BOOL init();
#ifdef OUT_VM1PIN_DBG_LOG
	void OutLog( const char *str = "  " );
#endif
	void cpu_start();
	void maincycle();

};

