#include "stdafx.h"
#include "tboard.h"


tboard::tboard()
	: m_pMPI(NULL)
	, m_pCPU(NULL)
	, m_pMemory(NULL)
	, m_pIRPS(NULL)
#ifdef OUT_VM1PIN_DBG_LOG
	, m_pLog(NULL)
#endif
	, m_nClk(0)
{
}

BOOL tboard::init()
{
#ifdef OUT_VM1PIN_DBG_LOG
	m_pLog = fopen("_vm1pin_log.txt", "wt");
//	fprintf(m_pLog, "   clk    ad      bsy wtbt sync  din dout rply init dclo aclo irq1 irq2 irq3 virq  dmr sack dmgi dmgo iako   sp sel1 sel2  ena   pa\n");
	fclose(m_pLog);
#endif
	m_pMPI = new MPI();
	if (m_pMPI)
	{
		m_pMPI->clear();

		//  
		m_pCPU = new C1801VM1();
		if (m_pCPU)
		{
			m_pCPU->m_IOPins.pin_pa_n = -1;
			m_pCPU->m_IOPins.pin_sp_n = TRUE;
			m_pCPU->m_IOPins.pin_ena = FALSE;
			m_pCPU->RegisterDevice(m_pMPI);
			m_pMemory = new QBUS_Memory();
			if (m_pMemory)
			{
				m_pMemory->RegisterDevice(m_pMPI);
				m_pIRPS = new QBUS_IRPS();
				if (m_pIRPS)
				{
					m_pIRPS->RegisterDevice(m_pMPI);
					return TRUE;
				}
			}
		}
	}
	return FALSE;
}
tboard::~tboard()
{
	if (m_pMPI)
	{
		delete m_pMPI;
	}
	if (m_pCPU)
	{
		delete m_pCPU;
	}
	if (m_pMemory)
	{
		delete m_pMemory;
	}
	if (m_pIRPS)
	{
		delete m_pIRPS;
	}
#ifdef OUT_VM1PIN_DBG_LOG
//	fclose(m_pLog);
#endif
}

void tboard::cpu_start()
{
	m_pMPI->dcok_n = FALSE;
	m_pMPI->pok_n = FALSE;
	m_pMPI->init_n = FALSE;

	//  
	m_nClk = 0;
	maincycle();
	maincycle();
	maincycle();
	maincycle();
	m_pMPI->dcok_n = TRUE;
	maincycle();
	maincycle();
	maincycle();
	maincycle();
	maincycle();
	maincycle();
	maincycle();
	maincycle();
	m_pMPI->pok_n = TRUE;
	m_pMPI->init_n = TRUE;
	maincycle();
	maincycle();
	maincycle();
	maincycle();
	maincycle();
	maincycle();
	maincycle();
	maincycle();
}

static bool bPrev_rply_n = true;

void tboard::maincycle()
{
	bool b_rply_n  = m_pMPI->rply_n;
	m_pMPI->rply_n = bPrev_rply_n;

#ifdef OUT_VM1PIN_DBG_LOG
	OutLog(" >");
#endif

	m_pCPU->eval_n(m_nClk, m_pMPI); //   

#ifdef OUT_VM1PIN_DBG_LOG
	OutLog(" <");
#endif

	m_pMPI->rply_n = ( m_pCPU->m_IOPins.pin_rply_n ? b_rply_n : false );

//	m_pMemory->eval(m_pMPI);
//	m_pIRPS->eval(m_pMPI);

#ifdef OUT_VM1PIN_DBG_LOG
	OutLog("p>");
#endif

	m_pCPU->eval_p(m_nClk, m_pMPI); //   

	bPrev_rply_n = m_pMPI->rply_n;

#ifdef OUT_VM1PIN_DBG_LOG
	OutLog("p<");
#endif

	m_pMemory->eval(m_pMPI);
	m_pIRPS->eval(m_pMPI);

	m_nClk++;
/*
  V- ,      P-,   N-,     *eval_p*,   *eval_n*.
      -  ,             CLK      - .. N-
 V-               *eval_p*  *eval_n* -   SYNC  DIN            .
*/
}
#ifdef OUT_VM1PIN_DBG_LOG
void tboard::OutLog( const char *str )
{
	static int nCount = 0;

	m_pLog = fopen("_vm1pin_log.txt", "a");

	if( !((nCount++)%20) )
	{
		fprintf(m_pLog, "   clk    ad      bsy wtbt sync  din dout rply init dclo aclo irq1 irq2 irq3 virq  dmr sack dmgi dmgo iako   sp sel1 sel2  ena   pa\n");
	}

	//    .   .      ,  0.
	fprintf(m_pLog, "%s %06d", str, m_nClk);
	fprintf(m_pLog, " %06o",  (~m_pCPU->m_IOPins.pin_ad_n & 0xffff));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_bsy_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_wtbt_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_sync_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_din_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_dout_n ? 0 : 1));
//	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_rply_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pMPI->rply_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_init_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_dclo_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_aclo_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_irq1_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_irq2_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_irq3_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_virq_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_dmr_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_sack_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_dmgi_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_dmgo_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_iako_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_sp_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_sel1_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_sel2_n ? 0 : 1));
	fprintf(m_pLog, "    %d", ( m_pCPU->m_IOPins.pin_ena ? 0 : 1));
	fprintf(m_pLog, "    %d", (~m_pCPU->m_IOPins.pin_pa_n & 3));
	fprintf(m_pLog, "\n");
	fclose(m_pLog);
}
#endif
