#pragma once
#include "qbus_device.h"

#define MEM_SIZE_B 0172000

class QBUS_Memory : public QBUS_Device
{
	friend class CDebugger;

	//  
	union {
		WORD m_memw[MEM_SIZE_B / 2];
		BYTE m_memb[MEM_SIZE_B];
	};

	BOOL m_abReadAccess[64 * 1024];

	/*  
	:	TRUE -   
			FALSE -  
	*/
	virtual BOOL DecodeAddr();
	virtual BOOL WriteOp(); //    
	virtual BOOL ReadOp(); //    
	virtual BOOL InitOp(){ return TRUE; } // , ..  
public:
	QBUS_Memory();
	virtual ~QBUS_Memory();
	void AttachDebugger(CDebugger *pDbg);
};

