#include "stdafx.h"
#include "qbus_memory.h"

#include "..\Debugger.h"

QBUS_Memory::QBUS_Memory() : QBUS_Device()
{
	memset(m_memb, 0, MEM_SIZE_B);

	for (int i = 0; i < 64 * 1024; ++i)
	{
		m_abReadAccess[i] = (i < MEM_SIZE_B) ? TRUE : FALSE;
	}
	for (int i = 0177560; i < 0177570; ++i)
	{
		m_abReadAccess[i] = TRUE;
	}
	for (int i = 0177700; i < 0177717; ++i)
	{
		m_abReadAccess[i] = TRUE;
	}

	FILE *f; //-    .    .
//	if (f = fopen("7test1.bin", "rb"))
//	if (f = fopen("791401.bin", "rb"))
//	if (f = fopen("791404.bin", "rb"))
	if (f = fopen("test.bin", "rb"))
	{
		fread(m_memb, 1, MEM_SIZE_B, f);
		fclose(f);
	}
	else
	{
		ASSERT(FALSE);
	}
}


QBUS_Memory::~QBUS_Memory()
{
}
void QBUS_Memory::AttachDebugger(CDebugger *pDbg)
{
	pDbg->AttachMemory(m_memb, m_abReadAccess); 
}

BOOL QBUS_Memory::DecodeAddr()
{
	//TRACE1("MEM Request: %06o\n", m_IOPins.pin_ad);
	return ((m_IOPins.pin_ad < MEM_SIZE_B) || (m_IOPins.pin_ad == 0177716));
}

BOOL QBUS_Memory::ReadOp()
{
	//TRACE1("MEM Read: %06o\n", nAddr);
	if (m_nAddr == 0177716)
	{
		m_IOPins.pin_ad = 0200; //200,      .     0.
	}
	else
	{
		m_IOPins.pin_ad = m_memw[m_nAddr >> 1];
	}
/*
FILE *Log = fopen("_vm1pin_log.txt", "a");
fprintf(Log, "MEM Read:: addr: %06o ; data: %06o\n", m_nAddr, m_IOPins.pin_ad );
fclose(Log);
//*/
	return TRUE;
}

BOOL QBUS_Memory::WriteOp()
{
	//TRACE1("MEM Write: %06o\n", nAddr);

	if (m_nAddr == 0177716) //   
	{
		return TRUE;
	}

	if (m_IOPins.pin_wtbt)
	{
		if (m_nAddr & 1)
		{
			m_memb[m_nAddr] = HIBYTE(m_IOPins.pin_ad);
		}
		else
		{
			m_memb[m_nAddr] = LOBYTE(m_IOPins.pin_ad);
		}
	}
	else
	{
		m_memw[m_nAddr >> 1] = m_IOPins.pin_ad;
	}

	return TRUE;
}
