#pragma once
#include "qbus_device.h"
class QBUS_IRPS :
	public QBUS_Device
{
	BOOL m_bTTY_TXRdy;	// terminal transmitter ready
	BOOL m_bTTY_RXRdy;	// terminal receiver ready
	BOOL m_bTTY_TXIntrEna, m_bTTY_TXIntrEna_prev;		// terminal transmitter interrupt enable
	BOOL m_bTTY_RXIntrEna, m_bTTY_RXIntrEna_prev;		// terminal receiver interrupt enable
	BOOL m_bTTY_RXVirq;
	BOOL m_bTTY_TXVirq;
	BYTE m_chRXData, m_chTXData;

	BOOL m_bConsole;
protected:
	enum QBUSDEV_VIRQ_STATE
	{
		VIRQSTATE_NONE = 0, //  -   
		VIRQSTATE_PRESETVIRQ,
		VIRQSTATE_SETVIRQ,
		VIRQSTATE_WAIT_IAKO,
		VIRQSTATE_WAIT_ENDCYCLE,
		VIRQSTATE_SETRPLY,
		VIRQSTATE_CLRVIRQ,
		VIRQSTATE_WAIT_IAKOCLR,
		VIRQSTATE_FINAL

	};
	QBUSDEV_VIRQ_STATE m_nVirqState;
	int m_nVirqDelay;
	int m_nRXRdyDelay;

	virtual BOOL DecodeAddr();
	virtual BOOL WriteOp(); //    
	virtual BOOL ReadOp(); //    
	virtual BOOL InitOp();

	void VIRQ_FSM();	//    

	HANDLE		m_hStartingInputEvent; //, ,   
	HANDLE		m_hStopInputEvent;	//,     
	HANDLE		m_hInputEventTrigger;

	HANDLE		m_hStartingOutputEvent; //, ,   
	HANDLE		m_hStopOutputEvent;	//,     
	HANDLE		m_hOutputEventTrigger;

	// -
	static UINT AFX_CDECL InputThreadWrapper(LPVOID lpParam);
	UINT			 InputThreadFunc();		// 
	CWinThread		*m_pInputThread;
	static UINT AFX_CDECL OutputThreadWrapper(LPVOID lpParam);
	UINT			 OutputThreadFunc();		// 
	CWinThread		*m_pOutputThread;
	BOOL StartInputThread();
	void StopInputThread();
	BOOL StartOutputThread();
	void StopOutputThread();

public:
	QBUS_IRPS();
	virtual ~QBUS_IRPS();
	virtual void eval(MPI *pMPI);
};

