#include "stdafx.h"
#include "qbus_irps.h"
#include <fcntl.h>
#include <io.h>
#include <iostream>

QBUS_IRPS::QBUS_IRPS()
{
	InitOp();

	if (AllocConsole())
	{
		int hCrt = _open_osfhandle((long)GetStdHandle(STD_OUTPUT_HANDLE), 4);
		*stdout = *(::_fdopen(hCrt, "w"));
		::setvbuf(stdout, NULL, _IONBF, 0);
		*stderr = *(::_fdopen(hCrt, "w"));
		::setvbuf(stderr, NULL, _IONBF, 0);
		std::ios::sync_with_stdio();
		m_bConsole = TRUE;
	}
	else
	{
		m_bConsole = FALSE;
	}

	m_hStartingInputEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hStopInputEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hInputEventTrigger = CreateEvent(NULL, TRUE, FALSE, NULL);

	m_hStartingOutputEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hStopOutputEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	m_hOutputEventTrigger = CreateEvent(NULL, TRUE, FALSE, NULL);
	StartInputThread();
	StartOutputThread();
}


QBUS_IRPS::~QBUS_IRPS()
{
	if (m_bConsole)
	{
		FreeConsole();
	}
	StopInputThread();
	StopOutputThread();

	if (m_hStartingInputEvent)
	{
		CloseHandle(m_hStartingInputEvent);
	}
	if (m_hStopInputEvent)
	{
		CloseHandle(m_hStopInputEvent);
	}
	if (m_hInputEventTrigger)
	{
		CloseHandle(m_hInputEventTrigger);
	}

	if (m_hStartingOutputEvent)
	{
		CloseHandle(m_hStartingOutputEvent);
	}
	if (m_hStopOutputEvent)
	{
		CloseHandle(m_hStopOutputEvent);
	}
	if (m_hOutputEventTrigger)
	{
		CloseHandle(m_hOutputEventTrigger);
	}
}

UINT AFX_CDECL QBUS_IRPS::InputThreadWrapper(LPVOID lpParam)
{
	QBUS_IRPS *pThis = reinterpret_cast<QBUS_IRPS *>(lpParam);
	return pThis->InputThreadFunc();
}

UINT QBUS_IRPS::InputThreadFunc()
{
	SetEvent(m_hStartingInputEvent); //   
	while (1)
	{
		WaitForSingleObject(m_hInputEventTrigger, INFINITE); // 
		if (WAIT_OBJECT_0 == WaitForSingleObject(m_hStopInputEvent, 0)) //      
		{
			break;
		}
		std::cin >> m_chRXData;
		Sleep(20);
		m_bTTY_RXRdy = TRUE;
		ResetEvent(m_hInputEventTrigger);
	}
	ResetEvent(m_hStartingInputEvent);
	return 0;
}

UINT AFX_CDECL QBUS_IRPS::OutputThreadWrapper(LPVOID lpParam)
{
	QBUS_IRPS *pThis = reinterpret_cast<QBUS_IRPS *>(lpParam);
	return pThis->OutputThreadFunc();
}
UINT QBUS_IRPS::OutputThreadFunc()
{
	SetEvent(m_hStartingOutputEvent); //   
	while (1)
	{
		WaitForSingleObject(m_hOutputEventTrigger, INFINITE);	//    
		if (WAIT_OBJECT_0 == WaitForSingleObject(m_hStopOutputEvent, 0)) //     - 
		{
			break;
		}
		std::cout << m_chTXData;
		Sleep(20);
//		m_bTTY_TXRdy = TRUE;
//		m_bTTY_TXVirq = (m_bTTY_TXRdy && m_bTTY_TXIntrEna);
		ResetEvent(m_hOutputEventTrigger);
	}

	ResetEvent(m_hStartingOutputEvent);
	return 0;
}
BOOL QBUS_IRPS::StartInputThread()
{
	if ((m_pInputThread = AfxBeginThread(
		InputThreadWrapper,
		(void *)this,
		THREAD_PRIORITY_NORMAL)
		) == NULL)
	{
		AfxMessageBox(_T("    ."), MB_OK);
		return FALSE;
	}

	return TRUE;
}
void QBUS_IRPS::StopInputThread()
{
	if (WAIT_OBJECT_0 == WaitForSingleObject(m_hStartingInputEvent, 0))
	{
		SetEvent(m_hStopInputEvent);		//   
		SetEvent(m_hInputEventTrigger);
		int nInterval = 500;

		while (WAIT_OBJECT_0 == WaitForSingleObject(m_hStartingInputEvent, 0)) //  
		{
			Sleep(10);
			// -  ,    
			if (--nInterval < 0) //  3.        
			{
				//m_pWorkerThread->ExitInstance();
				break; //  .
			}
		}
		ResetEvent(m_hStopInputEvent);
	}
}

BOOL QBUS_IRPS::StartOutputThread()
{
	if ((m_pOutputThread = AfxBeginThread(
		OutputThreadWrapper,
		(void *)this,
		THREAD_PRIORITY_NORMAL)
		) == NULL)
	{
		AfxMessageBox(_T("    ."), MB_OK);
		return FALSE;
	}

	return TRUE;
}
void QBUS_IRPS::StopOutputThread()
{
	if (WAIT_OBJECT_0 == WaitForSingleObject(m_hStartingOutputEvent, 0))
	{
		SetEvent(m_hStopOutputEvent);		//   
		SetEvent(m_hOutputEventTrigger);
		int nInterval = 500;

		while (WAIT_OBJECT_0 == WaitForSingleObject(m_hStartingOutputEvent, 0)) //  
		{
			Sleep(10);
			// -  ,    
			if (--nInterval < 0) //  3.        
			{
				//m_pWorkerThread->ExitInstance();
				break; //  .
			}
		}
		ResetEvent(m_hStopOutputEvent);
	}

}

BOOL QBUS_IRPS::InitOp()
{
	m_bTTY_TXRdy = TRUE;
	m_bTTY_RXRdy = FALSE;
	m_bTTY_TXIntrEna_prev = FALSE;
	m_bTTY_RXIntrEna_prev = FALSE;
	m_bTTY_TXIntrEna = FALSE;
	m_bTTY_RXIntrEna = FALSE;
	m_bTTY_RXVirq = FALSE;
	m_bTTY_TXVirq = FALSE;
	m_chTXData = 0;
	m_chRXData = 0;
	m_nVirqState = VIRQSTATE_NONE;

	m_bPinVirqZ = FALSE;
	m_bPinRplyEnaZ = FALSE;
	m_bPinAdEnaZ = FALSE;
	m_bIakiTranslate = TRUE;

	m_nRXRdyDelay = 0;

	return TRUE;
}

BOOL QBUS_IRPS::DecodeAddr()
{
	switch (m_IOPins.pin_ad)
	{
	case 0177560:
	case 0177562:
	case 0177564:
	case 0177566:
		return TRUE;
	}
	return FALSE;
}

BOOL QBUS_IRPS::ReadOp()
{
	switch (m_nAddr)
	{
	case 0177560:
		m_IOPins.pin_ad = (m_bTTY_RXRdy ? 0200 : 0) | (m_bTTY_RXIntrEna ? 0100 : 0);
		break;
	case 0177562:
		m_bTTY_RXRdy = FALSE;
		SetEvent(m_hInputEventTrigger);
		while (WAIT_OBJECT_0 == WaitForSingleObject(m_hInputEventTrigger, 0)) Sleep(10);
		m_bTTY_RXVirq = (m_bTTY_RXRdy && m_bTTY_RXIntrEna);
		m_IOPins.pin_ad = m_chRXData & 0377;
		break;
	case 0177564:
		m_IOPins.pin_ad = (m_bTTY_TXRdy ? 0200 : 0) | (m_bTTY_TXIntrEna ? 0100 : 0);
		break;
	case 0177566:
		m_IOPins.pin_ad = 060;
		break;
	}
	return TRUE;
}

BOOL QBUS_IRPS::WriteOp()
{
	switch (m_nAddr)
	{
	case 0177560:
		m_bTTY_RXIntrEna_prev = m_bTTY_RXIntrEna;
		m_bTTY_RXIntrEna = (m_IOPins.pin_ad & 0100) == 0100;
		if( m_bTTY_RXRdy )
		{
			m_bTTY_RXVirq = (m_bTTY_RXIntrEna_prev == FALSE && m_bTTY_RXIntrEna == TRUE);
		}
		break;
	case 0177562:
		// 
		break;
	case 0177564:
		m_bTTY_TXIntrEna_prev = m_bTTY_TXIntrEna;
		m_bTTY_TXIntrEna = (m_IOPins.pin_ad & 0100) == 0100;
//		m_bTTY_TXVirq = (m_bTTY_TXIntrEna_prev == FALSE && m_bTTY_TXIntrEna == TRUE);

		if( m_bTTY_TXRdy && ( m_bTTY_TXIntrEna_prev != m_bTTY_TXIntrEna ) )
		{
			m_bTTY_TXVirq = m_bTTY_TXIntrEna;
		}
		break;
	case 0177566:
		if( m_bTTY_TXRdy )
		{
			m_bTTY_TXRdy = FALSE;
			m_bTTY_TXVirq = FALSE;
			m_nRXRdyDelay = 400/2;
//			m_nRXRdyDelay = 400;
		}
		while (WAIT_OBJECT_0 == WaitForSingleObject(m_hOutputEventTrigger, 0)) Sleep(10); //   
		m_chTXData = LOBYTE(m_IOPins.pin_ad);
		SetEvent(m_hOutputEventTrigger);	//     
		break;
	}
	return TRUE;
}

void QBUS_IRPS::VIRQ_FSM()
{
	if( --m_nRXRdyDelay == 0 )
	{
		m_bTTY_TXRdy = TRUE;
		m_bTTY_TXVirq = m_bTTY_TXIntrEna;
	}
	else
	if( m_nRXRdyDelay < 0 )
	{
		m_nRXRdyDelay = 0;
	}


	switch (m_nVirqState)
	{
	case VIRQSTATE_NONE:
	{
		if( m_bTTY_RXVirq || m_bTTY_TXVirq )
		{
			m_nVirqState = VIRQSTATE_SETVIRQ;

//			m_nVirqState = VIRQSTATE_PRESETVIRQ;
//			m_nVirqDelay = 138/2; //
//			m_nVirqDelay = 138; //
		}

		if (m_bIakiTranslate) //  IAKO      
		{
			m_IOPins.pin_iaki = m_IOPins.pin_iako; // 
		}
		else
		{
			m_IOPins.pin_iaki = FALSE;
		}
		break; //  
	}
	case VIRQSTATE_PRESETVIRQ:
	{
		if (--m_nVirqDelay <= 0)
		{
			m_nVirqState = VIRQSTATE_SETVIRQ;
		}
		break;
	}
	case VIRQSTATE_SETVIRQ:
	{
		m_bPinVirqZ = TRUE;
		m_IOPins.pin_virq = TRUE;
		m_bIakiTranslate = FALSE;
		m_nVirqState = VIRQSTATE_WAIT_IAKO;
		break;
	}
	case VIRQSTATE_WAIT_IAKO: //  
	{
		if (m_IOPins.pin_iako) //
		{
			m_nVirqState = VIRQSTATE_WAIT_ENDCYCLE;
		}
		break;
	}
	case VIRQSTATE_WAIT_ENDCYCLE:
	{
		if (m_nState == MEMSTATE_WAIT_SYNC_SET) //      
		{
			m_nVirqState = VIRQSTATE_SETRPLY;
			m_nRplyDelay = 0;
//			m_nRplyDelay = 3;
		}
		break;
	}
	case VIRQSTATE_SETRPLY:
	{
		if( --m_nRplyDelay >= 0 )
		{
			break;
		}

		m_bPinRplyEnaZ = TRUE;
		m_IOPins.pin_rply = TRUE;	//  RPLY
		m_bPinAdEnaZ = TRUE;
		m_IOPins.pin_ad = m_bTTY_RXVirq ? 060 : (m_bTTY_TXVirq ? 064 : 0); // 
		m_nVirqState = VIRQSTATE_CLRVIRQ;
		break;
	}
	case VIRQSTATE_CLRVIRQ:
	{
		m_IOPins.pin_virq = FALSE;
		m_nVirqState = VIRQSTATE_WAIT_IAKOCLR;
		m_nRplyDelay = 0;
//		m_nRplyDelay = 1;
		break;
	}
	case VIRQSTATE_WAIT_IAKOCLR:
	{
		if (!m_IOPins.pin_iako)
		{
			if( --m_nRplyDelay >= 0 )
			{
				break;
			}

			m_IOPins.pin_rply = FALSE;
			m_IOPins.pin_ad = 0;
			m_nVirqState = VIRQSTATE_FINAL;
		}
		break;
	}
	case VIRQSTATE_FINAL: //    
	{
		m_bPinVirqZ = FALSE;
		m_bPinRplyEnaZ = FALSE;
		m_bPinAdEnaZ = FALSE;
		m_bIakiTranslate = TRUE;
		m_nVirqState = VIRQSTATE_NONE;

		if (m_bTTY_RXVirq)
		{
			m_bTTY_RXVirq = FALSE;
		}
		else if (m_bTTY_TXVirq)
		{
			m_bTTY_TXVirq = FALSE;
		}
		break;
	}
	}
}

void QBUS_IRPS::eval(MPI *pMPI)
{
	getMPI(pMPI);
	if (m_IOPins.pin_init)
	{
		InitOp();
	}
	else
	{
		IO_FSM();
		VIRQ_FSM();
	}
	setMPI(pMPI);
}

