#pragma once
#include "..\vm1cpu\defmacros.h"

//input-output
struct QBUSDEV_IO
{
	WORD pin_ad;  		//inout[15:0]	// inverted address/data bus
	BOOL pin_dout;		//input			// data output strobe
	BOOL pin_din; 		//input			// data input strobe
	BOOL pin_wtbt;		//input			// write/byte status
	BOOL pin_sync;		//input			// address strobe
	BOOL pin_rply;		//output		// transaction reply
	BOOL pin_init;		//input
	BOOL pin_virq;		//output   
	BOOL pin_iako;		//input   
	BOOL pin_iaki;		//output    ,      
						//   ,     .
	void clear()
	{
		memset(this, 0, sizeof(QBUSDEV_IO));
	};
};

class QBUS_Device
{
protected:
	enum QBUSDEV_STATE {
		MEMSTATE_WAIT_SYNC_SET = 0,
		MEMSTATE_WAIT_DIN_DOUT,
		MEMSTATE_SET_DIN_RPLY,
		MEMSTATE_SET_MPI_DATA,
		MEMSTATE_WAIT_DIN_CLR,
		MEMSTATE_CLR_DIN_RPLY,
		MEMSTATE_WAIT_SYNC_CLR_DIN,
		MEMSTATE_WAIT_SYNC_CLR,
		MEMSTATE_GET_MPI_DATA,
		MEMSTATE_SET_DOUT_RPLY,
		MEMSTATE_WAIT_DOUT_CLR,
		MEMSTATE_CLR_DOUT_RPLY,
	};
	DWORD m_nDeviceID;

	// 
	QBUSDEV_STATE	m_nState;		//   
	WORD			m_nAddr;		//   
	BOOL			m_bPinAdEnaZ;	//    
	BOOL			m_bPinRplyEnaZ; //    
	BOOL			m_bPinVirqZ;	//     
	BOOL			m_bIakiTranslate;

	bool            bAddr_OK;

	int				m_nRplyDelay;
	void setMPI(MPI *pMPI); //  Mem -> MPI
	void getMPI(MPI *pMPI); //  MPI -> Mem
	void IO_FSM();	//       

	/*  
	:	TRUE -   
			FALSE -  
	*/
	virtual BOOL DecodeAddr() = NULL;
	virtual BOOL WriteOp() = NULL; //    
	virtual BOOL ReadOp() = NULL; //    
	virtual BOOL InitOp() = NULL; // 

public:
	QBUSDEV_IO m_IOPins;	// - .

	QBUS_Device();
	virtual ~QBUS_Device();
	virtual void eval(MPI *pMPI);
	virtual void RegisterDevice(MPI *pMPI);

};

