#include "stdafx.h"
#include "qbus_device.h"

QBUS_Device::QBUS_Device()
	: m_nState(MEMSTATE_WAIT_SYNC_SET)
	, m_nAddr(0)
	, m_bPinAdEnaZ(FALSE)
	, m_bPinRplyEnaZ(FALSE)
	, m_bPinVirqZ(FALSE)
	, m_bIakiTranslate(TRUE)
	, m_nRplyDelay(0)
	, bAddr_OK(false)
{
	m_IOPins.clear();
}


QBUS_Device::~QBUS_Device()
{
}

void QBUS_Device::RegisterDevice(MPI *pMPI)
{
	m_nDeviceID = pMPI->RegisterDevice();
	ASSERT(m_nDeviceID != -1);
}

void QBUS_Device::setMPI(MPI *pMPI) //  Mem -> MPI
{
	pMPI->SetAD(m_nDeviceID, m_bPinAdEnaZ, ~m_IOPins.pin_ad);
	pMPI->SetRPLY(m_nDeviceID, m_bPinRplyEnaZ, !m_IOPins.pin_rply);	//output		// transaction reply
	pMPI->SetVIRQ(m_nDeviceID, m_bPinVirqZ, !m_IOPins.pin_virq);

	//pMPI->iak0_n = !m_IOPins.pin_iaki; // , ,         .
}

void QBUS_Device::getMPI(MPI *pMPI) //  MPI -> Mem
{
	m_IOPins.pin_ad		= ~pMPI->ad_n;		//inout[15:0]	// inverted address/data bus
	m_IOPins.pin_dout	= !pMPI->dout_n;	//input			// data output strobe
	m_IOPins.pin_din	= !pMPI->din_n; 	//input			// data input strobe
	m_IOPins.pin_wtbt	= !pMPI->wtbt_n;	//input			// write/byte status
	m_IOPins.pin_sync	= !pMPI->sync_n;	//input			// address strobe
	m_IOPins.pin_init	= !pMPI->init_n;
	m_IOPins.pin_iako	= !pMPI->iak0_n;
}

void QBUS_Device::IO_FSM()
{
	switch (m_nState)
	{
	case MEMSTATE_WAIT_SYNC_SET:	//   SYNC,     
	{
		if (m_IOPins.pin_sync)		//
		{
//			if (DecodeAddr()) // ,   
			if( bAddr_OK )
			{
//				m_nAddr = m_IOPins.pin_ad;	// 
				m_nState = MEMSTATE_WAIT_DIN_DOUT; //   
			}
			else
			{
				//   ,   ,   
				m_nState = MEMSTATE_WAIT_SYNC_CLR;
			}
		}
		else
		{
			bAddr_OK = DecodeAddr();
			m_nAddr = m_IOPins.pin_ad;	// 
		}
		break;
	}
	case MEMSTATE_WAIT_DIN_DOUT: //    DIN  DOUT
	{
		if (m_IOPins.pin_din)	// DIN
		{
			m_nState = MEMSTATE_SET_DIN_RPLY;	//   
			m_nRplyDelay = 0;
//			m_nRplyDelay = 4;
		}
		else if (m_IOPins.pin_dout)	// DOUT
		{
			m_nState = MEMSTATE_GET_MPI_DATA;	//   
		}
		break;
	}
	case MEMSTATE_SET_DIN_RPLY:	//   DIN,  RPLY
	{
		if( --m_nRplyDelay >= 0 )
		{
			break;
		}

		if( m_nAddr != 0177716 )
		{
			m_bPinRplyEnaZ = TRUE;
			m_IOPins.pin_rply = TRUE;	// 
		}
//		m_nState = MEMSTATE_SET_MPI_DATA;
//		break;
//	}
//	case MEMSTATE_SET_MPI_DATA: //   DIN,   RPLY,  
//	{
		m_bPinAdEnaZ = TRUE;
		ReadOp();
		m_nState = MEMSTATE_WAIT_DIN_CLR;
		break;
	}
	case MEMSTATE_WAIT_DIN_CLR: //  DIN
	{
		if (!m_IOPins.pin_din)
		{
			m_nRplyDelay = 0;
//			m_nRplyDelay = 2;
			m_nState = MEMSTATE_CLR_DIN_RPLY;
		}
		break;
	}
	case MEMSTATE_CLR_DIN_RPLY: //    DIN  RPLY  ad
	{
		if (--m_nRplyDelay < 0)
		{
			m_IOPins.pin_rply = FALSE;
			m_IOPins.pin_ad = 0;
			m_bPinAdEnaZ = FALSE;
			m_nState = MEMSTATE_WAIT_SYNC_CLR_DIN;
		}
		break;
	}
	case MEMSTATE_WAIT_SYNC_CLR_DIN: //  SYNC,   
	{
		if (!m_IOPins.pin_sync)
		{
			m_bPinRplyEnaZ = FALSE; // 
			m_nState = MEMSTATE_WAIT_SYNC_SET; //   

			bAddr_OK = DecodeAddr();
			m_nAddr = m_IOPins.pin_ad;	// 
		}
		else if (m_IOPins.pin_dout) //   SYNC   DOUT -    --
		{
			m_nState = MEMSTATE_GET_MPI_DATA;	//   
		}
		break;
	}
	case MEMSTATE_WAIT_SYNC_CLR: //  SYNC,   
	{
		if (!m_IOPins.pin_sync)
		{
			m_bPinRplyEnaZ = FALSE; // 
			m_bPinAdEnaZ = FALSE;
			m_nState = MEMSTATE_WAIT_SYNC_SET; //   

			bAddr_OK = DecodeAddr();
			m_nAddr = m_IOPins.pin_ad;	// 
		}
		break;
	}
	case MEMSTATE_GET_MPI_DATA: // DOUT   
	{
		WriteOp();
		m_nState = MEMSTATE_SET_DOUT_RPLY; //   RPLY
		m_nRplyDelay = 0;
//		m_nRplyDelay = 4;
		break;
	}
	case MEMSTATE_SET_DOUT_RPLY: // RPLY    DOUT
	{
		if( --m_nRplyDelay >= 0 )
		{
			break;
		}
		m_bPinRplyEnaZ = TRUE;
		m_IOPins.pin_rply = TRUE;
		m_nState = MEMSTATE_WAIT_DOUT_CLR;
		break;
	}
	case MEMSTATE_WAIT_DOUT_CLR: //  DOUT
	{
		if (!m_IOPins.pin_dout)
		{
			m_nState = MEMSTATE_CLR_DOUT_RPLY;
			m_nRplyDelay = 0;
//			m_nRplyDelay = 2;
		}
		break;
	}
	case MEMSTATE_CLR_DOUT_RPLY:	//    DOUT  RPLY
	{
		if( --m_nRplyDelay >= 0 )
		{
			break;
		}

		m_IOPins.pin_rply = FALSE;
		m_nState = MEMSTATE_WAIT_SYNC_CLR;
		break;
	}
	}
}

void QBUS_Device::eval(MPI *pMPI)
{
	getMPI(pMPI);
	if (m_IOPins.pin_init)
	{
		InitOp();
	}
	else
	{
		IO_FSM();
	}
	setMPI(pMPI);
}

