// rev 0.03
// VM1CPPDlg.cpp :  
//

#include "stdafx.h"
#include "VM1CPP.h"
#include "VM1CPPDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


//   CAboutDlg      

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

//   
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    //  DDX/DDV

// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


//   CVM1CPPDlg

static UINT nIDCID[14] =
{
	IDC_EDIT_DBG_R0, IDC_EDIT_DBG_R1, IDC_EDIT_DBG_R2, IDC_EDIT_DBG_R3,
	IDC_EDIT_DBG_R4, IDC_EDIT_DBG_R5, IDC_EDIT_DBG_SP, IDC_EDIT_DBG_PC,
	IDC_EDIT_DBG_R8, IDC_EDIT_DBG_R9, IDC_EDIT_DBG_R10, IDC_EDIT_DBG_R11,
	IDC_EDIT_DBG_R12, IDC_EDIT_DBG_R13
};

CVM1CPPDlg::CVM1CPPDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVM1CPPDlg::IDD, pParent)
	, m_hStartingEvent(NULL)
	, m_hPauseEvent(NULL)
	, m_hStopEvent(NULL)
	, m_pWorkerThread(NULL)
	, m_bPause(FALSE)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVM1CPPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

	DDX_Check(pDX, IDC_CHECK_PAUSE, m_bPause);
}

BEGIN_MESSAGE_MAP(CVM1CPPDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_START, &CVM1CPPDlg::OnBnClickedButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, &CVM1CPPDlg::OnBnClickedButtonStop)
	ON_BN_CLICKED(IDC_CHECK_PAUSE, &CVM1CPPDlg::OnBnClickedCheckPause)
	ON_WM_DESTROY()
	ON_MESSAGE(WM_ONWORKED_THREAD_STOPPED, &CVM1CPPDlg::OnWorkedThreadStopped)
END_MESSAGE_MAP()


//   CVM1CPPDlg

BOOL CVM1CPPDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	//   " ..."   .

	// IDM_ABOUTBOX      .
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	//      .     ,
	//        
	SetIcon(m_hIcon, TRUE);			//  
	SetIcon(m_hIcon, FALSE);		//  

	// TODO:   

	LOGFONT lf;
	::GetObject((HGDIOBJ)::SendMessage(GetSafeHwnd(), WM_GETFONT, 0, 0), sizeof(LOGFONT), &lf);
	_tcscpy_s(lf.lfFaceName, LF_FACESIZE, _T("Courier New\0"));

	if (hFont.CreateFontIndirect(&lf) == NULL)
	{
		_tcscpy_s(lf.lfFaceName, LF_FACESIZE, _T("Lucida Console\0"));
		hFont.CreateFontIndirect(&lf);
	}

	for (int i = 0; i < 14; ++i)
	{
		GetDlgItem(nIDCID[i])->SetFont(&hFont);
	}
	GetDlgItem(IDC_EDIT_DBG_PSW)->SetFont(&hFont);
	GetDlgItem(IDC_EDIT_DBG_Q)->SetFont(&hFont);
	GetDlgItem(IDC_EDIT_PLM)->SetFont(&hFont);
	GetDlgItem(IDC_EDIT_PLI)->SetFont(&hFont);

	//GetDlgItem(IDC_BUTTON_START)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK_PAUSE)->EnableWindow(FALSE);
	GetDlgItem(IDC_BUTTON_STOP)->EnableWindow(FALSE);

	m_hStartingEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	if (!m_hStartingEvent)
	{
		MessageBox(_T("   event StartingEvent."), MB_OK);
	}
	m_hPauseEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	if (!m_hPauseEvent)
	{
		MessageBox(_T("   event PauseEvent."), MB_OK);
	}
	m_hStopEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	if (!m_hStopEvent)
	{
		MessageBox(_T("   event StopEvent."), MB_OK);
	}
	if (!m_Board.init())
	{
		MessageBox(_T("    Board."), MB_OK);
		return FALSE;
	}
	m_Board.AttachDebugger(&m_Debugger);

	return TRUE;  //   TRUE,      
}

void CVM1CPPDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

//            ,
//    .    MFC,     ,
//      .

void CVM1CPPDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); //    

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		//      
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

//          
//   .
HCURSOR CVM1CPPDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CVM1CPPDlg::OnBnClickedButtonStart()
{
	// 
	StartWorkerThread();

	GetDlgItem(IDC_BUTTON_START)->EnableWindow(FALSE);
	GetDlgItem(IDC_CHECK_PAUSE)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_STOP)->EnableWindow(TRUE);
}



void CVM1CPPDlg::OnBnClickedButtonStop()
{
	// 
	GetDlgItem(IDC_CHECK_PAUSE)->EnableWindow(FALSE);

	StopWorkerThread();

}

LRESULT CVM1CPPDlg::OnWorkedThreadStopped(WPARAM wParam, LPARAM lParam)
{
	ResetEvent(m_hStopEvent);
	TRACE(_T(",   .\n"));
	GetDlgItem(IDC_BUTTON_START)->EnableWindow(TRUE);
	GetDlgItem(IDC_BUTTON_STOP)->EnableWindow(FALSE);

	return S_OK;
}

UINT AFX_CDECL CVM1CPPDlg::WorkerThreadWrapper(LPVOID lpParam)
{
	CVM1CPPDlg *pThis = reinterpret_cast<CVM1CPPDlg *>(lpParam);
	return pThis->WorkerThreadFunc();
}

UINT CVM1CPPDlg::WorkerThreadFunc()
{
	SetEvent(m_hStartingEvent); //   

	int nDelay = 50;

	m_Board.cpu_start();

	while (WAIT_OBJECT_0 != WaitForSingleObject(m_hStopEvent, 0)) //      
	{
		m_Board.maincycle();

		if (--nDelay <= 0)
		{
			DebugOut();
			nDelay = 50;
		}

		m_Debugger.DisAsm(); //  
		while (WAIT_OBJECT_0 == WaitForSingleObject(m_hPauseEvent, 0))
		{
			Sleep(10);
		}
	}
	ResetEvent(m_hStartingEvent); // ,   
	TRACE(_T("   .\n"));
	PostMessage(WM_ONWORKED_THREAD_STOPPED, 0, 0);
	return 0;
}

void CVM1CPPDlg::StopWorkerThread()
{
	if (WAIT_OBJECT_0 == WaitForSingleObject(m_hStartingEvent, 0)) //  
	{
		TRACE(_T("  .\n"));

		CleanPause();	//  
		SetEvent(m_hStopEvent);		//   
	}
}


BOOL CVM1CPPDlg::StartWorkerThread()
{
	//      
	if (WAIT_OBJECT_0 != WaitForSingleObject(m_hStartingEvent, 0))
	{
		CleanPause();

		if ((m_pWorkerThread = AfxBeginThread(
			WorkerThreadWrapper,
			(void *)this,
			THREAD_PRIORITY_NORMAL,
			0,
			CREATE_SUSPENDED)
			) == NULL)
		{
			MessageBox(_T("    ."), MB_OK);
			return FALSE;
		}
		m_pWorkerThread->m_bAutoDelete = TRUE;
		m_pWorkerThread->ResumeThread();

		TRACE(_T("  .\n"));
	}
	return TRUE;
}

void CVM1CPPDlg::CleanPause()
{
	if (WAIT_OBJECT_0 == WaitForSingleObject(m_hPauseEvent, 0)) //   
	{
		CheckDlgButton(IDC_CHECK_PAUSE, FALSE);	// 
		OnBnClickedCheckPause();				//  .
	}
}

void CVM1CPPDlg::OnBnClickedCheckPause()
{
	m_bPause = (IsDlgButtonChecked(IDC_CHECK_PAUSE) != 0); //,   
	if (m_bPause)
	{
		SetEvent(m_hPauseEvent);	//  -    
		TRACE(_T(" .\n"));
	}
	else
	{
		ResetEvent(m_hPauseEvent);	//  -   
		TRACE(_T(" .\n"));
	}
}

void CVM1CPPDlg::OnDestroy()
{
	OnBnClickedButtonStop();
	hFont.DeleteObject();

	CDialog::OnDestroy();
}


void CVM1CPPDlg::DebugOut()
{

	CString str;
	for (int i = 0; i < 14; ++i)
	{
		str.Format(_T("%06o"), m_Debugger.GetRegister(i));
		SetDlgItemText(nIDCID[i], str);
	}
	str.Format(_T("%06o"), m_Debugger.GetRegister(14));
	SetDlgItemText(IDC_EDIT_DBG_PSW, str);
	str.Format(_T("%06o"), m_Debugger.GetRegister(15));
	SetDlgItemText(IDC_EDIT_DBG_Q, str);

	DebugPLMInterpretator();
	DebugPLIInterpretator();
}

void CVM1CPPDlg::DebugPLMInterpretator()
{
	static TCHAR *strOptypes[8] = {
		_T("nothing"),
		_T("nothing"),
		_T("write word"),
		_T("write byte"),
		_T("read word"),
		_T("read byte"),
		_T("read-modify-write word"),
		_T("read-modify-write byte")
	};
	static TCHAR *strIROptypes[8] = {
		_T("no operation"),
		_T("RTT opcode, wait fetch completion"),
		_T("non-IR data retrieving"),
		_T("usual IR fetch"),
		_T("early IR prefetch"),
		_T("WAIT opcode, check irq only"),
		_T("no operation"),
		_T("~RTT opcode, wait fetch completion")
	};
	static TCHAR *strRegName[16] = {
		_T("Q"),
		_T("R7"),
		_T("R11"),
		_T("R3"),
		_T("R13"),
		_T("R5"),
		_T("R9"),
		_T("R1"),
		_T("PSW"),
		_T("R6"),
		_T("R10"),
		_T("R2"),
		_T("R12"),
		_T("R4"),
		_T("R8"),
		_T("R0")
	};

	CString strResult = _T("");
	CString str = _T("");
	__int64 nPLX = 0;
	for (int i = 33; i >= 0; i--)
	{
		nPLX <<= 1;
		if (m_Debugger.GetWires()->plx[i])
		{
			str += _T("1");
			nPLX++;
		}
		else
		{
			str += _T("0");
		}
	}
	strResult += str + _T("\r\n");
	//   
	WORD mr = m_Debugger.GetMR();
	CString strMR = _T("");
	for (int i = 14; i >= 12; i--)
	{
		strMR += (mr & (1 << i)) ? _T("1") : _T("0");
	}
	strMR += _T(" ");
	strMR += (mr & (1 << 11)) ? _T("T") : _T(".");
	strMR += (mr & (1 << 10)) ? _T("N") : _T(".");
	strMR += (mr & (1 << 9))  ? _T("Z") : _T(".");
	strMR += (mr & (1 << 8))  ? _T("V") : _T(".");
	strMR += (mr & (1 << 7))  ? _T("C") : _T(".");

	str.Format(_T("IR: %06o / MR: %s curr.microcode addr.: 0x%02x(0x%02x)\r\n"), m_Debugger.GetRegs()->ir, strMR, (mr & 0x7f), (~mr & 0x7f));
	strResult += str;
	//   
	int nNext = (m_Debugger.GetWires()->plx[0]  ? 0 : 64)	//6-
			  | (m_Debugger.GetWires()->plx[5]  ? 32 : 0)	//5
			  | (m_Debugger.GetWires()->plx[9]  ? 16 : 0)	//4
			  | (m_Debugger.GetWires()->plx[15] ? 8  : 0)	//3
			  | (m_Debugger.GetWires()->plx[19] ? 0  : 4)	//2-
			  | (m_Debugger.GetWires()->plx[24] ? 0  : 2)	//1-
			  | (m_Debugger.GetWires()->plx[29] ? 0  : 1);	//0-
	int nOp = (nPLX >> 6) & 7;		//QBUS operation type
	int nIROp = (nPLX >> 1) & 7;	//IR register operation

	str.Format(_T("next microcode addr.: 0x%02x(0x%02x)\r\nQBUS operation type: %s\r\nIR register operation: %s\r\n"), nNext, (~nNext & 0x7f), strOptypes[nOp], strIROptypes[nIROp]);
	strResult += str;

	if (m_Debugger.GetRegs()->plm[11] && m_Debugger.GetRegs()->plm[13])
	{
		//Instruction decoding phase
		strResult += _T("Instruction decoding phase.\r\n");
		strResult += (m_Debugger.GetWires()->plx[7] ? _T("\r\n") : _T("set wait mode\r\n"));
		strResult += (m_Debugger.GetWires()->plx[10] ? _T("\r\n") : _T("assert INIT\r\n"));
		strResult += (m_Debugger.GetWires()->plx[12] ? _T("invalid opcode\r\n") : _T("\r\n"));
		str = _T("");
		str += (m_Debugger.GetWires()->plx[17] ? _T("0") : _T("1"));
		str += (m_Debugger.GetWires()->plx[16] ? _T("1") : _T("0"));
		str += (m_Debugger.GetWires()->plx[14] ? _T("0") : _T("1"));
		strResult += _T("Microcode opcode: ") + str + _T("\r\n");
		str.Format(_T("vector selector: %d\r\n"), (nPLX >> 18) & 15);
		strResult += str;
		strResult += (m_Debugger.GetWires()->plx[23] ? _T("\r\n") : _T("deassert INIT\r\n"));
		strResult += (m_Debugger.GetWires()->plx[25] ? _T("\r\n") : _T("set stop mode\r\n"));
		strResult += (m_Debugger.GetWires()->plx[26] ? _T("\r\n") : _T("set error 2\r\n"));
		strResult += (m_Debugger.GetWires()->plx[27] ? _T("\r\n") : _T("reset wait mode/ack interrupt\r\n"));
		strResult += (m_Debugger.GetWires()->plx[28] ? _T("\r\n") : _T("set error 3\r\n"));
		strResult += (m_Debugger.GetWires()->plx[30] ? _T("\r\n") : _T("set error 7\r\n"));
	}
	else
	{
		strResult += _T("PLM phase.\r\n");
		strResult += (m_Debugger.GetWires()->plx[10] ? _T("not to wait data from Q-bus\r\n") : _T("\r\n"));
		strResult += (m_Debugger.GetWires()->plx[12] ? _T("opcode is not recognized\r\n") : _T("\r\n"));

		str.Format(_T("Y bus operand type selector: %d\r\n"), (nPLX >> 11) & 7);
		strResult += str;
		str.Format(_T("ALU opcode: %d\r\n"), (nPLX >> 16) & 3);
		strResult += str;
		strResult += (m_Debugger.GetWires()->plx[18] ? _T("word operation\r\n") : _T("byte operation\r\n"));
		strResult += (m_Debugger.GetWires()->plx[20] ? _T("write ALU result flag to register\r\n") : _T("\r\n"));
		nOp = ((nPLX >> 20) & 6) | (m_Debugger.GetWires()->plx[4] ? 1 : 0);;	//PSW and microcode control (plop)
		str.Format(_T("PSW and microcode control: %d\r\n"), nOp);
		strResult += str;
		strResult += (m_Debugger.GetWires()->plx[23] ? _T("no wait areg free or write completion\r\n") : _T("\r\n"));

		if (!(m_Debugger.GetRegs()->plr[11] || m_Debugger.GetRegs()->plr[13]))
		{
			nOp = (nPLX >> 25) & 15;
			str.Format(_T("Y selector: %s\r\n"), strRegName[nOp]);
			strResult += str;
		}
		else
		{
			strResult += _T("Y selector: none\r\n");
		}
		nOp = (nPLX >> 30) & 15;
		str.Format(_T("X selector: %s\r\n"), strRegName[nOp]);
		strResult += str;
	}

	SetDlgItemText(IDC_EDIT_PLM, strResult);
}
void CVM1CPPDlg::DebugPLIInterpretator()
{
	CString str = _T("");
	for (int i = 10; i >= 0; i--)
	{
		str += m_Debugger.GetWires()->pli[i] ? _T("1") : _T("0");
	}
	SetDlgItemText(IDC_EDIT_PLI, str);
}

