#pragma once

#include "vm1_qbus_shared.h"


#include <string>

// EM_LOG(str) -     
//#define EM_LOG(str)      m_strStepsLog += (str)
#define EM_LOG(str)      fprintf(m_DisLog, "%s", str);fflush(m_DisLog)

// DisasmOut(str) -      
//#define DisasmOut(str)

// LNG(str) -         API 
#define LNG(str)         str

#define GET_WORD(a) (*(WORD *)&aMemory[a])
#define GET_BYTE(a) aMemory[a]


#define BIT_0             01
#define BIT_1             02
#define BIT_2             04
#define BIT_3            010
#define BIT_4            020
#define BIT_5            040
#define BIT_6           0100
#define BIT_7           0200
#define BIT_8           0400
#define BIT_9          01000
#define BIT_10         02000
#define BIT_11         04000
#define BIT_12        010000
#define BIT_13        020000
#define BIT_14        040000
#define BIT_15       0100000
#define BIT_16       0200000
#define BIT_17       0400000
#define BIT_18      01000000
#define BIT_19      02000000
#define BIT_20      04000000
#define BIT_21     010000000
#define BIT_22     020000000
#define BIT_23     040000000
#define BIT_24    0100000000
#define BIT_25    0200000000
#define BIT_26    0400000000
#define BIT_27   01000000000
#define BIT_28   02000000000
#define BIT_29   04000000000
#define BIT_30  010000000000
#define BIT_31  020000000000

class C1801VM1;

class CDebugger
{
	C1801VM1 *m_pCPUObj;

	///////////////////////////////////////////////////////
	//         //
	///////////////////////////////////////////////////////

	WORD	m_Reg[8];					// 
	BYTE	*aMemory;					// 
	BOOL	*abReadAccess;				//         ( TRUE -  , FALSE -   )
	WORD	m_PSW;						//   .

	///////////////////////////////////////////////////////
	FILE *m_DisLog;

	int m_nStartDisasm;

	BOOL		m_bDisAsmLog;      //     
	int			m_nPrintPosition;
	int			m_nR_Operand[9];
	std::string	m_strStepsLog;

	void DisAsmPrint(char *str);
	void SkipPrintToOperandPosition();
	void SkipPrintToCommentsPosition();
	int PrintOperand(BYTE nOpMode, int nOpSize = 2);
	int PrintOperand2(BYTE nOpMode, int nOpSize = 2);

	void PrintPSW(char *str);
	BOOL SnapRON();
public:
	CDebugger();
	~CDebugger();

	void DisAsm();
	void AttachDebugger(C1801VM1 *pCPU){ m_pCPUObj = pCPU; }
	void AttachMemory(BYTE *pMem, BOOL *pAcc){ aMemory = pMem; abReadAccess = pAcc; }
	WORD GetRegister(int nRegNum);
	WORD GetMR();
	VM1_QBUS_WIRES *GetWires();
	VM1_QBUS_REGS *GetRegs();

};

